/*
 * Decompiled with CFR 0.152.
 */
package it.mikypro.pluginhider.packetadapters;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import org.bukkit.plugin.Plugin;

public class PlayClientTabComplete
extends PacketAdapter {
    public PlayClientTabComplete(Plugin plugin, PacketType ... types) {
        super(plugin, types);
    }

    public void onPacketReceiving(PacketEvent event) {
        PacketType packetType = event.getPacketType();
        if (packetType.equals((Object)PacketType.Play.Client.TAB_COMPLETE)) {
            if (event.getPlayer().hasPermission("pluginhider.view.message")) {
                return;
            }
            if (this.plugin.getConfig().getBoolean("blockAllTabCompletions")) {
                event.setCancelled(true);
            } else {
                PacketContainer packetContainer = event.getPacket();
                String message = ((String)packetContainer.getSpecificModifier(String.class).read(0)).toLowerCase();
                if (message.equals("/") || message.contains(":")) {
                    event.setCancelled(true);
                    return;
                }
                if (this.plugin.getConfig().getStringList("defaultBlockedCommands").stream().anyMatch(s -> message.startsWith("/" + s.toLowerCase()))) {
                    event.setCancelled(true);
                }
            }
        }
    }
}

