/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.h2.command;

import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.ListIterator;
import us.ajg0702.leaderboards.libs.h2.command.Token;
import us.ajg0702.leaderboards.libs.h2.engine.CastDataProvider;
import us.ajg0702.leaderboards.libs.h2.message.DbException;
import us.ajg0702.leaderboards.libs.h2.util.StringUtils;
import us.ajg0702.leaderboards.libs.h2.value.ValueBigint;
import us.ajg0702.leaderboards.libs.h2.value.ValueDecfloat;
import us.ajg0702.leaderboards.libs.h2.value.ValueNumeric;

public final class Tokenizer {
    private final CastDataProvider provider;
    private final boolean identifiersToUpper;
    private final boolean identifiersToLower;
    private final BitSet nonKeywords;

    Tokenizer(CastDataProvider castDataProvider, boolean bl, boolean bl2, BitSet bitSet) {
        this.provider = castDataProvider;
        this.identifiersToUpper = bl;
        this.identifiersToLower = bl2;
        this.nonKeywords = bitSet;
    }

    ArrayList<Token> tokenize(String string, boolean bl, BitSet bitSet) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        int n = string.length() - 1;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        block59: while (n3 <= n) {
            Token token;
            int n4 = n3;
            int n5 = string.charAt(n3);
            switch (n5) {
                case 33: {
                    int n6;
                    if (n3 < n) {
                        if ((n6 = string.charAt(++n3)) == 61) {
                            token = new Token.KeywordToken(n4, 100);
                            break;
                        }
                        if (n6 == 126) {
                            token = new Token.KeywordToken(n4, 122);
                            break;
                        }
                    }
                    throw DbException.getSyntaxError(string, n4);
                }
                case 34: 
                case 96: {
                    n3 = this.readQuotedIdentifier(string, n, n4, n3, (char)n5, false, arrayList);
                    continue block59;
                }
                case 35: {
                    if (this.provider.getMode().supportPoundSymbolForColumnNames) {
                        n3 = this.readIdentifier(string, n, n4, n3, n5, arrayList);
                        continue block59;
                    }
                    throw DbException.getSyntaxError(string, n4);
                }
                case 36: {
                    int n6;
                    if (n3 < n) {
                        n6 = string.charAt(n3 + 1);
                        if (n6 == 36) {
                            int n7 = string.indexOf("$$", n3 += 2);
                            if (n7 < 0) {
                                throw DbException.getSyntaxError(string, n4);
                            }
                            token = new Token.CharacterStringToken(n4, string.substring(n3, n7), false);
                            n3 = n7 + 1;
                            break;
                        }
                        n3 = Tokenizer.parseParameterIndex(string, n, n3, arrayList);
                        n2 = Tokenizer.assignParameterIndex(arrayList, n2, bitSet);
                        continue block59;
                    }
                    token = new Token.ParameterToken(n4, 0);
                    break;
                }
                case 37: {
                    token = new Token.KeywordToken(n4, 114);
                    break;
                }
                case 38: {
                    if (n3 < n && string.charAt(n3 + 1) == '&') {
                        ++n3;
                        token = new Token.KeywordToken(n4, 107);
                        break;
                    }
                    throw DbException.getSyntaxError(string, n4);
                }
                case 39: {
                    n3 = Tokenizer.readCharacterString(string, n4, n, n3, false, arrayList);
                    continue block59;
                }
                case 40: {
                    token = new Token.KeywordToken(n4, 105);
                    break;
                }
                case 41: {
                    token = new Token.KeywordToken(n4, 106);
                    if (!bl) break;
                    arrayList.add(token);
                    n = Tokenizer.skipWhitespace(string, n, n3 + 1) - 1;
                    break block59;
                }
                case 42: {
                    token = new Token.KeywordToken(n4, 108);
                    break;
                }
                case 43: {
                    token = new Token.KeywordToken(n4, 103);
                    break;
                }
                case 44: {
                    token = new Token.KeywordToken(n4, 109);
                    break;
                }
                case 45: {
                    if (n3 < n && string.charAt(n3 + 1) == '-') {
                        n3 = Tokenizer.skipSimpleComment(string, n, n3);
                        continue block59;
                    }
                    token = new Token.KeywordToken(n4, 102);
                    break;
                }
                case 46: {
                    int n6;
                    if (n3 < n && (n6 = string.charAt(n3 + 1)) >= 48 && n6 <= 57) {
                        n3 = Tokenizer.readNumeric(string, n4, n, n3 + 1, (char)n6, false, false, arrayList);
                        continue block59;
                    }
                    token = new Token.KeywordToken(n4, 110);
                    break;
                }
                case 47: {
                    int n6;
                    if (n3 < n) {
                        n6 = string.charAt(n3 + 1);
                        if (n6 == 42) {
                            n3 = Tokenizer.skipBracketedComment(string, n4, n, n3);
                            continue block59;
                        }
                        if (n6 == 47) {
                            n3 = Tokenizer.skipSimpleComment(string, n, n3);
                            continue block59;
                        }
                    }
                    token = new Token.KeywordToken(n4, 113);
                    break;
                }
                case 48: {
                    int n6;
                    if (n3 < n && ((n6 = string.charAt(n3 + 1)) == 88 || n6 == 120)) {
                        n3 = Tokenizer.readHexNumber(string, this.provider, n4, n, n3 + 2, arrayList);
                        continue block59;
                    }
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    n3 = Tokenizer.readNumeric(string, n4, n, n3 + 1, (char)n5, arrayList);
                    continue block59;
                }
                case 58: {
                    int n6;
                    if (n3 < n) {
                        n6 = string.charAt(n3 + 1);
                        if (n6 == 58) {
                            ++n3;
                            token = new Token.KeywordToken(n4, 120);
                            break;
                        }
                        if (n6 == 61) {
                            ++n3;
                            token = new Token.KeywordToken(n4, 121);
                            break;
                        }
                    }
                    token = new Token.KeywordToken(n4, 116);
                    break;
                }
                case 59: {
                    token = new Token.KeywordToken(n4, 115);
                    break;
                }
                case 60: {
                    int n6;
                    if (n3 < n) {
                        n6 = string.charAt(n3 + 1);
                        if (n6 == 61) {
                            ++n3;
                            token = new Token.KeywordToken(n4, 99);
                            break;
                        }
                        if (n6 == 62) {
                            ++n3;
                            token = new Token.KeywordToken(n4, 100);
                            break;
                        }
                    }
                    token = new Token.KeywordToken(n4, 98);
                    break;
                }
                case 61: {
                    token = new Token.KeywordToken(n4, 95);
                    break;
                }
                case 62: {
                    if (n3 < n && string.charAt(n3 + 1) == '=') {
                        ++n3;
                        token = new Token.KeywordToken(n4, 96);
                        break;
                    }
                    token = new Token.KeywordToken(n4, 97);
                    break;
                }
                case 63: {
                    int n6;
                    if (n3 + 1 < n && string.charAt(n3 + 1) == '?') {
                        n6 = string.charAt(n3 + 2);
                        if (n6 == 40) {
                            n3 += 2;
                            token = new Token.KeywordToken(n4, 117);
                            break;
                        }
                        if (n6 == 41) {
                            n3 += 2;
                            token = new Token.KeywordToken(n4, 118);
                            break;
                        }
                    }
                    n3 = Tokenizer.parseParameterIndex(string, n, n3, arrayList);
                    n2 = Tokenizer.assignParameterIndex(arrayList, n2, bitSet);
                    continue block59;
                }
                case 64: {
                    token = new Token.KeywordToken(n4, 101);
                    break;
                }
                case 65: 
                case 97: {
                    n3 = this.readA(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 66: 
                case 98: {
                    n3 = this.readB(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 67: 
                case 99: {
                    n3 = this.readC(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 68: 
                case 100: {
                    n3 = this.readD(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 69: 
                case 101: {
                    n3 = this.readE(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 70: 
                case 102: {
                    n3 = this.readF(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 71: 
                case 103: {
                    n3 = this.readG(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 72: 
                case 104: {
                    n3 = this.readH(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 73: 
                case 105: {
                    n3 = this.readI(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 74: 
                case 106: {
                    n3 = this.readJ(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 75: 
                case 107: {
                    n3 = this.readK(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 76: 
                case 108: {
                    n3 = this.readL(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 77: 
                case 109: {
                    n3 = this.readM(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 78: 
                case 110: {
                    if (n3 < n && string.charAt(n3 + 1) == '\'') {
                        n3 = Tokenizer.readCharacterString(string, n4, n, n3 + 1, false, arrayList);
                        continue block59;
                    }
                    n3 = this.readN(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 79: 
                case 111: {
                    n3 = this.readO(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 80: 
                case 112: {
                    n3 = this.readP(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 81: 
                case 113: {
                    n3 = this.readQ(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 82: 
                case 114: {
                    n3 = this.readR(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 83: 
                case 115: {
                    n3 = this.readS(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 84: 
                case 116: {
                    n3 = this.readT(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 85: 
                case 117: {
                    int n6;
                    if (n3 + 1 < n && string.charAt(n3 + 1) == '&') {
                        n6 = string.charAt(n3 + 2);
                        if (n6 == 34) {
                            n3 = this.readQuotedIdentifier(string, n, n4, n3 + 2, '\"', true, arrayList);
                            bl2 = true;
                            continue block59;
                        }
                        if (n6 == 39) {
                            n3 = Tokenizer.readCharacterString(string, n4, n, n3 + 2, true, arrayList);
                            bl2 = true;
                            continue block59;
                        }
                    }
                    n3 = this.readU(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 86: 
                case 118: {
                    n3 = this.readV(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 87: 
                case 119: {
                    n3 = this.readW(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 88: 
                case 120: {
                    if (n3 < n && string.charAt(n3 + 1) == '\'') {
                        n3 = Tokenizer.readBinaryString(string, n4, n, n3 + 1, arrayList);
                        continue block59;
                    }
                    n3 = this.readIdentifier(string, n, n4, n3, n5, arrayList);
                    continue block59;
                }
                case 89: 
                case 121: {
                    n3 = this.readY(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 90: 
                case 122: {
                    n3 = this.readIdentifier(string, n, n4, n3, n5, arrayList);
                    continue block59;
                }
                case 91: {
                    int n6;
                    if (this.provider.getMode().squareBracketQuotedNames) {
                        if ((n6 = string.indexOf(93, ++n3)) < 0) {
                            throw DbException.getSyntaxError(string, n4);
                        }
                        token = new Token.IdentifierToken(n4, string.substring(n3, n6), true, false);
                        n3 = n6;
                        break;
                    }
                    token = new Token.KeywordToken(n4, 117);
                    break;
                }
                case 93: {
                    token = new Token.KeywordToken(n4, 118);
                    break;
                }
                case 95: {
                    n3 = this.read_(string, n, n4, n3, arrayList);
                    continue block59;
                }
                case 123: {
                    token = new Token.KeywordToken(n4, 111);
                    break;
                }
                case 124: {
                    if (n3 < n && string.charAt(++n3) == '|') {
                        token = new Token.KeywordToken(n4, 104);
                        break;
                    }
                    throw DbException.getSyntaxError(string, n4);
                }
                case 125: {
                    token = new Token.KeywordToken(n4, 112);
                    break;
                }
                case 126: {
                    token = new Token.KeywordToken(n4, 119);
                    break;
                }
                default: {
                    if (n5 <= 32) {
                        ++n3;
                        continue block59;
                    }
                    int n6 = Character.isHighSurrogate((char)n5) ? string.codePointAt(n3++) : n5;
                    if (Character.isSpaceChar(n6)) continue block59;
                    if (Character.isJavaIdentifierStart(n6)) {
                        n3 = this.readIdentifier(string, n, n4, n3, n6, arrayList);
                        continue block59;
                    }
                    throw DbException.getSyntaxError(string, n4);
                }
            }
            arrayList.add(token);
            ++n3;
        }
        if (bl2) {
            Tokenizer.processUescape(string, arrayList);
        }
        arrayList.add(new Token.EndOfInputToken(n + 1));
        return arrayList;
    }

    private int readIdentifier(String string, int n, int n2, int n3, int n4, ArrayList<Token> arrayList) {
        if (n4 >= 65536) {
            ++n3;
        }
        int n5 = this.findIdentifierEnd(string, n, n3 + Character.charCount(n4) - 1);
        arrayList.add(new Token.IdentifierToken(n2, this.extractIdentifier(string, n2, n5), false, false));
        return n5;
    }

    private int readA(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = n5 == 2 ? ((string.charAt(n2 + 1) & 0xFFDF) == 83 ? 7 : 2) : (Tokenizer.eq("ALL", string, n2, n5) ? 3 : (Tokenizer.eq("AND", string, n2, n5) ? 4 : (Tokenizer.eq("ANY", string, n2, n5) ? 5 : (Tokenizer.eq("ARRAY", string, n2, n5) ? 6 : (Tokenizer.eq("ASYMMETRIC", string, n2, n5) ? 8 : (Tokenizer.eq("AUTHORIZATION", string, n2, n5) ? 9 : 2))))));
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readB(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("BETWEEN", string, n2, n5) ? 10 : 2;
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readC(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("CASE", string, n2, n5) ? 11 : (Tokenizer.eq("CAST", string, n2, n5) ? 12 : (Tokenizer.eq("CHECK", string, n2, n5) ? 13 : (Tokenizer.eq("CONSTRAINT", string, n2, n5) ? 14 : (Tokenizer.eq("CROSS", string, n2, n5) ? 15 : (n5 >= 12 && Tokenizer.eq("CURRENT_", string, n2, 8) ? Tokenizer.getTokenTypeCurrent(string, n2, n5) : 2)))));
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private static int getTokenTypeCurrent(String string, int n, int n2) {
        n += 8;
        switch (n2) {
            case 12: {
                if (Tokenizer.eqCurrent("CURRENT_DATE", string, n, n2)) {
                    return 17;
                }
                if (Tokenizer.eqCurrent("CURRENT_PATH", string, n, n2)) {
                    return 18;
                }
                if (Tokenizer.eqCurrent("CURRENT_ROLE", string, n, n2)) {
                    return 19;
                }
                if (Tokenizer.eqCurrent("CURRENT_TIME", string, n, n2)) {
                    return 21;
                }
                if (!Tokenizer.eqCurrent("CURRENT_USER", string, n, n2)) break;
                return 23;
            }
            case 14: {
                if (!Tokenizer.eqCurrent("CURRENT_SCHEMA", string, n, n2)) break;
                return 20;
            }
            case 15: {
                if (!Tokenizer.eqCurrent("CURRENT_CATALOG", string, n, n2)) break;
                return 16;
            }
            case 17: {
                if (!Tokenizer.eqCurrent("CURRENT_TIMESTAMP", string, n, n2)) break;
                return 22;
            }
        }
        return 2;
    }

    private static boolean eqCurrent(String string, String string2, int n, int n2) {
        for (int i = 8; i < n2; ++i) {
            if (string.charAt(i) == (string2.charAt(n++) & 0xFFDF)) continue;
            return false;
        }
        return true;
    }

    private int readD(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("DAY", string, n2, n5) ? 24 : (Tokenizer.eq("DEFAULT", string, n2, n5) ? 25 : (Tokenizer.eq("DISTINCT", string, n2, n5) ? 26 : 2));
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readE(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("ELSE", string, n2, n5) ? 27 : (Tokenizer.eq("END", string, n2, n5) ? 28 : (Tokenizer.eq("EXCEPT", string, n2, n5) ? 29 : (Tokenizer.eq("EXISTS", string, n2, n5) ? 30 : 2)));
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readF(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("FETCH", string, n2, n5) ? 32 : (Tokenizer.eq("FROM", string, n2, n5) ? 35 : (Tokenizer.eq("FOR", string, n2, n5) ? 33 : (Tokenizer.eq("FOREIGN", string, n2, n5) ? 34 : (Tokenizer.eq("FULL", string, n2, n5) ? 36 : (Tokenizer.eq("FALSE", string, n2, n5) ? 31 : 2)))));
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readG(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("GROUP", string, n2, n5) ? 37 : 2;
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readH(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("HAVING", string, n2, n5) ? 38 : (Tokenizer.eq("HOUR", string, n2, n5) ? 39 : 2);
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readI(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4;
        int n5 = this.findIdentifierEnd(string, n, n3);
        int n6 = n5 - n2;
        if (n6 == 2) {
            switch (string.charAt(n2 + 1) & 0xFFDF) {
                case 70: {
                    n4 = 40;
                    break;
                }
                case 78: {
                    n4 = 41;
                    break;
                }
                case 83: {
                    n4 = 45;
                    break;
                }
                default: {
                    n4 = 2;
                    break;
                }
            }
        } else {
            n4 = Tokenizer.eq("INNER", string, n2, n6) ? 42 : (Tokenizer.eq("INTERSECT", string, n2, n6) ? 43 : (Tokenizer.eq("INTERVAL", string, n2, n6) ? 44 : 2));
        }
        return this.readIdentifierOrKeyword(string, n2, arrayList, n5, n4);
    }

    private int readJ(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("JOIN", string, n2, n5) ? 46 : 2;
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readK(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("KEY", string, n2, n5) ? 47 : 2;
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readL(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("LEFT", string, n2, n5) ? 48 : (Tokenizer.eq("LIMIT", string, n2, n5) ? (this.provider.getMode().limit ? 50 : 2) : (Tokenizer.eq("LIKE", string, n2, n5) ? 49 : (Tokenizer.eq("LOCALTIME", string, n2, n5) ? 51 : (Tokenizer.eq("LOCALTIMESTAMP", string, n2, n5) ? 52 : 2))));
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readM(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("MINUS", string, n2, n5) ? (this.provider.getMode().minusIsExcept ? 53 : 2) : (Tokenizer.eq("MINUTE", string, n2, n5) ? 54 : (Tokenizer.eq("MONTH", string, n2, n5) ? 55 : 2));
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readN(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("NOT", string, n2, n5) ? 57 : (Tokenizer.eq("NATURAL", string, n2, n5) ? 56 : (Tokenizer.eq("NULL", string, n2, n5) ? 58 : 2));
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readO(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4;
        int n5 = this.findIdentifierEnd(string, n, n3);
        int n6 = n5 - n2;
        if (n6 == 2) {
            switch (string.charAt(n2 + 1) & 0xFFDF) {
                case 78: {
                    n4 = 60;
                    break;
                }
                case 82: {
                    n4 = 61;
                    break;
                }
                default: {
                    n4 = 2;
                    break;
                }
            }
        } else {
            n4 = Tokenizer.eq("OFFSET", string, n2, n6) ? 59 : (Tokenizer.eq("ORDER", string, n2, n6) ? 62 : 2);
        }
        return this.readIdentifierOrKeyword(string, n2, arrayList, n5, n4);
    }

    private int readP(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("PRIMARY", string, n2, n5) ? 63 : 2;
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readQ(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("QUALIFY", string, n2, n5) ? 64 : 2;
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readR(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("RIGHT", string, n2, n5) ? 65 : (Tokenizer.eq("ROW", string, n2, n5) ? 66 : (Tokenizer.eq("ROWNUM", string, n2, n5) ? 67 : 2));
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readS(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("SECOND", string, n2, n5) ? 68 : (Tokenizer.eq("SELECT", string, n2, n5) ? 69 : (Tokenizer.eq("SESSION_USER", string, n2, n5) ? 70 : (Tokenizer.eq("SET", string, n2, n5) ? 71 : (Tokenizer.eq("SOME", string, n2, n5) ? 72 : (Tokenizer.eq("SYMMETRIC", string, n2, n5) ? 73 : (Tokenizer.eq("SYSTEM_USER", string, n2, n5) ? 74 : 2))))));
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readT(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = n5 == 2 ? ((string.charAt(n2 + 1) & 0xFFDF) == 79 ? 76 : 2) : (Tokenizer.eq("TABLE", string, n2, n5) ? 75 : (Tokenizer.eq("TRUE", string, n2, n5) ? 77 : 2));
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readU(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("UESCAPE", string, n2, n5) ? 78 : (Tokenizer.eq("UNION", string, n2, n5) ? 79 : (Tokenizer.eq("UNIQUE", string, n2, n5) ? 80 : (Tokenizer.eq("UNKNOWN", string, n2, n5) ? 81 : (Tokenizer.eq("USER", string, n2, n5) ? 82 : (Tokenizer.eq("USING", string, n2, n5) ? 83 : 2)))));
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readV(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("VALUE", string, n2, n5) ? 84 : (Tokenizer.eq("VALUES", string, n2, n5) ? 85 : 2);
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readW(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("WHEN", string, n2, n5) ? 86 : (Tokenizer.eq("WHERE", string, n2, n5) ? 87 : (Tokenizer.eq("WINDOW", string, n2, n5) ? 88 : (Tokenizer.eq("WITH", string, n2, n5) ? 89 : 2)));
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int readY(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2;
        int n6 = Tokenizer.eq("YEAR", string, n2, n5) ? 90 : 2;
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n6);
    }

    private int read_(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4 = this.findIdentifierEnd(string, n, n3);
        int n5 = n4 - n2 == 7 && "_ROWID_".regionMatches(true, 1, string, n2 + 1, 6) ? 91 : 2;
        return this.readIdentifierOrKeyword(string, n2, arrayList, n4, n5);
    }

    private int readIdentifierOrKeyword(String string, int n, ArrayList<Token> arrayList, int n2, int n3) {
        Token token = n3 == 2 ? new Token.IdentifierToken(n, this.extractIdentifier(string, n, n2), false, false) : (this.nonKeywords != null && this.nonKeywords.get(n3) ? new Token.KeywordOrIdentifierToken(n, n3, this.extractIdentifier(string, n, n2)) : new Token.KeywordToken(n, n3));
        arrayList.add(token);
        return n2;
    }

    private static boolean eq(String string, String string2, int n, int n2) {
        if (n2 != string.length()) {
            return false;
        }
        for (int i = 1; i < n2; ++i) {
            if (string.charAt(i) == (string2.charAt(++n) & 0xFFDF)) continue;
            return false;
        }
        return true;
    }

    private int findIdentifierEnd(String string, int n, int n2) {
        int n3;
        ++n2;
        while (n2 <= n && (Character.isJavaIdentifierPart(n3 = string.codePointAt(n2)) || n3 == 35 && this.provider.getMode().supportPoundSymbolForColumnNames)) {
            n2 += Character.charCount(n3);
        }
        return n2;
    }

    private String extractIdentifier(String string, int n, int n2) {
        return this.convertCase(string.substring(n, n2));
    }

    private int readQuotedIdentifier(String string, int n, int n2, int n3, char c, boolean bl, ArrayList<Token> arrayList) {
        int n4;
        if ((n4 = string.indexOf(c, ++n3)) < 0) {
            throw DbException.getSyntaxError(string, n2);
        }
        String string2 = string.substring(n3, n4);
        n3 = n4 + 1;
        if (n3 <= n && string.charAt(n3) == c) {
            StringBuilder stringBuilder = new StringBuilder(string2);
            do {
                if ((n4 = string.indexOf(c, n3 + 1)) < 0) {
                    throw DbException.getSyntaxError(string, n2);
                }
                stringBuilder.append(string, n3, n4);
            } while ((n3 = n4 + 1) <= n && string.charAt(n3) == c);
            string2 = stringBuilder.toString();
        }
        if (c == '`') {
            string2 = this.convertCase(string2);
        }
        arrayList.add(new Token.IdentifierToken(n2, string2, true, bl));
        return n3;
    }

    private String convertCase(String string) {
        if (this.identifiersToUpper) {
            string = StringUtils.toUpperEnglish(string);
        } else if (this.identifiersToLower) {
            string = StringUtils.toLowerEnglish(string);
        }
        return string;
    }

    private static int readBinaryString(String string, int n, int n2, int n3, ArrayList<Token> arrayList) {
        int n4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        do {
            if ((n4 = string.indexOf(39, ++n3)) < 0 || n4 < n2 && string.charAt(n4 + 1) == '\'') {
                throw DbException.getSyntaxError(string, n);
            }
            StringUtils.convertHexWithSpacesToBytes(byteArrayOutputStream, string, n3, n4);
        } while ((n3 = Tokenizer.skipWhitespace(string, n2, n4 + 1)) <= n2 && string.charAt(n3) == '\'');
        arrayList.add(new Token.BinaryStringToken(n, byteArrayOutputStream.toByteArray()));
        return n3;
    }

    private static int readCharacterString(String string, int n, int n2, int n3, boolean bl, ArrayList<Token> arrayList) {
        String string2 = null;
        StringBuilder stringBuilder = null;
        do {
            int n4;
            if ((n4 = string.indexOf(39, ++n3)) < 0) {
                throw DbException.getSyntaxError(string, n);
            }
            if (string2 == null) {
                string2 = string.substring(n3, n4);
            } else {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string2);
                }
                stringBuilder.append(string, n3, n4);
            }
            n3 = n4 + 1;
            if (n3 > n2 || string.charAt(n3) != '\'') continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(string2);
            }
            do {
                if ((n4 = string.indexOf(39, n3 + 1)) < 0) {
                    throw DbException.getSyntaxError(string, n);
                }
                stringBuilder.append(string, n3, n4);
            } while ((n3 = n4 + 1) <= n2 && string.charAt(n3) == '\'');
        } while ((n3 = Tokenizer.skipWhitespace(string, n2, n3)) <= n2 && string.charAt(n3) == '\'');
        if (stringBuilder != null) {
            string2 = stringBuilder.toString();
        }
        arrayList.add(new Token.CharacterStringToken(n, string2, bl));
        return n3;
    }

    private static int skipWhitespace(String string, int n, int n2) {
        while (n2 <= n) {
            int n3 = string.codePointAt(n2);
            if (!Character.isWhitespace(n3)) {
                if (n3 != 47 || n2 >= n) break;
                char c = string.charAt(n2 + 1);
                if (c == '*') {
                    n2 = Tokenizer.skipBracketedComment(string, n2, n, n2);
                    continue;
                }
                if (c != '/') break;
                n2 = Tokenizer.skipSimpleComment(string, n, n2);
                continue;
            }
            n2 += Character.charCount(n3);
        }
        return n2;
    }

    private static int readHexNumber(String string, CastDataProvider castDataProvider, int n, int n2, int n3, ArrayList<Token> arrayList) {
        boolean bl;
        char c;
        if (castDataProvider.getMode().zeroExLiteralsAreBinaryStrings) {
            char c2;
            int n4 = n3;
            while (n3 <= n2 && ((c2 = string.charAt(n3)) >= '0' && c2 <= '9' || (c2 = (char)(c2 & 0xFFDF)) >= 'A' && c2 <= 'F')) {
                ++n3;
            }
            if (n3 <= n2 && Character.isJavaIdentifierPart(string.codePointAt(n3))) {
                throw DbException.get(90004, string.substring(n4, n3 + 1));
            }
            arrayList.add(new Token.BinaryStringToken(n4, StringUtils.convertHexToBytes(string.substring(n4, n3))));
            return n3;
        }
        if (n3 > n2) {
            throw DbException.getSyntaxError(string, n, "Hex number");
        }
        int n5 = n3;
        long l = 0L;
        do {
            if ((c = string.charAt(n3)) >= '0' && c <= '9') {
                l = (l << 4) + (long)c - 48L;
            } else if ((c = (char)(c & 0xFFDF)) >= 'A' && c <= 'F') {
                l = (l << 4) + (long)c - 55L;
            } else {
                if (n3 != n5) break;
                throw DbException.getSyntaxError(string, n, "Hex number");
            }
            if (l <= Integer.MAX_VALUE) continue;
            while (++n3 <= n2 && ((c = string.charAt(n3)) >= '0' && c <= '9' || (c = (char)(c & 0xFFDF)) >= 'A' && c <= 'F')) {
            }
            return Tokenizer.finishBigInteger(string, n, n2, n3, n5, n3 <= n2 && c == 'L', 16, arrayList);
        } while (++n3 <= n2);
        boolean bl2 = bl = n3 <= n2 && c == 'L';
        if (bl) {
            ++n3;
        }
        if (n3 <= n2 && Character.isJavaIdentifierPart(string.codePointAt(n3))) {
            throw DbException.getSyntaxError(string, n, "Hex number");
        }
        arrayList.add(bl ? new Token.BigintToken(n5, l) : new Token.IntegerToken(n5, (int)l));
        return n3;
    }

    private static int readNumeric(String string, int n, int n2, int n3, char c, ArrayList<Token> arrayList) {
        long l = c - 48;
        while (n3 <= n2) {
            c = string.charAt(n3);
            if (c < '0' || c > '9') {
                switch (c) {
                    case '.': {
                        return Tokenizer.readNumeric(string, n, n2, n3, c, false, false, arrayList);
                    }
                    case 'E': 
                    case 'e': {
                        return Tokenizer.readNumeric(string, n, n2, n3, c, false, true, arrayList);
                    }
                    case 'L': 
                    case 'l': {
                        return Tokenizer.finishBigInteger(string, n, n2, n3, n, true, 10, arrayList);
                    }
                }
                break;
            }
            if ((l = l * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                return Tokenizer.readNumeric(string, n, n2, n3, c, true, false, arrayList);
            }
            ++n3;
        }
        arrayList.add(new Token.IntegerToken(n, (int)l));
        return n3;
    }

    private static int readNumeric(String string, int n, int n2, int n3, char c, boolean bl, boolean bl2, ArrayList<Token> arrayList) {
        BigDecimal bigDecimal;
        if (!bl2) {
            while (++n3 <= n2) {
                c = string.charAt(n3);
                if (c == '.') {
                    bl = false;
                    continue;
                }
                if (c >= '0' && c <= '9') continue;
            }
        }
        if (n3 <= n2 && (c == 'E' || c == 'e')) {
            bl = false;
            bl2 = true;
            if (n3 == n2) {
                throw DbException.getSyntaxError(string, n);
            }
            if ((c = string.charAt(++n3)) == '+' || c == '-') {
                if (n3 == n2) {
                    throw DbException.getSyntaxError(string, n);
                }
                c = string.charAt(++n3);
            }
            if (c < '0' || c > '9') {
                throw DbException.getSyntaxError(string, n);
            }
            while (++n3 <= n2 && (c = string.charAt(n3)) >= '0' && c <= '9') {
            }
        }
        if (bl) {
            return Tokenizer.finishBigInteger(string, n, n2, n3, n, n3 < n2 && c == 'L' || c == 'l', 10, arrayList);
        }
        String string2 = string.substring(n, n3);
        try {
            bigDecimal = new BigDecimal(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw DbException.get(22018, numberFormatException, string2);
        }
        arrayList.add(new Token.ValueToken(n, bl2 ? ValueDecfloat.get(bigDecimal) : ValueNumeric.get(bigDecimal)));
        return n3;
    }

    private static int finishBigInteger(String string, int n, int n2, int n3, int n4, boolean bl, int n5, ArrayList<Token> arrayList) {
        Token.LiteralToken literalToken;
        int n6 = n3++;
        if (bl) {
            // empty if block
        }
        if (n5 == 16 && n3 <= n2 && Character.isJavaIdentifierPart(string.codePointAt(n3))) {
            throw DbException.getSyntaxError(string, n, "Hex number");
        }
        BigInteger bigInteger = new BigInteger(string.substring(n4, n6), n5);
        if (bigInteger.compareTo(ValueBigint.MAX_BI) > 0) {
            if (bl) {
                throw DbException.getSyntaxError(string, n);
            }
            literalToken = new Token.ValueToken(n, ValueNumeric.get(bigInteger));
        } else {
            literalToken = new Token.BigintToken(n4, bigInteger.longValue());
        }
        arrayList.add(literalToken);
        return n3;
    }

    private static int skipBracketedComment(String string, int n, int n2, int n3) {
        n3 += 2;
        int n4 = 1;
        block0: while (n4 > 0) {
            while (true) {
                char c;
                if (n3 >= n2) {
                    throw DbException.getSyntaxError(string, n);
                }
                if ((c = string.charAt(n3++)) == '*') {
                    if (string.charAt(n3) != '/') continue;
                    --n4;
                    ++n3;
                    continue block0;
                }
                if (c != '/' || string.charAt(n3) != '*') continue;
                ++n4;
                ++n3;
            }
        }
        return n3;
    }

    private static int skipSimpleComment(String string, int n, int n2) {
        char c;
        n2 += 2;
        while (n2 <= n && (c = string.charAt(n2)) != '\n' && c != '\r') {
            ++n2;
        }
        return n2;
    }

    private static int parseParameterIndex(String string, int n, int n2, ArrayList<Token> arrayList) {
        char c;
        int n3 = n2;
        long l = 0L;
        while (++n2 <= n && (c = string.charAt(n2)) >= '0' && c <= '9') {
            if ((l = l * 10L + (long)(c - 48)) <= Integer.MAX_VALUE) continue;
            throw DbException.getInvalidValueException("parameter index", l);
        }
        if (n2 > n3 + 1 && l == 0L) {
            throw DbException.getInvalidValueException("parameter index", l);
        }
        arrayList.add(new Token.ParameterToken(n3, (int)l));
        return n2;
    }

    private static int assignParameterIndex(ArrayList<Token> arrayList, int n, BitSet bitSet) {
        Token.ParameterToken parameterToken = (Token.ParameterToken)arrayList.get(arrayList.size() - 1);
        int n2 = parameterToken.index;
        if (n2 == 0) {
            if (n < 0) {
                throw DbException.get(90123);
            }
            parameterToken.index = n2 = ++n;
        } else {
            if (n > 0) {
                throw DbException.get(90123);
            }
            n = -1;
        }
        bitSet.set(n2 - 1);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processUescape(String string, ArrayList<Token> arrayList) {
        ListIterator<Token> listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            Token token;
            Token token2 = listIterator.next();
            if (!token2.needsUnicodeConversion()) continue;
            int n = 92;
            if (listIterator.hasNext() && (token = listIterator.next()).tokenType() == 78) {
                int n2;
                String string2;
                listIterator.remove();
                if (!listIterator.hasNext()) throw DbException.getSyntaxError(string, token.start() + 7, "'<Unicode escape character>'");
                Token token3 = listIterator.next();
                listIterator.remove();
                if (!(token3 instanceof Token.CharacterStringToken) || (string2 = ((Token.CharacterStringToken)token3).string).codePointCount(0, string2.length()) != 1 || Character.isWhitespace(n2 = string2.codePointAt(0)) || n2 >= 48 && n2 <= 57 || n2 >= 65 && n2 <= 70 || n2 >= 97 && n2 <= 102) throw DbException.getSyntaxError(string, token.start() + 7, "'<Unicode escape character>'");
                switch (n2) {
                    default: {
                        n = n2;
                        break;
                    }
                    case 34: 
                    case 39: 
                    case 43: {
                        throw DbException.getSyntaxError(string, token.start() + 7, "'<Unicode escape character>'");
                    }
                }
            }
            token2.convertUnicode(n);
        }
    }
}

