/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.blacklist.target;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Range;
import com.sk89q.worldedit.blocks.ItemType;
import com.sk89q.worldguard.blacklist.target.DataValueRangeMatcher;
import com.sk89q.worldguard.blacklist.target.TargetMatcher;
import com.sk89q.worldguard.blacklist.target.TargetMatcherParseException;
import com.sk89q.worldguard.blacklist.target.WildcardDataMatcher;
import com.sk89q.worldguard.util.Enums;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Material;

public class TargetMatcherParser {
    private static final Pattern DATA_VALUE_PATTERN = Pattern.compile("^([^:]+):([^:]+)$");
    private static final Pattern LESS_THAN_PATTERN = Pattern.compile("^<=\\s*([0-9]+)$");
    private static final Pattern GREATER_THAN_PATTERN = Pattern.compile("^>=\\s*([0-9]+)$");
    private static final Pattern RANGE_PATTERN = Pattern.compile("^([0-9]+)\\s*-\\s*([0-9]+)$");

    public TargetMatcher fromInput(String input) throws TargetMatcherParseException {
        Matcher matcher = DATA_VALUE_PATTERN.matcher(input.trim());
        if (matcher.matches()) {
            return new DataValueRangeMatcher(this.parseType(matcher.group(1)), this.parseDataValueRanges(matcher.group(2)));
        }
        return new WildcardDataMatcher(this.parseType(input));
    }

    private int parseType(String input) throws TargetMatcherParseException {
        input = input.trim();
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            Material material = Enums.findFuzzyByValue(Material.class, input);
            if (material != null) {
                return material.getId();
            }
            int id = TargetMatcherParser.getItemID(input);
            if (id > 0) {
                return id;
            }
            throw new TargetMatcherParseException("Unknown block or item name: " + input);
        }
    }

    private Predicate<Short> parseDataValueRanges(String input) throws TargetMatcherParseException {
        ArrayList<Predicate<Short>> predicates = new ArrayList<Predicate<Short>>();
        for (String part : input.split(";")) {
            predicates.add(this.parseRange(part));
        }
        return Predicates.or(predicates);
    }

    private Predicate<Short> parseRange(String input) throws TargetMatcherParseException {
        Matcher matcher = LESS_THAN_PATTERN.matcher(input = input.trim());
        if (matcher.matches()) {
            return Range.atMost((Comparable)Short.valueOf(Short.parseShort(matcher.group(1))));
        }
        matcher = GREATER_THAN_PATTERN.matcher(input);
        if (matcher.matches()) {
            return Range.atLeast((Comparable)Short.valueOf(Short.parseShort(matcher.group(1))));
        }
        matcher = RANGE_PATTERN.matcher(input);
        if (matcher.matches()) {
            return Range.closed((Comparable)Short.valueOf(Short.parseShort(matcher.group(1))), (Comparable)Short.valueOf(Short.parseShort(matcher.group(2))));
        }
        try {
            short s = Short.parseShort(input);
            return Range.closed((Comparable)Short.valueOf(s), (Comparable)Short.valueOf(s));
        }
        catch (NumberFormatException e) {
            throw new TargetMatcherParseException("Unknown data value range: " + input);
        }
    }

    private static int getItemID(String name) {
        ItemType type = ItemType.lookup((String)name);
        if (type != null) {
            return type.getID();
        }
        return -1;
    }
}

