/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.commands.region;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.selections.CuboidSelection;
import com.sk89q.worldedit.bukkit.selections.Polygonal2DSelection;
import com.sk89q.worldedit.bukkit.selections.Selection;
import com.sk89q.worldguard.bukkit.RegionContainer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.permission.RegionPermissionModel;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.FlagContext;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.GlobalProtectedRegion;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class RegionCommandsBase {
    protected RegionCommandsBase() {
    }

    protected static RegionPermissionModel getPermissionModel(CommandSender sender) {
        return new RegionPermissionModel(WorldGuardPlugin.inst(), sender);
    }

    protected static World checkWorld(CommandContext args, CommandSender sender, char flag) throws CommandException {
        if (args.hasFlag(flag)) {
            return WorldGuardPlugin.inst().matchWorld(sender, args.getFlag(flag));
        }
        if (sender instanceof Player) {
            return WorldGuardPlugin.inst().checkPlayer(sender).getWorld();
        }
        throw new CommandException("Please specify the world with -" + flag + " world_name.");
    }

    protected static String checkRegionId(String id, boolean allowGlobal) throws CommandException {
        if (!ProtectedRegion.isValidId(id)) {
            throw new CommandException("The region name of '" + id + "' contains characters that are not allowed.");
        }
        if (!allowGlobal && id.equalsIgnoreCase("__global__")) {
            throw new CommandException("Sorry, you can't use __global__ here.");
        }
        return id;
    }

    protected static ProtectedRegion checkExistingRegion(RegionManager regionManager, String id, boolean allowGlobal) throws CommandException {
        RegionCommandsBase.checkRegionId(id, allowGlobal);
        ProtectedRegion region = regionManager.getRegion(id);
        if (region == null) {
            if (id.equalsIgnoreCase("__global__")) {
                region = new GlobalProtectedRegion(id);
                regionManager.addRegion(region);
                return region;
            }
            throw new CommandException("No region could be found with the name of '" + id + "'.");
        }
        return region;
    }

    protected static ProtectedRegion checkRegionStandingIn(RegionManager regionManager, Player player) throws CommandException {
        return RegionCommandsBase.checkRegionStandingIn(regionManager, player, false);
    }

    protected static ProtectedRegion checkRegionStandingIn(RegionManager regionManager, Player player, boolean allowGlobal) throws CommandException {
        ApplicableRegionSet set = regionManager.getApplicableRegions(player.getLocation());
        if (set.size() == 0) {
            if (allowGlobal) {
                ProtectedRegion global = RegionCommandsBase.checkExistingRegion(regionManager, "__global__", true);
                player.sendMessage(ChatColor.GRAY + "You're not standing in any regions. Using the global region for this world instead.");
                return global;
            }
            throw new CommandException("You're not standing in a region.Specify an ID if you want to select a specific region.");
        }
        if (set.size() > 1) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (ProtectedRegion region : set) {
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                builder.append(region.getId());
            }
            throw new CommandException("You're standing in several regions (please pick one).\nYou're in: " + builder.toString());
        }
        return (ProtectedRegion)set.iterator().next();
    }

    protected static Selection checkSelection(Player player) throws CommandException {
        WorldEditPlugin worldEdit = WorldGuardPlugin.inst().getWorldEdit();
        Selection selection = worldEdit.getSelection(player);
        if (selection == null) {
            throw new CommandException("Please select an area first. Use WorldEdit to make a selection! (wiki: http://wiki.sk89q.com/wiki/WorldEdit).");
        }
        return selection;
    }

    protected static void checkRegionDoesNotExist(RegionManager manager, String id, boolean mayRedefine) throws CommandException {
        if (manager.hasRegion(id)) {
            throw new CommandException("A region with that name already exists. Please choose another name." + (mayRedefine ? " To change the shape, use /region redefine " + id + "." : ""));
        }
    }

    protected static RegionManager checkRegionManager(WorldGuardPlugin plugin, World world) throws CommandException {
        if (!plugin.getGlobalStateManager().get((World)world).useRegions) {
            throw new CommandException("Region support is disabled in the target world. It can be enabled per-world in WorldGuard's configuration files. However, you may need to restart your server afterwards.");
        }
        RegionManager manager = plugin.getRegionContainer().get(world);
        if (manager == null) {
            throw new CommandException("Region data failed to load for this world. Please ask a server administrator to read the logs to identify the reason.");
        }
        return manager;
    }

    protected static ProtectedRegion checkRegionFromSelection(Player player, String id) throws CommandException {
        Selection selection = RegionCommandsBase.checkSelection(player);
        if (selection instanceof Polygonal2DSelection) {
            Polygonal2DSelection polySel = (Polygonal2DSelection)selection;
            int minY = polySel.getNativeMinimumPoint().getBlockY();
            int maxY = polySel.getNativeMaximumPoint().getBlockY();
            return new ProtectedPolygonalRegion(id, polySel.getNativePoints(), minY, maxY);
        }
        if (selection instanceof CuboidSelection) {
            BlockVector min = selection.getNativeMinimumPoint().toBlockVector();
            BlockVector max = selection.getNativeMaximumPoint().toBlockVector();
            return new ProtectedCuboidRegion(id, min, max);
        }
        throw new CommandException("Sorry, you can only use cuboids and polygons for WorldGuard regions.");
    }

    protected static void warnAboutSaveFailures(CommandSender sender) {
        RegionContainer container = WorldGuardPlugin.inst().getRegionContainer();
        Set<RegionManager> failures = container.getSaveFailures();
        if (failures.size() > 0) {
            String failingList = Joiner.on((String)", ").join(Iterables.transform(failures, (Function)new Function<RegionManager, String>(){

                public String apply(RegionManager regionManager) {
                    return "'" + regionManager.getName() + "'";
                }
            }));
            sender.sendMessage(ChatColor.GOLD + "(Warning: The background saving of region data is failing for these worlds: " + failingList + ". Your changes are getting lost. See the server log for more information.)");
        }
    }

    protected static void warnAboutDimensions(CommandSender sender, ProtectedRegion region) {
        int height = region.getMaximumPoint().getBlockY() - region.getMinimumPoint().getBlockY();
        if (height <= 2) {
            sender.sendMessage(ChatColor.GRAY + "(Warning: The height of the region was " + (height + 1) + " block(s).)");
        }
    }

    protected static void informNewUser(CommandSender sender, RegionManager manager, ProtectedRegion region) {
        if (manager.getRegions().size() <= 2) {
            sender.sendMessage(ChatColor.GRAY + "(This region is NOW PROTECTED from modification from others. Don't want that? Use " + ChatColor.AQUA + "/rg flag " + region.getId() + " passthrough allow" + ChatColor.GRAY + ")");
        }
    }

    protected static void setPlayerSelection(Player player, ProtectedRegion region) throws CommandException {
        WorldEditPlugin worldEdit = WorldGuardPlugin.inst().getWorldEdit();
        World world = player.getWorld();
        if (region instanceof ProtectedCuboidRegion) {
            ProtectedCuboidRegion cuboid = (ProtectedCuboidRegion)region;
            BlockVector pt1 = cuboid.getMinimumPoint();
            BlockVector pt2 = cuboid.getMaximumPoint();
            CuboidSelection selection = new CuboidSelection(world, (Vector)pt1, (Vector)pt2);
            worldEdit.setSelection(player, (Selection)selection);
            player.sendMessage(ChatColor.YELLOW + "Region selected as a cuboid.");
        } else if (region instanceof ProtectedPolygonalRegion) {
            ProtectedPolygonalRegion poly2d = (ProtectedPolygonalRegion)region;
            Polygonal2DSelection selection = new Polygonal2DSelection(world, poly2d.getPoints(), poly2d.getMinimumPoint().getBlockY(), poly2d.getMaximumPoint().getBlockY());
            worldEdit.setSelection(player, (Selection)selection);
            player.sendMessage(ChatColor.YELLOW + "Region selected as a polygon.");
        } else {
            if (region instanceof GlobalProtectedRegion) {
                throw new CommandException("Can't select global regions! That would cover the entire world.");
            }
            throw new CommandException("Unknown region type: " + region.getClass().getCanonicalName());
        }
    }

    protected static <V> void setFlag(ProtectedRegion region, Flag<V> flag, CommandSender sender, String value) throws InvalidFlagFormat {
        region.setFlag(flag, flag.parseInput(FlagContext.create().setSender(sender).setInput(value).setObject("region", region).build()));
    }
}

