/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.event.entity.DamageEntityEvent;
import com.sk89q.worldguard.bukkit.event.inventory.UseItemEvent;
import com.sk89q.worldguard.bukkit.listener.AbstractListener;
import com.sk89q.worldguard.bukkit.util.Entities;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.TippedArrow;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BlockedPotionsListener
extends AbstractListener {
    public BlockedPotionsListener(WorldGuardPlugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onProjectile(DamageEntityEvent event) {
        block7: {
            PotionEffectType blockedEffect;
            block9: {
                WorldConfiguration wcfg;
                EntityDamageByEntityEvent originalEvent;
                block8: {
                    if (!(event.getOriginalEvent() instanceof EntityDamageByEntityEvent) || !Entities.isPotionArrow((originalEvent = (EntityDamageByEntityEvent)event.getOriginalEvent()).getDamager())) break block7;
                    ConfigurationManager cfg = this.getPlugin().getGlobalStateManager();
                    wcfg = cfg.get(event.getWorld());
                    blockedEffect = null;
                    if (!(originalEvent.getDamager() instanceof SpectralArrow)) break block8;
                    if (!wcfg.blockPotions.contains(PotionEffectType.GLOWING)) break block9;
                    blockedEffect = PotionEffectType.GLOWING;
                    break block9;
                }
                if (originalEvent.getDamager() instanceof TippedArrow) {
                    TippedArrow tippedArrow = (TippedArrow)originalEvent.getDamager();
                    PotionEffectType baseEffect = tippedArrow.getBasePotionData().getType().getEffectType();
                    if (wcfg.blockPotions.contains(baseEffect)) {
                        blockedEffect = baseEffect;
                    } else {
                        for (PotionEffect potionEffect : tippedArrow.getCustomEffects()) {
                            if (!wcfg.blockPotions.contains(potionEffect.getType())) continue;
                            blockedEffect = potionEffect.getType();
                            break;
                        }
                    }
                }
            }
            if (blockedEffect != null) {
                Player player = event.getCause().getFirstPlayer();
                if (player != null) {
                    if (this.getPlugin().hasPermission((CommandSender)player, "worldguard.override.potions")) {
                        return;
                    }
                    player.sendMessage(ChatColor.RED + "Sorry, arrows with " + blockedEffect.getName() + " are presently disabled.");
                }
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onItemInteract(UseItemEvent event) {
        ConfigurationManager cfg = this.getPlugin().getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getWorld());
        ItemStack item = event.getItemStack();
        boolean oldPotions = false;
        try {
            if (item.getType() != Material.POTION && item.getType() != Material.SPLASH_POTION && item.getType() != Material.LINGERING_POTION) {
                return;
            }
        }
        catch (NoSuchFieldError ignored) {
            if (item.getType() != Material.POTION) {
                return;
            }
            oldPotions = true;
        }
        if (!wcfg.blockPotions.isEmpty()) {
            PotionEffectType blockedEffect = null;
            if (!(item.getItemMeta() instanceof PotionMeta)) {
                return;
            }
            PotionMeta meta = (PotionMeta)item.getItemMeta();
            PotionEffectType baseEffect = meta.getBasePotionData().getType().getEffectType();
            if (wcfg.blockPotions.contains(baseEffect)) {
                blockedEffect = baseEffect;
            }
            if (blockedEffect == null && meta.hasCustomEffects()) {
                for (PotionEffect effect : meta.getCustomEffects()) {
                    if (!wcfg.blockPotions.contains(effect.getType())) continue;
                    blockedEffect = effect.getType();
                    break;
                }
            }
            if (blockedEffect != null) {
                Player player = event.getCause().getFirstPlayer();
                if (player != null) {
                    if (this.getPlugin().hasPermission((CommandSender)player, "worldguard.override.potions")) {
                        boolean isSplash = false;
                        try {
                            isSplash = !oldPotions && (item.getType() == Material.SPLASH_POTION || item.getType() == Material.LINGERING_POTION);
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        if ((isSplash |= oldPotions && Potion.fromItemStack((ItemStack)item).isSplash()) && wcfg.blockPotionsAlways) {
                            player.sendMessage(ChatColor.RED + "Sorry, potions with " + blockedEffect.getName() + " can't be thrown, even if you have a permission to bypass it, due to limitations (and because overly-reliable potion blocking is on).");
                            event.setCancelled(true);
                        }
                    } else {
                        player.sendMessage(ChatColor.RED + "Sorry, potions with " + blockedEffect.getName() + " are presently disabled.");
                        event.setCancelled(true);
                    }
                } else {
                    event.setCancelled(true);
                }
            }
        }
    }
}

