/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.google.common.base.Predicate;
import com.sk89q.worldguard.bukkit.RegionQuery;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.event.block.BreakBlockEvent;
import com.sk89q.worldguard.bukkit.event.block.PlaceBlockEvent;
import com.sk89q.worldguard.bukkit.listener.AbstractListener;
import com.sk89q.worldguard.bukkit.util.Entities;
import com.sk89q.worldguard.bukkit.util.Materials;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class RegionFlagsListener
extends AbstractListener {
    public RegionFlagsListener(WorldGuardPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlaceBlock(PlaceBlockEvent event) {
        if (!this.isRegionSupportEnabled(event.getWorld())) {
            return;
        }
        RegionQuery query = this.getPlugin().getRegionContainer().createQuery();
        Block block = event.getCause().getFirstBlock();
        if (block != null && Materials.isPistonBlock(block.getType())) {
            event.filter((Predicate)this.testState(query, DefaultFlag.PISTONS), false);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBreakBlock(BreakBlockEvent event) {
        if (!this.isRegionSupportEnabled(event.getWorld())) {
            return;
        }
        WorldConfiguration config = this.getWorldConfig(event.getWorld());
        RegionQuery query = this.getPlugin().getRegionContainer().createQuery();
        Block block = event.getCause().getFirstBlock();
        if (block != null && Materials.isPistonBlock(block.getType())) {
            event.filter((Predicate)this.testState(query, DefaultFlag.PISTONS), false);
        }
        if (event.getCause().find(EntityType.CREEPER) != null) {
            event.filter((Predicate)this.testState(query, DefaultFlag.CREEPER_EXPLOSION), config.explosionFlagCancellation);
        }
        if (event.getCause().find(EntityType.ENDER_DRAGON) != null) {
            event.filter((Predicate)this.testState(query, DefaultFlag.ENDERDRAGON_BLOCK_DAMAGE), config.explosionFlagCancellation);
        }
        if (event.getCause().find(Entities.enderCrystalType) != null) {
            event.filter((Predicate)this.testState(query, DefaultFlag.OTHER_EXPLOSION), config.explosionFlagCancellation);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity damager;
        Entity entity = event.getEntity();
        World world = entity.getWorld();
        if (!this.isRegionSupportEnabled(world)) {
            return;
        }
        RegionQuery query = this.getPlugin().getRegionContainer().createQuery();
        if (entity instanceof Player && event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            if (!query.testState(entity.getLocation(), (Player)entity, DefaultFlag.FALL_DAMAGE)) {
                event.setCancelled(true);
                return;
            }
        } else {
            try {
                if (entity instanceof Player && event.getCause() == EntityDamageEvent.DamageCause.FLY_INTO_WALL && !query.testState(entity.getLocation(), (Player)entity, DefaultFlag.FALL_DAMAGE)) {
                    event.setCancelled(true);
                    return;
                }
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
        if (event instanceof EntityDamageByEntityEvent && (damager = ((EntityDamageByEntityEvent)event).getDamager()) != null && damager.getType() == EntityType.FIREWORK && !query.testState(entity.getLocation(), (RegionAssociable)null, DefaultFlag.FIREWORK_DAMAGE)) {
            event.setCancelled(true);
            return;
        }
    }

    private Predicate<Location> testState(final RegionQuery query, final StateFlag flag) {
        return new Predicate<Location>(){

            public boolean apply(@Nullable Location location) {
                return query.testState(location, (RegionAssociable)null, flag);
            }
        };
    }
}

