/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.google.common.base.Predicate;
import com.sk89q.worldguard.bukkit.RegionQuery;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.cause.Cause;
import com.sk89q.worldguard.bukkit.event.DelegateEvent;
import com.sk89q.worldguard.bukkit.event.block.BreakBlockEvent;
import com.sk89q.worldguard.bukkit.event.block.PlaceBlockEvent;
import com.sk89q.worldguard.bukkit.event.block.UseBlockEvent;
import com.sk89q.worldguard.bukkit.event.entity.DamageEntityEvent;
import com.sk89q.worldguard.bukkit.event.entity.DestroyEntityEvent;
import com.sk89q.worldguard.bukkit.event.entity.SpawnEntityEvent;
import com.sk89q.worldguard.bukkit.event.entity.UseEntityEvent;
import com.sk89q.worldguard.bukkit.internal.WGMetadata;
import com.sk89q.worldguard.bukkit.listener.AbstractListener;
import com.sk89q.worldguard.bukkit.permission.RegionPermissionModel;
import com.sk89q.worldguard.bukkit.protection.DelayedRegionOverlapAssociation;
import com.sk89q.worldguard.bukkit.util.Entities;
import com.sk89q.worldguard.bukkit.util.Events;
import com.sk89q.worldguard.bukkit.util.InteropUtils;
import com.sk89q.worldguard.bukkit.util.Materials;
import com.sk89q.worldguard.domains.Association;
import com.sk89q.worldguard.protection.association.Associables;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.events.DisallowedPVPEvent;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.metadata.Metadatable;

public class RegionProtectionListener
extends AbstractListener {
    private static final String DENY_MESSAGE_KEY = "worldguard.region.lastMessage";
    private static final String DISEMBARK_MESSAGE_KEY = "worldguard.region.disembarkMessage";
    private static final int LAST_MESSAGE_DELAY = 500;

    public RegionProtectionListener(WorldGuardPlugin plugin) {
        super(plugin);
    }

    private void tellErrorMessage(DelegateEvent event, Cause cause, Location location, String what) {
        if (event.isSilent() || cause.isIndirect()) {
            return;
        }
        Object rootCause = cause.getRootCause();
        if (rootCause instanceof Player) {
            Player player = (Player)rootCause;
            long now = System.currentTimeMillis();
            Long lastTime = WGMetadata.getIfPresent((Metadatable)player, DENY_MESSAGE_KEY, Long.class);
            if (lastTime == null || now - lastTime >= 500L) {
                RegionQuery query = this.getPlugin().getRegionContainer().createQuery();
                String message = query.queryValue(location, player, DefaultFlag.DENY_MESSAGE);
                if (message != null && !message.isEmpty()) {
                    player.sendMessage(message.replace("%what%", what));
                }
                WGMetadata.put((Metadatable)player, DENY_MESSAGE_KEY, now);
            }
        }
    }

    private boolean isWhitelisted(Cause cause, World world, boolean pvp) {
        Object rootCause = cause.getRootCause();
        if (rootCause instanceof Block) {
            Material type = ((Block)rootCause).getType();
            return type == Material.HOPPER || type == Material.DROPPER;
        }
        if (rootCause instanceof Player) {
            Player player = (Player)rootCause;
            WorldConfiguration config = this.getWorldConfig(world);
            if (config.fakePlayerBuildOverride && InteropUtils.isFakePlayer(player)) {
                return true;
            }
            return !pvp && new RegionPermissionModel(this.getPlugin(), (CommandSender)player).mayIgnoreRegionProtection(world);
        }
        return false;
    }

    private RegionAssociable createRegionAssociable(Cause cause) {
        Object rootCause = cause.getRootCause();
        if (!cause.isKnown()) {
            return Associables.constant(Association.NON_MEMBER);
        }
        if (rootCause instanceof Player) {
            return this.getPlugin().wrapPlayer((Player)rootCause);
        }
        if (rootCause instanceof OfflinePlayer) {
            return this.getPlugin().wrapOfflinePlayer((OfflinePlayer)rootCause);
        }
        if (rootCause instanceof Entity) {
            RegionQuery query = this.getPlugin().getRegionContainer().createQuery();
            return new DelayedRegionOverlapAssociation(query, ((Entity)rootCause).getLocation());
        }
        if (rootCause instanceof Block) {
            RegionQuery query = this.getPlugin().getRegionContainer().createQuery();
            return new DelayedRegionOverlapAssociation(query, ((Block)rootCause).getLocation());
        }
        return Associables.constant(Association.NON_MEMBER);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlaceBlock(final PlaceBlockEvent event) {
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.isRegionSupportEnabled(event.getWorld())) {
            return;
        }
        if (this.isWhitelisted(event.getCause(), event.getWorld(), false)) {
            return;
        }
        final Material type = event.getEffectiveMaterial();
        final RegionQuery query = this.getPlugin().getRegionContainer().createQuery();
        final RegionAssociable associable = this.createRegionAssociable(event.getCause());
        if (event.getCause().getRootCause() instanceof Block && Materials.isLiquid(type) && !this.getWorldConfig((World)event.getWorld()).checkLiquidFlow) {
            return;
        }
        event.filter((Predicate)new Predicate<Location>(){

            public boolean apply(Location target) {
                String what;
                boolean canPlace;
                if (type == Material.FIRE) {
                    Block block = event.getCause().getFirstBlock();
                    boolean fire = block != null && block.getType() == Material.FIRE;
                    boolean lava = block != null && Materials.isLava(block.getType());
                    ArrayList<StateFlag> flags = new ArrayList<StateFlag>();
                    flags.add(DefaultFlag.BLOCK_PLACE);
                    flags.add(DefaultFlag.LIGHTER);
                    if (fire) {
                        flags.add(DefaultFlag.FIRE_SPREAD);
                    }
                    if (lava) {
                        flags.add(DefaultFlag.LAVA_FIRE);
                    }
                    canPlace = query.testBuild(target, associable, RegionProtectionListener.combine(event, flags.toArray(new StateFlag[flags.size()])));
                    what = "place fire";
                } else {
                    canPlace = query.testBuild(target, associable, RegionProtectionListener.combine(event, new StateFlag[]{DefaultFlag.BLOCK_PLACE}));
                    try {
                        event.setSilent(type == Material.FROSTED_ICE);
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    what = "place that block";
                }
                if (!canPlace) {
                    RegionProtectionListener.this.tellErrorMessage(event, event.getCause(), target, what);
                    return false;
                }
                return true;
            }
        });
    }

    @EventHandler(ignoreCancelled=true)
    public void onBreakBlock(final BreakBlockEvent event) {
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.isRegionSupportEnabled(event.getWorld())) {
            return;
        }
        if (this.isWhitelisted(event.getCause(), event.getWorld(), false)) {
            return;
        }
        final RegionQuery query = this.getPlugin().getRegionContainer().createQuery();
        if (!event.isCancelled()) {
            final RegionAssociable associable = this.createRegionAssociable(event.getCause());
            event.filter((Predicate)new Predicate<Location>(){

                public boolean apply(Location target) {
                    String what;
                    boolean canBreak;
                    if (event.getCause().find(EntityType.PRIMED_TNT, EntityType.MINECART_TNT) != null) {
                        canBreak = query.testBuild(target, associable, RegionProtectionListener.combine(event, new StateFlag[]{DefaultFlag.BLOCK_BREAK, DefaultFlag.TNT}));
                        what = "use dynamite";
                    } else {
                        canBreak = query.testBuild(target, associable, RegionProtectionListener.combine(event, new StateFlag[]{DefaultFlag.BLOCK_BREAK}));
                        what = "break that block";
                    }
                    if (!canBreak) {
                        RegionProtectionListener.this.tellErrorMessage(event, event.getCause(), target, what);
                        return false;
                    }
                    return true;
                }
            });
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onUseBlock(final UseBlockEvent event) {
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.isRegionSupportEnabled(event.getWorld())) {
            return;
        }
        if (this.isWhitelisted(event.getCause(), event.getWorld(), false)) {
            return;
        }
        final Material type = event.getEffectiveMaterial();
        final RegionQuery query = this.getPlugin().getRegionContainer().createQuery();
        final RegionAssociable associable = this.createRegionAssociable(event.getCause());
        event.filter((Predicate)new Predicate<Location>(){

            public boolean apply(Location target) {
                String what;
                boolean canUse;
                if (Materials.isConsideredBuildingIfUsed(type)) {
                    canUse = query.testBuild(target, associable, RegionProtectionListener.combine(event, new StateFlag[0]));
                    what = "use that";
                } else if (Materials.isInventoryBlock(type)) {
                    canUse = query.testBuild(target, associable, RegionProtectionListener.combine(event, new StateFlag[]{DefaultFlag.INTERACT, DefaultFlag.CHEST_ACCESS}));
                    what = "open that";
                } else if (type == Material.BED_BLOCK) {
                    canUse = query.testBuild(target, associable, RegionProtectionListener.combine(event, new StateFlag[]{DefaultFlag.INTERACT, DefaultFlag.SLEEP}));
                    what = "sleep";
                } else if (type == Material.TNT) {
                    canUse = query.testBuild(target, associable, RegionProtectionListener.combine(event, new StateFlag[]{DefaultFlag.INTERACT, DefaultFlag.TNT}));
                    what = "use explosives";
                } else if (Materials.isUseFlagApplicable(type)) {
                    canUse = query.testBuild(target, associable, RegionProtectionListener.combine(event, new StateFlag[]{DefaultFlag.INTERACT, DefaultFlag.USE}));
                    what = "use that";
                } else {
                    canUse = query.testBuild(target, associable, RegionProtectionListener.combine(event, new StateFlag[]{DefaultFlag.INTERACT}));
                    what = "use that";
                }
                if (!canUse) {
                    RegionProtectionListener.this.tellErrorMessage(event, event.getCause(), target, what);
                    return false;
                }
                return true;
            }
        });
    }

    @EventHandler(ignoreCancelled=true)
    public void onSpawnEntity(SpawnEntityEvent event) {
        String what;
        boolean canSpawn;
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.isRegionSupportEnabled(event.getWorld())) {
            return;
        }
        if (this.isWhitelisted(event.getCause(), event.getWorld(), false)) {
            return;
        }
        Location target = event.getTarget();
        EntityType type = event.getEffectiveType();
        RegionQuery query = this.getPlugin().getRegionContainer().createQuery();
        RegionAssociable associable = this.createRegionAssociable(event.getCause());
        if (Entities.isVehicle(type)) {
            canSpawn = query.testBuild(target, associable, RegionProtectionListener.combine(event, DefaultFlag.PLACE_VEHICLE));
            what = "place vehicles";
        } else if (event.getEntity() instanceof Item) {
            canSpawn = query.testBuild(target, associable, RegionProtectionListener.combine(event, DefaultFlag.ITEM_DROP));
            what = "drop items";
        } else if (type == EntityType.EXPERIENCE_ORB) {
            canSpawn = query.testBuild(target, associable, RegionProtectionListener.combine(event, DefaultFlag.EXP_DROPS));
            what = "drop XP";
        } else if (Entities.isAoECloud(type)) {
            canSpawn = query.testBuild(target, associable, RegionProtectionListener.combine(event, DefaultFlag.POTION_SPLASH));
            what = "use lingering potions";
        } else {
            canSpawn = query.testBuild(target, associable, RegionProtectionListener.combine(event, new StateFlag[0]));
            what = event.getEntity() instanceof Item ? "drop items" : "place things";
        }
        if (!canSpawn) {
            this.tellErrorMessage(event, event.getCause(), target, what);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDestroyEntity(DestroyEntityEvent event) {
        String what;
        boolean canDestroy;
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.isRegionSupportEnabled(event.getWorld())) {
            return;
        }
        if (this.isWhitelisted(event.getCause(), event.getWorld(), false)) {
            return;
        }
        Location target = event.getTarget();
        EntityType type = event.getEntity().getType();
        RegionAssociable associable = this.createRegionAssociable(event.getCause());
        RegionQuery query = this.getPlugin().getRegionContainer().createQuery();
        if (Entities.isVehicle(type)) {
            canDestroy = query.testBuild(target, associable, RegionProtectionListener.combine(event, DefaultFlag.DESTROY_VEHICLE));
            what = "break vehicles";
        } else if (event.getEntity() instanceof Item || event.getEntity() instanceof ExperienceOrb) {
            canDestroy = query.testBuild(target, associable, RegionProtectionListener.combine(event, DefaultFlag.ITEM_PICKUP));
            what = "pick up items";
        } else {
            canDestroy = query.testBuild(target, associable, RegionProtectionListener.combine(event, new StateFlag[0]));
            what = "break things";
        }
        if (!canDestroy) {
            this.tellErrorMessage(event, event.getCause(), target, what);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onUseEntity(UseEntityEvent event) {
        String what;
        boolean canUse;
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.isRegionSupportEnabled(event.getWorld())) {
            return;
        }
        if (this.isWhitelisted(event.getCause(), event.getWorld(), false)) {
            return;
        }
        Location target = event.getTarget();
        RegionAssociable associable = this.createRegionAssociable(event.getCause());
        RegionQuery query = this.getPlugin().getRegionContainer().createQuery();
        if (Entities.isHostile(event.getEntity()) || Entities.isAmbient(event.getEntity()) || Entities.isNPC(event.getEntity()) || Entities.isVehicle(event.getEntity().getType())) {
            canUse = event.getRelevantFlags().isEmpty() || query.queryState(target, associable, RegionProtectionListener.combine(event, new StateFlag[0])) != StateFlag.State.DENY;
            what = "use that";
        } else if (Entities.isConsideredBuildingIfUsed(event.getEntity())) {
            canUse = query.testBuild(target, associable, RegionProtectionListener.combine(event, new StateFlag[0]));
            what = "change that";
        } else if (Entities.isRiddenOnUse(event.getEntity())) {
            canUse = query.testBuild(target, associable, RegionProtectionListener.combine(event, DefaultFlag.RIDE, DefaultFlag.INTERACT));
            what = "ride that";
        } else {
            canUse = query.testBuild(target, associable, RegionProtectionListener.combine(event, DefaultFlag.INTERACT));
            what = "use that";
        }
        if (!canUse) {
            this.tellErrorMessage(event, event.getCause(), target, what);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamageEntity(DamageEntityEvent event) {
        String what;
        boolean canDamage;
        boolean pvp;
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!this.isRegionSupportEnabled(event.getWorld())) {
            return;
        }
        Location target = event.getTarget();
        RegionAssociable associable = this.createRegionAssociable(event.getCause());
        RegionQuery query = this.getPlugin().getRegionContainer().createQuery();
        Player playerAttacker = event.getCause().getFirstPlayer();
        boolean bl = pvp = event.getEntity() instanceof Player && playerAttacker != null && !playerAttacker.equals(event.getEntity());
        if (this.isWhitelisted(event.getCause(), event.getWorld(), pvp)) {
            return;
        }
        if (Entities.isHostile(event.getEntity()) || Entities.isAmbient(event.getEntity()) || Entities.isVehicle(event.getEntity().getType())) {
            canDamage = event.getRelevantFlags().isEmpty() || query.queryState(target, associable, RegionProtectionListener.combine(event, new StateFlag[0])) != StateFlag.State.DENY;
            what = "hit that";
        } else if (Entities.isConsideredBuildingIfUsed(event.getEntity())) {
            canDamage = query.testBuild(target, associable, RegionProtectionListener.combine(event, new StateFlag[0]));
            what = "change that";
        } else if (pvp) {
            Player defender = (Player)event.getEntity();
            if (defender.hasMetadata("NPC")) {
                return;
            }
            boolean bl2 = canDamage = query.testBuild(target, associable, RegionProtectionListener.combine(event, DefaultFlag.PVP)) && query.queryState(playerAttacker.getLocation(), playerAttacker, RegionProtectionListener.combine(event, DefaultFlag.PVP)) != StateFlag.State.DENY && query.queryState(target, playerAttacker, RegionProtectionListener.combine(event, DefaultFlag.PVP)) != StateFlag.State.DENY;
            if (!canDamage && Events.fireAndTestCancel(new DisallowedPVPEvent(playerAttacker, defender, event.getOriginalEvent()))) {
                canDamage = true;
            }
            what = "PvP";
        } else if (event.getEntity() instanceof Player) {
            canDamage = event.getRelevantFlags().isEmpty() || query.queryState(target, associable, RegionProtectionListener.combine(event, new StateFlag[0])) != StateFlag.State.DENY;
            what = "damage that";
        } else if (Entities.isNonHostile(event.getEntity())) {
            canDamage = query.testBuild(target, associable, RegionProtectionListener.combine(event, DefaultFlag.DAMAGE_ANIMALS));
            what = "harm that";
        } else {
            canDamage = query.testBuild(target, associable, RegionProtectionListener.combine(event, DefaultFlag.INTERACT));
            what = "hit that";
        }
        if (!canDamage) {
            this.tellErrorMessage(event, event.getCause(), target, what);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onVehicleExit(VehicleExitEvent event) {
        Location location;
        RegionQuery query;
        Player player;
        Vehicle vehicle = event.getVehicle();
        if (!this.isRegionSupportEnabled(vehicle.getWorld())) {
            return;
        }
        LivingEntity exited = event.getExited();
        if (vehicle instanceof Tameable && exited instanceof Player && !this.isWhitelisted(Cause.create(player = (Player)exited), vehicle.getWorld(), false) && !(query = this.getPlugin().getRegionContainer().createQuery()).testBuild(location = vehicle.getLocation(), player, DefaultFlag.RIDE, DefaultFlag.INTERACT)) {
            long now = System.currentTimeMillis();
            Long lastTime = WGMetadata.getIfPresent((Metadatable)player, DISEMBARK_MESSAGE_KEY, Long.class);
            if (lastTime == null || now - lastTime >= 500L) {
                player.sendMessage("" + ChatColor.GOLD + "Don't disembark here!" + ChatColor.GRAY + " You can't get back on.");
                WGMetadata.put((Metadatable)player, DISEMBARK_MESSAGE_KEY, now);
            }
            event.setCancelled(true);
        }
    }

    private boolean isWhitelistedEntity(Entity entity) {
        return Entities.isNonPlayerCreature(entity);
    }

    private static StateFlag[] combine(DelegateEvent event, StateFlag ... flag) {
        List<StateFlag> extra = event.getRelevantFlags();
        StateFlag[] flags = Arrays.copyOf(flag, flag.length + extra.size());
        for (int i = 0; i < extra.size(); ++i) {
            flags[flag.length + i] = extra.get(i);
        }
        return flags;
    }
}

