/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.flags;

import com.sk89q.worldedit.Location;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.permission.RegionPermissionModel;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.FlagContext;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import com.sk89q.worldguard.protection.flags.LazyLocation;
import com.sk89q.worldguard.protection.flags.RegionGroup;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LocationFlag
extends Flag<Location> {
    public LocationFlag(String name, RegionGroup defaultGroup) {
        super(name, defaultGroup);
    }

    public LocationFlag(String name) {
        super(name);
    }

    @Override
    public Location parseInput(FlagContext context) throws InvalidFlagFormat {
        String input = context.getUserInput();
        Player player = context.getPlayerSender();
        Location loc = null;
        if ("here".equalsIgnoreCase(input)) {
            loc = this.toLazyLocation(player.getLocation());
        } else {
            if ("none".equalsIgnoreCase(input)) {
                return null;
            }
            String[] split = input.split(",");
            if (split.length >= 3) {
                try {
                    World world = player.getWorld();
                    double x = Double.parseDouble(split[0]);
                    double y = Double.parseDouble(split[1]);
                    double z = Double.parseDouble(split[2]);
                    float yaw = split.length < 4 ? 0.0f : Float.parseFloat(split[3]);
                    float pitch = split.length < 5 ? 0.0f : Float.parseFloat(split[4]);
                    loc = new LazyLocation(world.getName(), new Vector(x, y, z), yaw, pitch);
                }
                catch (NumberFormatException world) {
                    // empty catch block
                }
            }
        }
        if (loc != null) {
            Object obj = context.get("region");
            if (obj instanceof ProtectedRegion) {
                ProtectedRegion rg = (ProtectedRegion)obj;
                if (WorldGuardPlugin.inst().getGlobalStateManager().get((World)player.getWorld()).boundedLocationFlags) {
                    if (!rg.contains(loc.getPosition())) {
                        if (new RegionPermissionModel(WorldGuardPlugin.inst(), (CommandSender)player).mayOverrideLocationFlagBounds(rg)) {
                            player.sendMessage(ChatColor.GRAY + "WARNING: Flag location is outside of region.");
                        } else {
                            throw new InvalidFlagFormat("You can't set that flag outside of the region boundaries.");
                        }
                    }
                    loc.setPosition(loc.getPosition().clampY(0, player.getWorld().getMaxHeight()));
                    return loc;
                }
            }
            return loc;
        }
        throw new InvalidFlagFormat("Expected 'here' or x,y,z.");
    }

    private Location toLazyLocation(org.bukkit.Location location) {
        return new LazyLocation(location.getWorld().getName(), BukkitUtil.toVector((org.bukkit.Location)location), location.getYaw(), location.getPitch());
    }

    @Override
    public Location unmarshal(Object o) {
        if (o instanceof Map) {
            Map map = (Map)o;
            Object rawWorld = map.get("world");
            if (rawWorld == null) {
                return null;
            }
            Object rawX = map.get("x");
            if (rawX == null) {
                return null;
            }
            Object rawY = map.get("y");
            if (rawY == null) {
                return null;
            }
            Object rawZ = map.get("z");
            if (rawZ == null) {
                return null;
            }
            Object rawYaw = map.get("yaw");
            if (rawYaw == null) {
                return null;
            }
            Object rawPitch = map.get("pitch");
            if (rawPitch == null) {
                return null;
            }
            Vector position = new Vector(this.toNumber(rawX), this.toNumber(rawY), this.toNumber(rawZ));
            float yaw = (float)this.toNumber(rawYaw);
            float pitch = (float)this.toNumber(rawPitch);
            return new LazyLocation(String.valueOf(rawWorld), position, yaw, pitch);
        }
        return null;
    }

    @Override
    public Object marshal(Location o) {
        Vector position = o.getPosition();
        HashMap<String, Object> vec = new HashMap<String, Object>();
        if (o instanceof LazyLocation) {
            vec.put("world", ((LazyLocation)o).getWorldName());
        } else {
            try {
                vec.put("world", o.getWorld().getName());
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        vec.put("x", position.getX());
        vec.put("y", position.getY());
        vec.put("z", position.getZ());
        vec.put("yaw", Float.valueOf(o.getYaw()));
        vec.put("pitch", Float.valueOf(o.getPitch()));
        return vec;
    }

    private double toNumber(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return 0.0;
    }
}

