/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.session.handler;

import com.google.common.collect.Sets;
import com.sk89q.worldguard.bukkit.commands.CommandUtils;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GreetingFlag
extends Handler {
    public static final Factory FACTORY = new Factory();
    private Set<String> lastMessageStack = Collections.emptySet();

    public GreetingFlag(Session session) {
        super(session);
    }

    @Override
    public boolean onCrossBoundary(Player player, Location from, Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
        Collection<String> messages = toSet.queryAllValues(this.getPlugin().wrapPlayer(player), DefaultFlag.GREET_MESSAGE);
        for (String message : messages) {
            if (this.lastMessageStack.contains(message)) continue;
            String effective = CommandUtils.replaceColorMacros(message);
            effective = this.getPlugin().replaceMacros((CommandSender)player, effective);
            player.sendMessage(effective.replaceAll("\\\\n", "\n").split("\\n"));
            break;
        }
        this.lastMessageStack = Sets.newHashSet(messages);
        if (!this.lastMessageStack.isEmpty()) {
            for (ProtectedRegion region : toSet) {
                String message = (String)region.getFlag(DefaultFlag.GREET_MESSAGE);
                if (message == null) continue;
                this.lastMessageStack.add(message);
            }
        }
        return true;
    }

    public static class Factory
    extends Handler.Factory<GreetingFlag> {
        @Override
        public GreetingFlag create(Session session) {
            return new GreetingFlag(session);
        }
    }
}

