/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.features;

import com.google.common.collect.Maps;
import eu.decentsoftware.holograms.api.features.AbstractFeature;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class FeatureManager {
    private final Map<String, AbstractFeature> featureMap = Maps.newLinkedHashMap();

    public void reload() {
        for (AbstractFeature value : this.featureMap.values()) {
            value.reload();
        }
    }

    public void destroy() {
        for (AbstractFeature value : this.featureMap.values()) {
            value.destroy();
        }
        this.featureMap.clear();
    }

    public AbstractFeature getFeature(String name) {
        return this.featureMap.get(name);
    }

    public AbstractFeature registerFeature(AbstractFeature feature) {
        return this.featureMap.put(feature.getName(), feature);
    }

    public Set<String> getFeatureNames() {
        return this.featureMap.keySet();
    }

    public Collection<AbstractFeature> getFeatures() {
        return this.featureMap.values();
    }
}

