/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.collection;

import eu.decentsoftware.holograms.api.utils.RandomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.function.Function;

public class DList<T>
extends ArrayList<T> {
    public DList() {
    }

    public DList(int cap) {
        super(cap);
    }

    public DList(Collection<T> collection) {
        if (collection == null) {
            return;
        }
        for (T t : collection) {
            this.add(t);
        }
    }

    @SafeVarargs
    public DList(T ... array) {
        if (array == null) {
            return;
        }
        for (T t : array) {
            this.add(t);
        }
    }

    @SafeVarargs
    public final void add(T ... ts) {
        for (T t : ts) {
            this.add(t);
        }
    }

    public void add(Collection<T> collection) {
        for (T t : collection) {
            this.add(t);
        }
    }

    @Override
    public void addFirst(T t) {
        this.add(0, t);
    }

    public T first() {
        if (this.size() < 1) {
            return null;
        }
        return (T)this.get(0);
    }

    public T random() {
        return (T)this.get(this.randomIndex());
    }

    public T last() {
        if (this.size() < 1) {
            return null;
        }
        return (T)this.get(this.lastIndex());
    }

    public T pop() {
        if (this.isEmpty()) {
            return null;
        }
        return (T)this.remove(0);
    }

    public T popLast() {
        if (this.isEmpty()) {
            return null;
        }
        return (T)this.remove(this.lastIndex());
    }

    public T popRandom() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.size() == 1) {
            return this.pop();
        }
        return (T)this.remove(this.randomIndex());
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public boolean hasElements() {
        return !this.isEmpty();
    }

    public int lastIndex() {
        return this.size() - 1;
    }

    public int randomIndex() {
        return RandomUtils.randomInt(0, this.size() - 1);
    }

    public boolean hasDuplicates() {
        return this.size() != new LinkedHashSet(this).size();
    }

    public boolean hasIndex(int i) {
        return i >= 0 && i < this.size();
    }

    public DList<T> copy() {
        return new DList<T>(this);
    }

    public DList<T> sort() {
        this.sort(null);
        return this;
    }

    public DList<T> sortCopy() {
        DList<T> list = this.copy();
        list.sort(null);
        return list;
    }

    public DList<T> shuffle() {
        Collections.shuffle(this);
        return this;
    }

    public DList<T> shuffleCopy() {
        DList<T> list = this.copy();
        Collections.shuffle(list);
        return list;
    }

    public DList<T> reverse() {
        Collections.reverse(this);
        return this;
    }

    public DList<T> reverseCopy() {
        DList<T> list = this.copy();
        Collections.reverse(list);
        return list;
    }

    public DList<String> toStringList() {
        DList<String> list = new DList<String>();
        for (Object t : this) {
            list.add(t.toString());
        }
        return list;
    }

    @Override
    public DList<T> subList(int start, int end) {
        DList<T> list = new DList<T>();
        for (int i = start; i < Math.min(this.size(), end); ++i) {
            list.add(this.get(i));
        }
        return list;
    }

    public <R> DList<R> convert(Function<T, R> converter) {
        DList<T> list = new DList<T>();
        for (Object i : this) {
            R r = converter.apply(i);
            if (r == null) continue;
            list.add(r);
        }
        return list;
    }
}

