/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.color;

import com.google.common.collect.ImmutableMap;
import eu.decentsoftware.holograms.api.Settings;
import eu.decentsoftware.holograms.api.utils.color.caching.LruCache;
import eu.decentsoftware.holograms.api.utils.color.patterns.GradientPattern;
import eu.decentsoftware.holograms.api.utils.color.patterns.Pattern;
import eu.decentsoftware.holograms.api.utils.color.patterns.RainbowPattern;
import eu.decentsoftware.holograms.api.utils.color.patterns.SolidPattern;
import eu.decentsoftware.holograms.api.utils.reflect.ReflectMethod;
import eu.decentsoftware.holograms.api.utils.reflect.Version;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.md_5.bungee.api.ChatColor;

public class IridiumColorAPI {
    private static final ReflectMethod METHOD_OF = new ReflectMethod(ChatColor.class, "of", Color.class);
    public static final List<String> SPECIAL_COLORS = Arrays.asList("&l", "&n", "&o", "&k", "&m");
    private static final LruCache LRU_CACHE = new LruCache(Settings.DEFAULT_LRU_CACHE_SIZE);
    private static final Map<Color, ChatColor> COLORS = ImmutableMap.builder().put((Object)new Color(0), (Object)ChatColor.getByChar((char)'0')).put((Object)new Color(170), (Object)ChatColor.getByChar((char)'1')).put((Object)new Color(43520), (Object)ChatColor.getByChar((char)'2')).put((Object)new Color(43690), (Object)ChatColor.getByChar((char)'3')).put((Object)new Color(0xAA0000), (Object)ChatColor.getByChar((char)'4')).put((Object)new Color(0xAA00AA), (Object)ChatColor.getByChar((char)'5')).put((Object)new Color(0xFFAA00), (Object)ChatColor.getByChar((char)'6')).put((Object)new Color(0xAAAAAA), (Object)ChatColor.getByChar((char)'7')).put((Object)new Color(0x555555), (Object)ChatColor.getByChar((char)'8')).put((Object)new Color(0x5555FF), (Object)ChatColor.getByChar((char)'9')).put((Object)new Color(0x55FF55), (Object)ChatColor.getByChar((char)'a')).put((Object)new Color(0x55FFFF), (Object)ChatColor.getByChar((char)'b')).put((Object)new Color(0xFF5555), (Object)ChatColor.getByChar((char)'c')).put((Object)new Color(0xFF55FF), (Object)ChatColor.getByChar((char)'d')).put((Object)new Color(0xFFFF55), (Object)ChatColor.getByChar((char)'e')).put((Object)new Color(0xFFFFFF), (Object)ChatColor.getByChar((char)'f')).build();
    private static final List<Pattern> PATTERNS = Arrays.asList(new GradientPattern(), new SolidPattern(), new RainbowPattern());

    @Nonnull
    public static String process(@Nonnull String string) {
        String result = LRU_CACHE.getResult(string);
        if (result != null) {
            return result;
        }
        String input = string;
        for (Pattern pattern : PATTERNS) {
            string = pattern.process(string);
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        LRU_CACHE.put(input, string);
        return string;
    }

    @Nonnull
    public static List<String> process(@Nonnull List<String> strings) {
        strings.replaceAll(IridiumColorAPI::process);
        return strings;
    }

    @Nonnull
    public static String color(@Nonnull String string, @Nonnull Color color) {
        return (Version.supportsHex() ? METHOD_OF.invokeStatic(color) : IridiumColorAPI.getClosestColor(color)) + string;
    }

    @Nonnull
    public static String color(@Nonnull String string, @Nonnull Color start, @Nonnull Color end) {
        StringBuilder specialColors = new StringBuilder();
        for (String color : SPECIAL_COLORS) {
            if (!string.contains(color)) continue;
            specialColors.append(color);
            string = string.replace(color, "");
        }
        StringBuilder stringBuilder = new StringBuilder();
        ChatColor[] colors = IridiumColorAPI.createGradient(start, end, string.length());
        String[] characters = string.split("");
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(colors[i]).append((CharSequence)specialColors).append(characters[i]);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String rainbow(@Nonnull String string, float saturation) {
        StringBuilder specialColors = new StringBuilder();
        for (String color : SPECIAL_COLORS) {
            if (!string.contains(color)) continue;
            specialColors.append(color);
            string = string.replace(color, "");
        }
        StringBuilder stringBuilder = new StringBuilder();
        ChatColor[] colors = IridiumColorAPI.createRainbow(string.length(), saturation);
        String[] characters = string.split("");
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(colors[i]).append((CharSequence)specialColors).append(characters[i]);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static ChatColor getColor(@Nonnull String string) {
        return Version.supportsHex() ? (ChatColor)METHOD_OF.invokeStatic(new Color(Integer.parseInt(string, 16))) : IridiumColorAPI.getClosestColor(new Color(Integer.parseInt(string, 16)));
    }

    @Nonnull
    public static String stripColorFormatting(@Nonnull String string) {
        return string.replaceAll("[&\u00a7][a-f0-9lnokm]|<[/]?\\w{5,8}(:[0-9A-F]{6})?>", "");
    }

    @Nonnull
    private static ChatColor[] createRainbow(int step, float saturation) {
        ChatColor[] colors = new ChatColor[step];
        double colorStep = 1.0 / (double)step;
        for (int i = 0; i < step; ++i) {
            Color color = Color.getHSBColor((float)(colorStep * (double)i), saturation, saturation);
            colors[i] = Version.supportsHex() ? (ChatColor)METHOD_OF.invokeStatic(color) : IridiumColorAPI.getClosestColor(color);
        }
        return colors;
    }

    @Nonnull
    private static ChatColor[] createGradient(@Nonnull Color start, @Nonnull Color end, int step) {
        if (step <= 1) {
            return new ChatColor[]{ChatColor.WHITE, ChatColor.WHITE, ChatColor.WHITE};
        }
        ChatColor[] colors = new ChatColor[step];
        int stepR = Math.abs(start.getRed() - end.getRed()) / (step - 1);
        int stepG = Math.abs(start.getGreen() - end.getGreen()) / (step - 1);
        int stepB = Math.abs(start.getBlue() - end.getBlue()) / (step - 1);
        int[] direction = new int[]{start.getRed() < end.getRed() ? 1 : -1, start.getGreen() < end.getGreen() ? 1 : -1, start.getBlue() < end.getBlue() ? 1 : -1};
        for (int i = 0; i < step; ++i) {
            Color color = new Color(start.getRed() + stepR * i * direction[0], start.getGreen() + stepG * i * direction[1], start.getBlue() + stepB * i * direction[2]);
            colors[i] = Version.supportsHex() ? (ChatColor)METHOD_OF.invokeStatic(color) : IridiumColorAPI.getClosestColor(color);
        }
        return colors;
    }

    @Nonnull
    private static ChatColor getClosestColor(Color color) {
        Color nearestColor = null;
        double nearestDistance = 2.147483647E9;
        for (Color constantColor : COLORS.keySet()) {
            double distance = Math.pow(color.getRed() - constantColor.getRed(), 2.0) + Math.pow(color.getGreen() - constantColor.getGreen(), 2.0) + Math.pow(color.getBlue() - constantColor.getBlue(), 2.0);
            if (!(nearestDistance > distance)) continue;
            nearestColor = constantColor;
            nearestDistance = distance;
        }
        return COLORS.get(nearestColor);
    }
}

