/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.plugin.features;

import eu.decentsoftware.holograms.api.DecentHolograms;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.Settings;
import eu.decentsoftware.holograms.api.features.AbstractFeature;
import eu.decentsoftware.holograms.api.utils.config.FileConfig;
import eu.decentsoftware.holograms.api.utils.location.LocationUtils;
import eu.decentsoftware.holograms.plugin.features.FeatureCommons;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class HealingDisplayFeature
extends AbstractFeature
implements Listener {
    private static final DecentHolograms PLUGIN = DecentHologramsAPI.get();
    private int duration = 40;
    private String appearance = "&a+ {heal}";
    private boolean displayForPlayers = true;
    private boolean displayForMobs = true;
    private double heightOffset = 0.0;

    public HealingDisplayFeature() {
        super("healing_display");
        this.reload();
    }

    @Override
    public void reload() {
        this.disable();
        FileConfig config = Settings.getConfig();
        this.enabled = config.getBoolean("healing-display.enabled", this.enabled);
        this.duration = config.getInt("healing-display.duration", this.duration);
        this.appearance = config.getString("healing-display.appearance", this.appearance);
        this.heightOffset = config.getDouble("healing-display.height", this.heightOffset);
        this.displayForPlayers = config.getBoolean("damage-display.players", this.displayForPlayers);
        this.displayForMobs = config.getBoolean("damage-display.mobs", this.displayForMobs);
        if (this.enabled) {
            this.enable();
        }
    }

    @Override
    public void enable() {
        JavaPlugin javaPlugin = PLUGIN.getPlugin();
        javaPlugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)javaPlugin);
        this.enabled = true;
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        this.enabled = false;
    }

    @Override
    public void destroy() {
        this.disable();
    }

    @Override
    public String getDescription() {
        return "Spawn a temporary hologram displaying heals.";
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRegain(EntityRegainHealthEvent e) {
        if (e.isCancelled()) {
            return;
        }
        double heal = e.getAmount();
        if (heal <= 0.0) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof LivingEntity) || entity instanceof ArmorStand) {
            return;
        }
        if (entity instanceof Player && !this.displayForPlayers) {
            return;
        }
        if (!(entity instanceof Player) && !this.displayForMobs) {
            return;
        }
        Location location = LocationUtils.randomizeLocation(entity.getLocation().clone().add(0.0, 1.0 + this.heightOffset, 0.0));
        String text = this.appearance.replace("{heal}", FeatureCommons.formatNumber(heal));
        PLUGIN.getHologramManager().spawnTemporaryHologramLine(location, text, this.duration);
    }
}

