/*
 * Decompiled with CFR 0.152.
 */
package club.mher.compass.data;

import club.mher.compass.Compass;
import club.mher.compass.data.MessagesData;
import club.mher.compass.menu.MenuType;
import club.mher.compass.util.ItemBuilder;
import com.andrei1058.bedwars.api.configuration.ConfigManager;
import java.util.Collections;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MainConfig
extends ConfigManager {
    public static final String USE_COMMUNICATIONS = "use-quick-communications";
    public static final String COMPASS_ITEM = "compass-item";
    public static final String TRACKER_SHOP = "tracker-shop";
    public static final String MAIN_MENU_SIZE = "menus.main-menu.size";
    public static final String MAIN_MENU_TRACKER = "menus.main-menu.tracker";
    public static final String MAIN_MENU_TRACKER_TEAM = "menus.main-menu.tracker-team";
    public static final String MAIN_MENU_COMMUNICATIONS = "menus.main-menu.communications";
    public static final String TRACKER_MENU = "menus.tracker-menu";
    public static final String TRACKER_MENU_SIZE = "menus.tracker-menu.size";
    public static final String TRACKER_MENU_SLOTS = "menus.tracker-menu.slots";
    public static final String TRACKER_MENU_TEAM_ITEM = "menus.tracker-menu.team-item";
    public static final String TRACKER_MENU_BACK_ITEM = "menus.tracker-menu.back-item";
    public static final String COMMUNICATIONS_MENU_SIZE = "menus.communications.size";
    public static final String COMMUNICATIONS_MENU_BACK = "menus.communications.back-item";
    public static final String COMMUNICATIONS_MENU_ITEMS = "menus.communications.items";
    public static final String COMMUNICATIONS_MENU_TEAMS = "communication-menus.teams";
    public static final String COMMUNICATIONS_MENU_RESOURCES = "communication-menus.resources";
    public static final String MESSAGE_SEND_SOUND = "team-message-sound";
    public static final String PLAYER_TRACK_COST = "player-track.cost";
    public static final String PLAYER_TRACK_RESOURCE = "player-track.resource";
    public static final String TRACKER_UPDATE_RATE = "tracker-update-rate";

    public MainConfig(Plugin plugin, String name, String dir) {
        super(plugin, name, dir);
        YamlConfiguration yml = this.getYml();
        yml.options().header("BedWars1058 Compass Addon By Mher Zaqaryan, Version: " + Compass.getInstance().getDescription().getVersion());
        yml.addDefault(USE_COMMUNICATIONS, (Object)true);
        yml.addDefault(TRACKER_UPDATE_RATE, (Object)1);
        yml.addDefault(MESSAGE_SEND_SOUND, (Object)(Compass.getBedWars().getForCurrentVersion("SUCCESSFUL_HIT", "ENTITY_ARROW_HIT_PLAYER", "ENTITY_ARROW_HIT_PLAYER") + ",1,1"));
        yml.addDefault(PLAYER_TRACK_COST, (Object)2);
        yml.addDefault(PLAYER_TRACK_RESOURCE, (Object)"EMERALD");
        yml.addDefault(MAIN_MENU_SIZE, (Object)27);
        this.saveItem(COMPASS_ITEM, "COMPASS", 8);
        this.saveItem(TRACKER_SHOP, "COMPASS", 45);
        this.saveItem(MAIN_MENU_TRACKER, "COMPASS", 13);
        this.saveItem(MAIN_MENU_TRACKER_TEAM, "COMPASS", 15);
        this.saveItem(MAIN_MENU_COMMUNICATIONS, "EMERALD", 11);
        yml.addDefault(TRACKER_MENU_SIZE, (Object)36);
        yml.addDefault(TRACKER_MENU_SLOTS, (Object)"10,11,12,13,14,15,16,19,20,21,22,23,24,25");
        this.saveItem(TRACKER_MENU_TEAM_ITEM, Compass.getBedWars().getForCurrentVersion("WOOL", "WOOL", "WHITE_WOOL"));
        this.saveItem(TRACKER_MENU_BACK_ITEM, "ARROW", 31);
        yml.addDefault(COMMUNICATIONS_MENU_SIZE, (Object)45);
        this.saveItem(COMMUNICATIONS_MENU_BACK, "ARROW", 40);
        yml.addDefault(COMMUNICATIONS_MENU_ITEMS, Collections.emptyList());
        if (this.isFirstTime()) {
            this.saveCommunicationItem("1", "BOOK", 10, MenuType.NONE);
            this.saveCommunicationItem("2", "BOOK", 11, MenuType.NONE);
            this.saveCommunicationItem("3", Compass.getBedWars().getForCurrentVersion("IRON_FENCE", "IRON_FENCE", "IRON_BARS"), 12, MenuType.NONE);
            this.saveCommunicationItem("4", "IRON_SWORD", 13, MenuType.TEAM);
            this.saveCommunicationItem("5", "DIAMOND", 14, MenuType.RESOURCE);
            this.saveCommunicationItem("6", "CHEST", 15, MenuType.RESOURCE);
            this.saveCommunicationItem("7", "BOOK", 20, MenuType.NONE);
            this.saveCommunicationItem("8", "BOOK", 21, MenuType.NONE);
            this.saveCommunicationItem("9", Compass.getBedWars().getForCurrentVersion("IRON_FENCE", "IRON_FENCE", "IRON_BARS"), 22, MenuType.NONE);
            this.saveCommunicationItem("10", "IRON_SWORD", 23, MenuType.TEAM);
            this.saveCommunicationItem("11", "DIAMOND", 24, MenuType.RESOURCE);
            this.saveCommunicationItem("12", "FEATHER", 25, MenuType.NONE);
        }
        yml.addDefault("communication-menus.teams.size", (Object)36);
        yml.addDefault("communication-menus.teams.slots", (Object)"10,11,12,13,14,15,16,19,20,21,22,23,24,25");
        this.saveItem("communication-menus.teams.back-item", "ARROW", 31);
        yml.addDefault("communication-menus.resources.size", (Object)36);
        this.saveItem("communication-menus.resources.back-item", "ARROW", 31);
        this.saveResource("communication-menus.resources.iron", "IRON_INGOT", 12);
        this.saveResource("communication-menus.resources.gold", "GOLD_INGOT", 14);
        this.saveResource("communication-menus.resources.diamond", "DIAMOND", 10);
        this.saveResource("communication-menus.resources.emerald", "EMERALD", 16);
        yml.options().copyDefaults(true);
        this.save();
    }

    private void saveResource(String path, String material, int slot) {
        this.getYml().addDefault(path + ".material", (Object)material);
        this.getYml().addDefault(path + ".enchanted", (Object)false);
        this.getYml().addDefault(path + ".slot", (Object)slot);
    }

    private void saveItem(String path, String material, int slot) {
        this.getYml().addDefault(path + ".material", (Object)material);
        this.getYml().addDefault(path + ".enchanted", (Object)false);
        this.getYml().addDefault(path + ".slot", (Object)slot);
    }

    private void saveItem(String path, String material) {
        this.getYml().addDefault(path + ".material", (Object)material);
        this.getYml().addDefault(path + ".enchanted", (Object)false);
    }

    private void saveCommunicationItem(String path, String material, int slot, MenuType menuType) {
        path = "menus.communications.items." + path;
        this.getYml().addDefault(path + ".material", (Object)material);
        this.getYml().addDefault(path + ".enchanted", (Object)false);
        this.getYml().addDefault(path + ".slot", (Object)slot);
        this.getYml().addDefault(path + ".menu", (Object)menuType.toString());
    }

    public ItemStack getResourceItem(Player player, String name, String path) {
        name = "communication-menus.resources." + name;
        YamlConfiguration msg = MessagesData.getYml(player);
        String displayName = msg.getString(path).replace("{resource}", msg.getString("addons.compass." + name + ".resource-name"));
        return new ItemBuilder(this.getString(name + ".material")).setDisplayName(displayName).setLore(msg.getStringList("addons.compass.communication-menus.lore").stream().map(s -> s.replace("{message}", displayName)).collect(Collectors.toList())).setEnchanted(this.getBoolean(name + ".enchanted")).addTag("path", path).addTag("data", "resource-item").addTag("slot", this.getInt(name + ".slot")).build();
    }

    public ItemStack getCommunicationItem(Player player, String path) {
        return new ItemBuilder(this.getItem(player, path, true, "communication-item")).addTag("path", "addons.compass." + path + ".message").addTag("menuType", this.getString(path + ".menu")).build();
    }

    public ItemStack getItem(Player player, String path, boolean hasSlot, String customData) {
        YamlConfiguration msg = MessagesData.getYml(player);
        ItemBuilder ib = new ItemBuilder(this.getString(path + ".material")).setEnchanted(this.getBoolean(path + ".enchanted")).setDisplayName(msg.getString("addons.compass." + path + ".display-name")).setLore(msg.getStringList("addons.compass." + path + ".lore"));
        if (customData != null) {
            ib.addTag("data", customData);
        }
        if (hasSlot) {
            ib.addTag("slot", this.getInt(path + ".slot"));
        }
        return ib.build();
    }
}

