/*
 * Decompiled with CFR 0.152.
 */
package club.mher.compass.data;

import com.andrei1058.bedwars.api.language.Language;
import java.util.Arrays;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessagesData {
    public static final String PATH = "addons.compass.";
    public static final String NOT_ALL_BEDS_DESTROYED = "addons.compass.messages.not-all-beds-destroyed";
    public static final String PURCHASED = "addons.compass.messages.purchase-message";
    public static final String NOT_ENOUGH_RESOURCE = "addons.compass.messages.not-enough-resource";
    public static final String ALREADY_TRACKING = "addons.compass.messages.already-tracking";
    public static final String STATUS_UNLOCKED = "addons.compass.tracker-status.unlocked";
    public static final String STATUS_LOCKED = "addons.compass.tracker-status.locked";
    public static final String STATUS_NOT_ENOUGH = "addons.compass.tracker-status.not-enough";
    public static final String ACTION_BAR_TRACKING = "addons.compass.action-bar.tracking-format";
    public static final String TEAM_MESSAGE_FORMAT = "addons.compass.team-message-format";
    public static final String MAIN_MENU_TITLE = "addons.compass.menus.main-menu.title";
    public static final String TRACKER_MENU_TITLE = "addons.compass.menus.tracker-menu.title";
    public static final String COMMUNICATIONS_MENU_TITLE = "addons.compass.menus.communications.title";
    public static final String COMMUNICATIONS_MENU_RESOURCES_TITLE = "addons.compass.communication-menus.resources.title";
    public static final String COMMUNICATIONS_MENU_TEAMS_TITLE = "addons.compass.communication-menus.teams.title";
    public static final String COMMUNICATIONS_MENU_LORE = "addons.compass.communication-menus.lore";

    public MessagesData() {
        this.setupMessages();
    }

    public void setupMessages() {
        for (Language l : Language.getLanguages()) {
            YamlConfiguration yml = l.getYml();
            switch (l.getIso()) {
                case "fa": {
                    yml.addDefault(NOT_ALL_BEDS_DESTROYED, (Object)"&cHich Kodoom Az Bed Haye Doshman Kharab Nashode!");
                    yml.addDefault(PURCHASED, (Object)"&cShoma In Ghabeliat Ro Az Dast Midid Age Bemirid Va Dige Nemitoonid Track Konid!");
                    yml.addDefault(NOT_ENOUGH_RESOURCE, (Object)"&cShoma Resource Haye Kafy Baraye In Kar Ro Nadarid!");
                    yml.addDefault(ALREADY_TRACKING, (Object)"&cShoma Az Ghabl In Team Ro Track Kardid!");
                    yml.addDefault(STATUS_NOT_ENOUGH, (Object)"&cShoma Resource Kafy Nadarid!");
                    yml.addDefault(STATUS_LOCKED, (Object)"&cVaqty Baz Mishe Ke Hameye Bed Haye Harif Hatoon Kharab She");
                    yml.addDefault(STATUS_UNLOCKED, (Object)"&eClick Kon Ta Bekhary!");
                    yml.addDefault(ACTION_BAR_TRACKING, (Object)"&fTracking: {teamColor}&l{target} &f- Distance: &a&l{distance}m");
                    yml.addDefault(TEAM_MESSAGE_FORMAT, (Object)"&a&lTEAM > &7{player}: {message}");
                    this.saveItem(yml, "compass-item", "&aCompass &7(Rast Click)", new String[0]);
                    this.saveItem(yml, "tracker-shop", "&aForooshgahe Tracker ", "&7Yek Tracker Bekhar Ta", "&7Az Compasset Baraye Track Kardane", "&7Harif Estefade Kon", "&7In Ghabeliat Ta Vaqty Hast Ke Bemiri");
                    yml.addDefault(MAIN_MENU_TITLE, (Object)"&8Tracker & Communications");
                    this.saveItem(yml, "menus.main-menu.tracker", "&aForooshgahe Tracker ", "&7Yek Tracker Bekhar Ta", "&7Az Compasset Baraye Track Kardane", "&7Harif Estefade Kon", "&7In Ghabeliat Ta Vaqty Hast Ke Bemiri", "", "&eClick Kon Ta Baz She!");
                    this.saveItem(yml, "menus.main-menu.tracker-team", "&aForooshgahe Tracker ", "&7Yek Tracker Bekhar Ta", "&7Az Compasset Baraye Track Kardane", "&7Harif Estefade Kon", "&7In Ghabeliat Ta Vaqty Hast Ke Bemiri", "", "&eClick Kon Ta Baz She!");
                    this.saveItem(yml, "menus.main-menu.communications", "&aQuick Communications", "&7Yek Payame Moshkhas Shode", "&7Baraye Ham Teami Yat Befres!", "", "&eClick Kon Ta Baz She!");
                    yml.addDefault(TRACKER_MENU_TITLE, (Object)"&8Kharide Enemy Tracker");
                    this.saveItem(yml, "menus.tracker-menu.team-item", "&cTrack Kardane Teame {team}", "&7Yek Tracker Bekhar Ta", "&7Az Compasset Baraye Track Kardane", "&7Harif Estefade Kon", "&7In Ghabeliat Ta Vaqty Hast Ke Bemiri", "", "&7Cost: &22 Emeralds", "", "{status}");
                    this.saveItem(yml, "menus.tracker-menu.back-item", "&aBargasht", "&7Be Tracker & Communication");
                    yml.addDefault(COMMUNICATIONS_MENU_TITLE, (Object)"&8Ertebate Sarry!");
                    this.saveItem(yml, "menus.communications.back-item", "&aBargasht", "&7Be Tracker & Communication");
                    if (yml.getString("addons.compass.menus.communications.items") == null) {
                        this.saveCommunicationItem(yml, "1", "&aSalam ( \uff9f\u25e1\uff9f)/!", "&aSalam ( \uff9f\u25e1\uff9f)/!", "", "&eClick Kon Ta Befresty!");
                        this.saveCommunicationItem(yml, "2", "&aDaram Be Base Barmigardam", "&aDaram Be Base Barmigardam", "", "&eClick Kon Ta Befresty!");
                        this.saveCommunicationItem(yml, "3", "&aDaram Defa Mikonam!", "&aDaram Defa Mikonam!", "", "&eClick Kon Ta Befresty!");
                        this.saveCommunicationItem(yml, "4", "&aDaram Rush Midam Be Teame {team}", "&aDaram Rush Midam!", "&7Shoma In Ghabeliat Ro Darid Ke", "&7Yek Team Ro Entekhab Konid", "", "&eClick Kon Ta Befresty!");
                        this.saveCommunicationItem(yml, "5", "&aDaram {resource} &aJam Mikonam", "&aDaram Resource Jam Mikonam!", "&7Shoma In Ghabeliat Ro Darid Ke", "&7Resource Ro Entekhab Konid", "", "&eClick Kon Ta Befresty!");
                        this.saveCommunicationItem(yml, "6", "&7{resource} &aGereftam", "&aResource Gereftam!", "&7Shoma In Ghabeliat Ro Darid Ke", "&7Resource Ro Entekhab Konid", "", "&eClick Kon Ta Befresty!");
                        this.saveCommunicationItem(yml, "7", "&aMamnoon", "&aMamnoon!", "", "&eClick Kon Ta Befresty!");
                        this.saveCommunicationItem(yml, "8", "&aBargard Be Base", "&aBargard Be Base!", "", "&eClick Kon Ta Befresty!");
                        this.saveCommunicationItem(yml, "9", "&aLotfan Defa Kon!", "&aLotfan Defa Kon!", "", "&eClick Kon Ta Befresty!");
                        this.saveCommunicationItem(yml, "10", "&aBerim Be {team} &aHamle Konim", "&aBerim Rush Bedim!", "&7Shoma In Ghabeliat Ro Darid Ke", "&7Yek Team Ro Entekhab Konid", "", "&eClick Kon Ta Befresty!");
                        this.saveCommunicationItem(yml, "11", "&aMa Be {resource} &aNiaz Darim.", "&aBe Resource Niaz Darim!", "&7Shoma In Ghabeliat Ro Darid Ke", "&7Resource Ro Entekhab Konid", "", "&eClick Kon Ta Befresty!");
                        this.saveCommunicationItem(yml, "12", "&aYe Player Dare Miad!", "&aPlayer Dare Miad!!", "", "&eClick Kon Ta Befresty!");
                    }
                    yml.addDefault(COMMUNICATIONS_MENU_LORE, Arrays.asList("&7Click Kon Ta Payam Ro Befresty: '{message}&7'", "&7Be Hamtimiat!", "", "&eClick Kon Ta Befresty!"));
                    yml.addDefault(COMMUNICATIONS_MENU_TEAMS_TITLE, (Object)"&8Select an option:");
                    this.saveItem(yml, "communication-menus.teams.back-item", "&aBargasht", "&7Be Quick Communications");
                    yml.addDefault(COMMUNICATIONS_MENU_RESOURCES_TITLE, (Object)"&8Select an option:");
                    this.saveItem(yml, "communication-menus.resources.back-item", "&aBargasht", "&7Be Quick Communications");
                    this.saveResource(yml, "communication-menus.resources.iron", "&f&lIRON");
                    this.saveResource(yml, "communication-menus.resources.gold", "&6&lGOLD");
                    this.saveResource(yml, "communication-menus.resources.diamond", "&b&lDIAMOND");
                    this.saveResource(yml, "communication-menus.resources.emerald", "&2&lEMERALD");
                }
                case "es": {
                    yml.addDefault(NOT_ALL_BEDS_DESTROYED, (Object)"&cNo todos los enemigos tienen la cama destruida!");
                    yml.addDefault(PURCHASED, (Object)"&cPerder\u00e1s la habilidad de rastrear a este equipo cuando mueras!");
                    yml.addDefault(NOT_ENOUGH_RESOURCE, (Object)"&cNo tienes suficientes recursos!");
                    yml.addDefault(ALREADY_TRACKING, (Object)"&cYa estas rastreando a este equipo!");
                    yml.addDefault(STATUS_NOT_ENOUGH, (Object)"&cNo tienes suficientes recursos!");
                    yml.addDefault(STATUS_LOCKED, (Object)"&cSe desbloqueara cuando todas las camas enemigas esten destruidas!");
                    yml.addDefault(STATUS_UNLOCKED, (Object)"&eClick para comprar!");
                    yml.addDefault(ACTION_BAR_TRACKING, (Object)"&fRastreando a: {teamColor}&l{target} &f- Distancia: &a&l{distance}m");
                    yml.addDefault(TEAM_MESSAGE_FORMAT, (Object)"&a&lTEAM > &7{player}: {message}");
                    this.saveItem(yml, "compass-item", "&aBrujula &7(Click Derecho)", new String[0]);
                    this.saveItem(yml, "tracker-shop", "&aTracker Shop", "&7Purchase tracking update for", "&7your compass which will track", "&7each player on a specific team", "&7until you die.");
                    yml.addDefault(MAIN_MENU_TITLE, (Object)"&7Comunicaci\u00f3n r\u00e1pida y rastreador");
                    this.saveItem(yml, "menus.main-menu.tracker", "&aTienda de rastreadores", "&7Compra la habilidad de rastrear", "&7para tu br\u00fajula", "&7rastreando a cada jugador en un", "&7equipo espec\u00edfico hasta", "&7que mueras.", "", "&eClick para abrir!");
                    this.saveItem(yml, "menus.main-menu.tracker-team", "&aTienda de rastreadores", "&7Compra la habilidad de rastrear", "&7para tu br\u00fajula", "&7rastreando a cada jugador en un", "&7equipo espec\u00edfico hasta", "&7que mueras.", "", "&eClick para abrir!");
                    this.saveItem(yml, "menus.main-menu.communications", "&aComunicaci\u00f3n r\u00e1pida", "&7Env\u00eda un chat r\u00e1pido a", "&7tu equipo!", "", "&eClick para abrir!");
                    yml.addDefault(TRACKER_MENU_TITLE, (Object)"&8Comprar rastreador de enemigos");
                    this.saveItem(yml, "menus.tracker-menu.team-item", "&cRastrear equipo {team}", "&7Compra la habilidad de rastrear", "&7para tu br\u00fajula", "&7rastreando a cada jugador en un", "&7equipo espec\u00edfico hasta", "&7que mueras.", "", "&7Precio: &22 Emeralds", "", "{status}");
                    this.saveItem(yml, "menus.tracker-menu.back-item", "&aAtr\u00e1s", "&7A Comunicaci\u00f3n r\u00e1pida y rastreador");
                    yml.addDefault(COMMUNICATIONS_MENU_TITLE, (Object)"&8Comunicaci\u00f3n rap\u00edda");
                    this.saveItem(yml, "menus.communications.back-item", "&aAtr\u00e1s", "&7A Comunicaci\u00f3n r\u00e1pida y rastreador");
                    if (yml.getString("addons.compass.menus.communications.items") == null) {
                        this.saveCommunicationItem(yml, "1", "&aHola ( \uff9f\u25e1\uff9f)/!", "&aHola ( \uff9f\u25e1\uff9f)/!", "", "&eClick apra enviar!");
                        this.saveCommunicationItem(yml, "2", "&aEstoy volviendo a la base!", "&aEstoy volviendo a la base!", "", "&eClick para enviar!");
                        this.saveCommunicationItem(yml, "3", "&aEstoy defendiendo!", "&aEstoy defendiendo!", "", "&eClick para enviar!");
                        this.saveCommunicationItem(yml, "4", "&aEstoy atacando a {team}", "&aEstoy atacando!", "&7Tienes que seleccionar", "&7el equipo", "", "&eClick para enviar!");
                        this.saveCommunicationItem(yml, "5", "&aEstoy recolectando {resource}", "&aEstoy recolectando recursos!", "&7Tienes que seleccionar", "&7el material", "", "&eClick para enviar!");
                        this.saveCommunicationItem(yml, "6", "&aTengo {resource}", "&aTengo materiales!", "&7Tienes que seleccionar", "&7el material", "", "&eClick para enviar!");
                        this.saveCommunicationItem(yml, "7", "&aGracias!", "&aGracias!", "", "&eClick para enviar!");
                        this.saveCommunicationItem(yml, "8", "&aVuelve a la base", "&aVuelve a la base!", "", "&eClick para enviar!");
                        this.saveCommunicationItem(yml, "9", "&aPorfavor, defiende!", "&aPorfavor, defiende!", "", "&eClick para enviar!");
                        this.saveCommunicationItem(yml, "10", "&aVamos a atacar a {team}", "&aVamos a atacar!", "&7Tienes que seleccionar", "&7el equipo", "", "&eClick para enviar!");
                        this.saveCommunicationItem(yml, "11", "&aNecesitamos {resource}", "&aNecesitamos materiales!", "&7Tienes que seleccionar", "&7el material", "", "&eClick para enviar!");
                        this.saveCommunicationItem(yml, "12", "&aEsta entrando un jugador!", "&aEsta entrando un jugador!", "", "&eClick para enviar!");
                    }
                    yml.addDefault(COMMUNICATIONS_MENU_LORE, (Object)new String[]{"&7Click para enviar: '{message}&7'", "&7a tu equipo!", "", "&eClick para enviar!"});
                    yml.addDefault(COMMUNICATIONS_MENU_TEAMS_TITLE, (Object)"&8Select an option:");
                    this.saveItem(yml, "communication-menus.teams.back-item", "&aVolver", "&7A comunicacion r\u00e1pida");
                    yml.addDefault(COMMUNICATIONS_MENU_RESOURCES_TITLE, (Object)"&8Selecciona una accion:");
                    this.saveItem(yml, "communication-menus.resources.back-item", "&aVolver", "&7A comunicacion r\u00e1pida");
                    this.saveResource(yml, "communication-menus.resources.iron", "&f&lHIERRO");
                    this.saveResource(yml, "communication-menus.resources.gold", "&6&lORO");
                    this.saveResource(yml, "communication-menus.resources.diamond", "&b&lDIAMANTES");
                    this.saveResource(yml, "communication-menus.resources.emerald", "&2&lESMERALDAS");
                    break;
                }
                case "ru": {
                    yml.addDefault(NOT_ALL_BEDS_DESTROYED, (Object)"&c\u0415\u0449\u0435 \u043d\u0435 \u0432\u0441\u0435 \u0432\u0440\u0430\u0436\u0435\u0441\u043a\u0438\u0435 \u043a\u0440\u043e\u0432\u0430\u0442\u0438 \u0443\u043d\u0438\u0447\u0442\u043e\u0436\u0435\u043d\u044b!");
                    yml.addDefault(PURCHASED, (Object)"&c\u0412\u044b \u043f\u043e\u0442\u0435\u0440\u044f\u0435\u0442\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u0442\u044c \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443, \u043a\u043e\u0433\u0434\u0430 \u0443\u043c\u0440\u0435\u0442\u0435!");
                    yml.addDefault(NOT_ENOUGH_RESOURCE, (Object)"&c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432!");
                    yml.addDefault(ALREADY_TRACKING, (Object)"&c\u0412\u044b \u0443\u0436\u0435 \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u0435\u0442\u0435 \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443!");
                    yml.addDefault(STATUS_NOT_ENOUGH, (Object)"&c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432!");
                    yml.addDefault(STATUS_LOCKED, (Object)"&c\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u0435\u0442\u0441\u044f, \u043a\u043e\u0433\u0434\u0430 \u0432\u0441\u0435 \u0432\u0440\u0430\u0436\u0435\u0441\u043a\u0438\u0435 \u043a\u0440\u043e\u0432\u0430\u0442\u0438 \u0443\u043d\u0438\u0447\u0442\u043e\u0436\u0435\u043d\u044b!");
                    yml.addDefault(STATUS_UNLOCKED, (Object)"&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043a\u0443\u043f\u0438\u0442\u044c!");
                    yml.addDefault(ACTION_BAR_TRACKING, (Object)"&f\u041e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u043d\u0438\u0435: {teamColor}&l{target} &f- \u0434\u0438\u0441\u0442\u0430\u043d\u0446\u0438\u044f: &a&l{distance}m");
                    yml.addDefault(TEAM_MESSAGE_FORMAT, (Object)"&a&l\u041a\u041e\u041c\u0410\u041d\u0414\u0410 > &7{player}: {message}");
                    this.saveItem(yml, "compass-item", "&a\u041a\u043e\u043c\u043f\u0430\u0441 &7(\u041f\u041a\u041c)", new String[0]);
                    this.saveItem(yml, "tracker-shop", "&aTracker Shop", "&7Purchase tracking update for", "&7your compass which will track", "&7each player on a specific team", "&7until you die.");
                    yml.addDefault(MAIN_MENU_TITLE, (Object)"&8\u0422\u0440\u0435\u043a\u0435\u0440 \u0438 \u043a\u043e\u043c\u043c\u0443\u043d\u0438\u043a\u0430\u0446\u0438\u0438");
                    this.saveItem(yml, "menus.main-menu.tracker", "&a\u041c\u0430\u0433\u0430\u0437\u0438\u043d \u0442\u0440\u0435\u043a\u0435\u0440\u043e\u0432", "&7\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043f\u043e\u043a\u0443\u043f\u043e\u043a", "&7\u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0433\u043e \u043a\u043e\u043c\u043f\u0430\u0441\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0431\u0443\u0434\u0435\u0442", "&7\u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u0442\u044c \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0438\u0433\u0440\u043e\u043a\u0430 \u043d\u0430", "&7\u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430, \u043f\u043e\u043a\u0430 \u0432\u044b", "&7\u0443\u043c\u0440\u0438.", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u044c!");
                    this.saveItem(yml, "menus.main-menu.tracker-team", "&a\u041c\u0430\u0433\u0430\u0437\u0438\u043d \u0442\u0440\u0435\u043a\u0435\u0440\u043e\u0432", "&7\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043f\u043e\u043a\u0443\u043f\u043e\u043a", "&7\u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0433\u043e \u043a\u043e\u043c\u043f\u0430\u0441\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0431\u0443\u0434\u0435\u0442", "&7\u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u0442\u044c \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0438\u0433\u0440\u043e\u043a\u0430 \u043d\u0430", "&7\u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430, \u043f\u043e\u043a\u0430 \u0432\u044b", "&7\u0443\u043c\u0440\u0438.", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u044c!");
                    this.saveItem(yml, "menus.main-menu.communications", "&a\u0411\u044b\u0441\u0442\u0440\u043e\u0435 \u043e\u0431\u0449\u0435\u043d\u0438\u0435", "&7\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439 \u0447\u0430\u0442", "&7\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0441\u0432\u043e\u0438\u043c \u0442\u043e\u0432\u0430\u0440\u0438\u0449\u0430\u043c", "&7\u043f\u043e \u043a\u043e\u043c\u0430\u043d\u0434\u0435!", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u044c!");
                    yml.addDefault(TRACKER_MENU_TITLE, (Object)"&8\u041f\u043e\u043a\u0443\u043f\u043a\u0430 \u0412\u0440\u0430\u0433 \u0422\u0440\u0435\u043a\u0435\u0440");
                    this.saveItem(yml, "menus.tracker-menu.team-item", "&c\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0442\u0440\u0435\u043a\u0430 {team}", "&7\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043f\u043e\u043a\u0443\u043f\u043e\u043a", "&7\u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0433\u043e \u043a\u043e\u043c\u043f\u0430\u0441\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0431\u0443\u0434\u0435\u0442", "&7\u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u0442\u044c \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0438\u0433\u0440\u043e\u043a\u0430 \u043d\u0430", "&7\u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430, \u043f\u043e\u043a\u0430 \u0432\u044b", "&7\u0443\u043c\u0440\u0438.", "", "&7\u0420\u0430\u0441\u0445\u043e\u0434\u044b: &22 \u0418\u0437\u0443\u043c\u0440\u0443\u0434\u044b", "", "{status}");
                    this.saveItem(yml, "menus.tracker-menu.back-item", "&a\u0412\u0435\u0440\u043d\u0438\u0442\u0435\u0441\u044c \u043d\u0430\u0437\u0430\u0434", "&7\u041a \u0442\u0440\u0435\u043a\u0435\u0440\u0443 \u0438 \u0441\u0432\u044f\u0437\u0438");
                    yml.addDefault(COMMUNICATIONS_MENU_TITLE, (Object)"&8\u0411\u044b\u0441\u0442\u0440\u043e\u0435 \u043e\u0431\u0449\u0435\u043d\u0438\u0435");
                    this.saveItem(yml, "menus.communications.back-item", "&a\u0412\u0435\u0440\u043d\u0438\u0442\u0435\u0441\u044c \u043d\u0430\u0437\u0430\u0434", "&7\u041a \u0442\u0440\u0435\u043a\u0435\u0440\u0443 \u0438 \u0441\u0432\u044f\u0437\u0438");
                    if (yml.getString("addons.compass.menus.communications.items") == null) {
                        this.saveCommunicationItem(yml, "1", "&a\u041f\u0440\u0438\u0432\u0435\u0442 ( \uff9f\u25e1\uff9f)/!", "&a\u041f\u0440\u0438\u0432\u0435\u0442 ( \uff9f\u25e1\uff9f)/!", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c!");
                        this.saveCommunicationItem(yml, "2", "&a\u042f \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u044e\u0441\u044c \u043d\u0430 \u0431\u0430\u0437\u0443!", "&a\u042f \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u044e\u0441\u044c \u043d\u0430 \u0431\u0430\u0437\u0443!", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c!");
                        this.saveCommunicationItem(yml, "3", "&a\u042f \u0437\u0430\u0449\u0438\u0449\u0430\u044e\u0441\u044c!", "&a\u042f \u0437\u0430\u0449\u0438\u0449\u0430\u044e\u0441\u044c!", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c!");
                        this.saveCommunicationItem(yml, "4", "&a\u042f \u0430\u0442\u0430\u043a\u0443\u044e {team}", "&a\u042f \u0430\u0442\u0430\u043a\u0443\u044e!", "&7\u0412\u044b \u0441\u043c\u043e\u0436\u0435\u0442\u0435 \u0432\u044b\u0431\u0440\u0430\u0442\u044c", "&7\u043a\u043e\u043c\u0430\u043d\u0434\u0430", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c!");
                        this.saveCommunicationItem(yml, "5", "&a\u042f \u0441\u043e\u0431\u0438\u0440\u0430\u044e {resource}", "&a\u0421\u043e\u0431\u0438\u0440\u0430\u044e \u0440\u0435\u0441\u0443\u0440\u0441\u044b!", "&7\u0412\u044b \u0441\u043c\u043e\u0436\u0435\u0442\u0435 \u0432\u044b\u0431\u0440\u0430\u0442\u044c", "&7\u0440\u0435\u0441\u0443\u0440\u0441", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c!");
                        this.saveCommunicationItem(yml, "6", "&a\u0423 \u043c\u0435\u043d\u044f \u0435\u0441\u0442\u044c {resource}", "&a\u0423 \u043c\u0435\u043d\u044f \u0435\u0441\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441\u044b!", "&7\u0412\u044b \u0441\u043c\u043e\u0436\u0435\u0442\u0435 \u0432\u044b\u0431\u0440\u0430\u0442\u044c", "&7\u0440\u0435\u0441\u0443\u0440\u0441", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c!");
                        this.saveCommunicationItem(yml, "7", "&a\u0421\u043f\u0430\u0441\u0438\u0431\u043e", "&a\u0421\u043f\u0430\u0441\u0438\u0431\u043e", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c!");
                        this.saveCommunicationItem(yml, "8", "&a\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0439\u0441\u044f \u043d\u0430 \u0431\u0430\u0437\u0443!", "&a\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0439\u0441\u044f \u043d\u0430 \u0431\u0430\u0437\u0443!", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c!");
                        this.saveCommunicationItem(yml, "9", "&a\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0437\u0430\u0449\u0438\u0449\u0430\u0439\u0442\u0435\u0441\u044c!", "&a\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0437\u0430\u0449\u0438\u0449\u0430\u0439\u0442\u0435\u0441\u044c!", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c!");
                        this.saveCommunicationItem(yml, "10", "&a\u0410\u0442\u0430\u043a\u0443\u0435\u043c {team}", "&a\u0410\u0442\u0430\u043a\u0443\u0435\u043c!", "&7\u0412\u044b \u0441\u043c\u043e\u0436\u0435\u0442\u0435 \u0432\u044b\u0431\u0440\u0430\u0442\u044c", "&7\u043a\u043e\u043c\u0430\u043d\u0434\u0430", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c!");
                        this.saveCommunicationItem(yml, "11", "&a\u041d\u0430\u043c \u043d\u0443\u0436\u043d\u043e {resource}", "&a\u041d\u0430\u043c \u043d\u0443\u0436\u043d\u044b \u0440\u0435\u0441\u0443\u0440\u0441\u044b!", "&7\u0412\u044b \u0441\u043c\u043e\u0436\u0435\u0442\u0435 \u0432\u044b\u0431\u0440\u0430\u0442\u044c", "&7\u0440\u0435\u0441\u0443\u0440\u0441", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c!");
                        this.saveCommunicationItem(yml, "12", "&a\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0438\u0433\u0440\u043e\u043a!", "&a\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0438\u0433\u0440\u043e\u043a!!", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c!");
                    }
                    yml.addDefault(COMMUNICATIONS_MENU_LORE, (Object)new String[]{"&7\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c", "&7\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: '{message}&7'", "&7\u0441\u0432\u043e\u0438\u043c \u0442\u043e\u0432\u0430\u0440\u0438\u0449\u0430\u043c \u043f\u043e \u043a\u043e\u043c\u0430\u043d\u0434\u0435!", "", "&e\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c!"});
                    yml.addDefault(COMMUNICATIONS_MENU_TEAMS_TITLE, (Object)"&8\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0430\u0440\u0438\u0430\u043d\u0442:");
                    this.saveItem(yml, "communication-menus.teams.back-item", "&a\u0412\u0435\u0440\u043d\u0438\u0442\u0435\u0441\u044c \u043d\u0430\u0437\u0430\u0434", "&7\u041a \u0431\u044b\u0441\u0442\u0440\u043e\u0439 \u0441\u0432\u044f\u0437\u0438!");
                    yml.addDefault(COMMUNICATIONS_MENU_RESOURCES_TITLE, (Object)"&8\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0430\u0440\u0438\u0430\u043d\u0442:");
                    this.saveItem(yml, "communication-menus.resources.back-item", "&a\u0412\u0435\u0440\u043d\u0438\u0442\u0435\u0441\u044c \u043d\u0430\u0437\u0430\u0434", "&7\u041a \u0431\u044b\u0441\u0442\u0440\u043e\u0439 \u0441\u0432\u044f\u0437\u0438!");
                    this.saveResource(yml, "communication-menus.resources.iron", "&f&l\u0423\u0422\u042e\u0413");
                    this.saveResource(yml, "communication-menus.resources.gold", "&6&l\u0417\u041e\u041b\u041e\u0422\u041e");
                    this.saveResource(yml, "communication-menus.resources.diamond", "&b&l\u0410\u041b\u041c\u0410\u0417");
                    this.saveResource(yml, "communication-menus.resources.emerald", "&2&l\u0418\u0417\u0423\u041c\u0420\u0423\u0414");
                    break;
                }
                case "pl": {
                    yml.addDefault(NOT_ALL_BEDS_DESTROYED, (Object)"&cWszystkie \u0142\u00f3\u017cka nie zosta\u0142y zniszczone!");
                    yml.addDefault(PURCHASED, (Object)"&cJe\u015bli umrzesz stracisz namierzanie!");
                    yml.addDefault(NOT_ENOUGH_RESOURCE, (Object)"&cMasz za malo surowc\u00f3w!");
                    yml.addDefault(ALREADY_TRACKING, (Object)"&cNamierzasz ju\u017c t\u0105 dru\u017cyn\u0119!");
                    yml.addDefault(STATUS_NOT_ENOUGH, (Object)"&cNie sta\u0107 ciebie!");
                    yml.addDefault(STATUS_LOCKED, (Object)"&cB\u0119dzi\u0119sz m\u00f3g\u0142 tego u\u017cy\u0107, je\u015bli wszystkie \u0142\u00f3\u017cka zostan\u0105 zniszczone!");
                    yml.addDefault(STATUS_UNLOCKED, (Object)"&eKliknij, aby kupi\u0107!");
                    yml.addDefault(ACTION_BAR_TRACKING, (Object)"&fNamierzanie: {teamColor}&l{target} &f- Dystans: &a&l{distance}m");
                    yml.addDefault(TEAM_MESSAGE_FORMAT, (Object)"&a&lDRU\u017bYNA > &7{player}: {message}");
                    this.saveItem(yml, "compass-item", "&aKompas &7(PRM)", new String[0]);
                    this.saveItem(yml, "tracker-shop", "&aTracker Shop", "&7Purchase tracking update for", "&7your compass which will track", "&7each player on a specific team", "&7until you die.");
                    yml.addDefault(MAIN_MENU_TITLE, (Object)"&8Namierzanie i komunikacja");
                    this.saveItem(yml, "menus.main-menu.tracker", "&aNamierzanie", "&7Kupuj\u0105c namierzanie dru\u017cyny", "&7jeste\u015b przekonany, \u017ce", "&7dojdziesz do wroga", "&7Stracisz namierzanie", "&7je\u015bli umrzesz.", "", "&eKliknij, aby otworzyc!");
                    this.saveItem(yml, "menus.main-menu.tracker-team", "&aNamierzanie", "&7Kupuj\u0105c namierzanie dru\u017cyny", "&7jeste\u015b przekonany, \u017ce", "&7dojdziesz do wroga", "&7Stracisz namierzanie", "&7je\u015bli umrzesz.", "", "&eKliknij, aby otworzyc!");
                    this.saveItem(yml, "menus.main-menu.communications", "&aSzybka komunikacja", "&7Kontaktuj si\u0119 ze", "&7swoj\u0105 dru\u017cym\u0105!", "", "&eKliknik, aby otworzy\u0107!");
                    yml.addDefault(TRACKER_MENU_TITLE, (Object)"&8Kup namierzanie");
                    this.saveItem(yml, "menus.tracker-menu.team-item", "&cNamierzaj dru\u017cyn\u0119 {team}", "&7Kupuj\u0105c namierzanie dru\u017cyny", "&7jeste\u015b przekonany, \u017ce", "&7dojdziesz do wroga.", "&7Wszystkie \u0142\u00f3\u017cka musz\u0105 zosta\u0107", "&7zniszczone, aby u\u017cyc namierzania.", "", "&7Cena: &22 Emeraldy", "", "{status}");
                    this.saveItem(yml, "menus.tracker-menu.back-item", "&aPowrot", "&7Powraca ciebie do g\u0142\u00f3wnej strony");
                    yml.addDefault(COMMUNICATIONS_MENU_TITLE, (Object)"&aSzybka komunikacja");
                    this.saveItem(yml, "menus.communications.back-item", "&aPowrot", "&7Powraca ciebie do g\u0142\u00f3wnej strony");
                    if (yml.getString("addons.compass.menus.communications.items") == null) {
                        this.saveCommunicationItem(yml, "1", "&aCze\u015b\u0107 ( \uff9f\u25e1\uff9f)/!", "&aCze\u015b\u0107 ( \uff9f\u25e1\uff9f)/!", "", "&eKliknij, aby wyslac!");
                        this.saveCommunicationItem(yml, "2", "&aWracam do bazy!", "&aWracam do bazy!", "", "&eKliknij, aby wyslac!");
                        this.saveCommunicationItem(yml, "3", "&aBroni\u0119!", "&aBroni\u0119!", "", "&eKliknij, aby wyslac!");
                        this.saveCommunicationItem(yml, "4", "&aAtakuj\u0119 dru\u017cyn\u0119 {team}", "&aAtakuj\u0119!", "&7B\u0119dziesz m\u00f3g\u0142 wybra\u0107", "&7dru\u017cyn\u0119.", "", "&eKliknij, aby wyslac!");
                        this.saveCommunicationItem(yml, "5", "&aZbieram {resource}", "&aZbieram surowce!", "&7B\u0119dziesz m\u00f3g\u0142 wybra\u0107", "&7zas\u00f3b", "", "&eKliknij, aby wyslac!");
                        this.saveCommunicationItem(yml, "6", "&aPosiadam {resource}", "&aMam surowce!", "&7B\u0119dziesz m\u00f3g\u0142 wybra\u0107", "&7zas\u00f3b", "", "&eKliknij, aby wyslac!");
                        this.saveCommunicationItem(yml, "7", "&aDzi\u0119kuj\u0119", "&aDzi\u0119kuj\u0119", "", "&eKliknij, aby wyslac!");
                        this.saveCommunicationItem(yml, "8", "&aWracaj do bazy", "&aWracaj do bazy!", "", "&eKliknij, aby wyslac!");
                        this.saveCommunicationItem(yml, "9", "&aProsz\u0119, bro\u0144 baz\u0119", "&aProsz\u0119, bro\u0144 baz\u0119!", "", "&eKliknij, aby wyslac!");
                        this.saveCommunicationItem(yml, "10", "&aZaatakujmy {team}", "&aZaatakujmy!", "&7B\u0119dziesz m\u00f3g\u0142 wybra\u0107", "&7dru\u017cyn\u0119.", "", "&eKliknij, aby wyslac!");
                        this.saveCommunicationItem(yml, "11", "&aPotrzebujemy {resource}", "&aPotrzebne nam s\u0105!", "&7B\u0119dziesz m\u00f3g\u0142 wybra\u0107", "&7zas\u00f3b", "", "&eKliknij, aby wyslac!");
                        this.saveCommunicationItem(yml, "12", "&aWrog sie zbliza!", "&aWrog sie zbliza!!", "", "&eKliknij, aby wyslac!");
                    }
                    yml.addDefault(COMMUNICATIONS_MENU_LORE, (Object)new String[]{"&7Kliknij, aby wyslac wiadomosc: '{message}&7'", "&7do twojej druzyny!", "", "&eKliknij, aby wyslac!"});
                    yml.addDefault(COMMUNICATIONS_MENU_TEAMS_TITLE, (Object)"&8Wybierz opcj\u0119:");
                    this.saveItem(yml, "communication-menus.teams.back-item", "&aPowrot", "&7Powraca ciebie do szybkiej komunimacji");
                    yml.addDefault(COMMUNICATIONS_MENU_RESOURCES_TITLE, (Object)"&8Wybierz opcj\u0119:");
                    this.saveItem(yml, "communication-menus.resources.back-item", "&aPowrot", "&7Powraca ciebie do szybkiej komunimacji");
                    this.saveResource(yml, "communication-menus.resources.iron", "&f&lZELAZO");
                    this.saveResource(yml, "communication-menus.resources.gold", "&6&lZLOTO");
                    this.saveResource(yml, "communication-menus.resources.diamond", "&b&lDIAMENT");
                    this.saveResource(yml, "communication-menus.resources.emerald", "&2&lSZMARAGD");
                    break;
                }
                case "ro": {
                    yml.addDefault(NOT_ALL_BEDS_DESTROYED, (Object)"&cNu toate paturile au fost distruse inca!");
                    yml.addDefault(PURCHASED, (Object)"&cO sa pierzi abilitatea de a urmarii aceasta echipa cand vei murii!");
                    yml.addDefault(NOT_ENOUGH_RESOURCE, (Object)"&cNu ai destule resurse!");
                    yml.addDefault(ALREADY_TRACKING, (Object)"&cDeja urmaresti aceasta echipa!");
                    yml.addDefault(STATUS_NOT_ENOUGH, (Object)"&cNu ai destule resurse!");
                    yml.addDefault(STATUS_LOCKED, (Object)"&cSe va debloca cand toate paturile inamicilor vor fi distruse!");
                    yml.addDefault(STATUS_UNLOCKED, (Object)"&eClick pentru a cumpara!");
                    yml.addDefault(ACTION_BAR_TRACKING, (Object)"&fUrmaresti: {teamColor}&l{target} &f- Distanta: &a&l{distance}m");
                    yml.addDefault(TEAM_MESSAGE_FORMAT, (Object)"&a&lEchipa > &7{player}: {message}");
                    this.saveItem(yml, "compass-item", "&aCompas &7(Click Dreapta)", new String[0]);
                    this.saveItem(yml, "tracker-shop", "&aTracker Shop", "&7Purchase tracking update for", "&7your compass which will track", "&7each player on a specific team", "&7until you die.");
                    yml.addDefault(MAIN_MENU_TITLE, (Object)"&8Tracker & Communications");
                    this.saveItem(yml, "menus.main-menu.tracker", "&aMagazin de Trackere", "&7Cumpara tracker upgrades", "&7pentru compasul care va", "&7urmarii jucatorii dintr-o", "&7echipa specifica pana cand tu vei", "&7murii.", "", "&eClick sa deschizi!");
                    this.saveItem(yml, "menus.main-menu.tracker-team", "&aMagazin de Trackere", "&7Cumpara tracker upgrades", "&7pentru compasul care va", "&7urmarii jucatorii dintr-o", "&7echipa specifica pana cand tu vei", "&7murii.", "", "&eClick sa deschizi!");
                    this.saveItem(yml, "menus.main-menu.communications", "&aComunicare rapida", "&7Trimite mesaje evidentiate", "&7catre echipa ta!", "", "&eClick sa deschizi!");
                    yml.addDefault(TRACKER_MENU_TITLE, (Object)"&8Cumpara tracker inamic");
                    this.saveItem(yml, "menus.tracker-menu.team-item", "&cUrmareste echipa {team}", "&7Cumpara tracker upgrades", "&7pentru compasul care va", "&7urmarii jucatorii dintr-o", "&7echipa specifica pana cand tu vei", "&7murii.", "", "&7Cost: &22 Emeralde", "", "{status}");
                    this.saveItem(yml, "menus.tracker-menu.back-item", "&aDu-te inapoi", "&7To Tracker & Communication");
                    yml.addDefault(COMMUNICATIONS_MENU_TITLE, (Object)"&8Comunicare Rapida");
                    this.saveItem(yml, "menus.communications.back-item", "&aDu-te inapoi", "&7To Tracker & Communication");
                    if (yml.getString("addons.compass.menus.communications.items") == null) {
                        this.saveCommunicationItem(yml, "1", "&aSalut ( \uff9f\u25e1\uff9f)/!", "&aSalut ( \uff9f\u25e1\uff9f)/!", "", "&eClick sa trimiti!");
                        this.saveCommunicationItem(yml, "2", "&aRevin catre baza", "&aRevin catre baza!", "", "&eClick sa trimiti!");
                        this.saveCommunicationItem(yml, "3", "&aSunt in aparare", "&aSunt in aparare!", "", "&eClick sa trimiti!");
                        this.saveCommunicationItem(yml, "4", "&aAtac echipa {team}", "&aSunt in atac!", "&7Vei avea posibilitatea de a", "&7selecta echipa", "", "&eClick sa trimiti!");
                        this.saveCommunicationItem(yml, "5", "&aColectez {resource}", "&aColectez resurse!", "&7Vei avea posibilitatea de a", "&7selecta resursa", "", "&eClick sa trimiti!");
                        this.saveCommunicationItem(yml, "6", "&aAm {resource}", "&aAm resursa!", "&7Vei avea posibilitatea de a", "&7selecta resursa", "", "&eClick sa trimiti!");
                        this.saveCommunicationItem(yml, "7", "&aMultumesc", "&aMultumesc!", "", "&eClick sa trimiti!");
                        this.saveCommunicationItem(yml, "8", "&aDu-te inapoi in baza", "&aDu-te inapoi in baza", "", "&eClick sa trimiti!");
                        this.saveCommunicationItem(yml, "9", "&aTe rog apara!", "&aTe rog apara!", "", "&eClick sa trimiti!");
                        this.saveCommunicationItem(yml, "10", "&aSa atacam echipa {team}", "&aSa atacam!", "&7Vei avea posibilitatea de a", "&7selecta echipa", "", "&eClick sa trimiti!");
                        this.saveCommunicationItem(yml, "11", "&aAvem nevoie de {resource}", "&aAvem nevoie de resurse!", "&7Vei avea posibilitatea de a", "&7selecta resursa", "", "&eClick sa trimiti!");
                        this.saveCommunicationItem(yml, "12", "&aVine un player!", "&aVine un player!!", "", "&eClick sa trimiti!");
                    }
                    yml.addDefault(COMMUNICATIONS_MENU_LORE, (Object)new String[]{"&7Click sa trimiti mesajul: '{message}&7'", "&7catre echipa ta", "", "&eClick sa trimiti!"});
                    yml.addDefault(COMMUNICATIONS_MENU_TEAMS_TITLE, (Object)"&8Selecteaza o optiunea:");
                    this.saveItem(yml, "communication-menus.teams.back-item", "&aDu-te inapoi", "&7Catre comunicare rapida");
                    yml.addDefault(COMMUNICATIONS_MENU_RESOURCES_TITLE, (Object)"&8Selecteaza o optiune:");
                    this.saveItem(yml, "communication-menus.resources.back-item", "&aDu-te inapoi", "&7Catre comunicare rapida");
                    this.saveResource(yml, "communication-menus.resources.iron", "&f&lFIER");
                    this.saveResource(yml, "communication-menus.resources.gold", "&6&lAUR");
                    this.saveResource(yml, "communication-menus.resources.diamond", "&b&lDIAMANT");
                    this.saveResource(yml, "communication-menus.resources.emerald", "&2&lEMERALD");
                    break;
                }
                case "it": {
                    yml.addDefault(NOT_ALL_BEDS_DESTROYED, (Object)"&cNon sono distrutti tutti i letti!");
                    yml.addDefault(PURCHASED, (Object)"&cPerderai l'abilit\u00e0 di rintracciare i giocatori alla morte!");
                    yml.addDefault(NOT_ENOUGH_RESOURCE, (Object)"&cNon hai abbastanza risorse!");
                    yml.addDefault(ALREADY_TRACKING, (Object)"&cStai gi\u00e0 rintracciando un team!");
                    yml.addDefault(STATUS_NOT_ENOUGH, (Object)"&cNon ha abbastanza risorse!");
                    yml.addDefault(STATUS_LOCKED, (Object)"&cSi sbloccher\u00e0 quando tutti i letti sono distrutti!");
                    yml.addDefault(STATUS_UNLOCKED, (Object)"&eClicca per acquistare!");
                    yml.addDefault(ACTION_BAR_TRACKING, (Object)"&fTracking: {teamColor}&l{target} &f- Distanza: &a&l{distance}m");
                    yml.addDefault(TEAM_MESSAGE_FORMAT, (Object)"&a&lTEAM > &7{player}: {message}");
                    this.saveItem(yml, "compass-item", "&aBussola &7(Click destro)", new String[0]);
                    this.saveItem(yml, "tracker-shop", "&aTracker Shop", "&7Purchase tracking update for", "&7your compass which will track", "&7each player on a specific team", "&7until you die.");
                    yml.addDefault(MAIN_MENU_TITLE, (Object)"&8Tracker & Comunicazioni");
                    this.saveItem(yml, "menus.main-menu.tracker", "&aAcquista il tracker", "&7Compra l'aggiornamento Tracker", "&7che ci penser\u00e0 la tua bussola a farlo", "&7Rintraccia ogni giocatore in una", "&7squadra specifica fino alla", "&7tua morte!.", "", "&eClicca per aprire!");
                    this.saveItem(yml, "menus.main-menu.tracker-team", "&aAcquista il tracker", "&7Compra l'aggiornamento Tracker", "&7che ci penser\u00e0 la tua bussola a farlo", "&7Rintraccia ogni giocatore in una", "&7squadra specifica fino alla", "&7tua morte!.", "", "&eClicca per aprire!");
                    this.saveItem(yml, "menus.main-menu.communications", "&aComunicazioni veloci", "&7Invia una chat evidenziata", "&7messaggi ai tuoi compagni di squadra!", "", "&eClicca per aprire!");
                    yml.addDefault(TRACKER_MENU_TITLE, (Object)"&8Compra il player Tracker");
                    this.saveItem(yml, "menus.tracker-menu.team-item", "&cRintraccia la squadra {team}", "&7Compra l'aggiornamento Tracker", "&7che ci penser\u00e0 la tua bussola a farlo", "&7Rintraccia ogni giocatore in una", "&7squadra specifica fino alla", "&7tua morte!.", "", "&7Costo: &22 Smeraldi", "", "{status}");
                    this.saveItem(yml, "menus.tracker-menu.back-item", "&aTorna indietro", "&7To Tracker & Comunicazioni");
                    yml.addDefault(COMMUNICATIONS_MENU_TITLE, (Object)"&8Comunicazioni veloci");
                    this.saveItem(yml, "menus.communications.back-item", "&aTorna indietro", "&7To Tracker & Comunicazioni");
                    if (yml.getString("addons.compass.menus.communications.items") == null) {
                        this.saveCommunicationItem(yml, "1", "&aCiao ( \uff9f\u25e1\uff9f)/!", "&aCiao ( \uff9f\u25e1\uff9f)/!", "", "&eClicca per inviare!");
                        this.saveCommunicationItem(yml, "2", "&aSto tornando alla base!", "&aSto tornando alla base!", "", "&eClicca per inviare!");
                        this.saveCommunicationItem(yml, "3", "&aSto difendendo", "&aSto difendendo!", "", "&eClicca per inviare!");
                        this.saveCommunicationItem(yml, "4", "&aSto attaccando la squadra {team}", "&aSto attaccando!", "&7potrai selezionare", "&7la squadra", "", "&eClicca per inviare!");
                        this.saveCommunicationItem(yml, "5", "&aSto raccogliendo {resource}", "&aSto raccogliendo risorse!", "&7potrai selezionare", "&7la risorsa", "", "&eClicca per inviare!");
                        this.saveCommunicationItem(yml, "6", "&aHo {resource}", "&aHo risorse!", "&7potrai selezionare", "&7la risorsa", "", "&eClicca per inviare!");
                        this.saveCommunicationItem(yml, "7", "&aGrazie", "&aGrazie!", "", "&eClicca per inviare!");
                        this.saveCommunicationItem(yml, "8", "&aTorniamo in base", "&aTorniamo in base!", "", "&eClicca per inviare!");
                        this.saveCommunicationItem(yml, "9", "&aDifendete per favore", "&aPer favore difendete!", "", "&eClicca per inviare!");
                        this.saveCommunicationItem(yml, "10", "&aAttacchiamo la squadra {team}", "&aAttacchiamo!", "&7potrai selezionare", "&7la squadra", "", "&eClicca per inviare!");
                        this.saveCommunicationItem(yml, "11", "&aCi serve {resource}", "&aCi servono risorse!", "&7potrai selezionare", "&7la risorsa", "", "&eClicca per inviare!");
                        this.saveCommunicationItem(yml, "12", "&aSta arrivando un giocatore!", "&aSta arrivando un giocatore!", "", "&eClicca per inviare!");
                    }
                    yml.addDefault(COMMUNICATIONS_MENU_LORE, (Object)new String[]{"&7Clicca per inviare un messaggio: '{message}&7'", "&7ai tuoi compagni di squadra!", "", "&eClicca per inviare!"});
                    yml.addDefault(COMMUNICATIONS_MENU_TEAMS_TITLE, (Object)"&8Scegli un'opzione:");
                    this.saveItem(yml, "communication-menus.teams.back-item", "&aIndietro!", "&7Comunicazioni rapide");
                    yml.addDefault(COMMUNICATIONS_MENU_RESOURCES_TITLE, (Object)"&8Scegli un'opzione:");
                    this.saveItem(yml, "communication-menus.resources.back-item", "&aTorna indietro!", "&7Comunicazioni rapide");
                    this.saveResource(yml, "communication-menus.resources.iron", "&f&lFERRO");
                    this.saveResource(yml, "communication-menus.resources.gold", "&6&lORO");
                    this.saveResource(yml, "communication-menus.resources.diamond", "&b&lDIAMANTE");
                    this.saveResource(yml, "communication-menus.resources.emerald", "&2&lSMERALDO");
                    break;
                }
                default: {
                    yml.addDefault(NOT_ALL_BEDS_DESTROYED, (Object)"&cNot all enemy beds are destroyed yet!");
                    yml.addDefault(PURCHASED, (Object)"&cYou will lose the ability to track this team when you die!");
                    yml.addDefault(NOT_ENOUGH_RESOURCE, (Object)"&cYou don't have enough resources!");
                    yml.addDefault(ALREADY_TRACKING, (Object)"&cYou are already tracking this team!");
                    yml.addDefault(STATUS_NOT_ENOUGH, (Object)"&cYou don't have enough resource!");
                    yml.addDefault(STATUS_LOCKED, (Object)"&cUnlocks when all enemy beds are destroyed!");
                    yml.addDefault(STATUS_UNLOCKED, (Object)"&eClick to purchase!");
                    yml.addDefault(ACTION_BAR_TRACKING, (Object)"&fTracking: {teamColor}&l{target} &f- Distance: &a&l{distance}m");
                    yml.addDefault(TEAM_MESSAGE_FORMAT, (Object)"&a&lTEAM > &7{player}: {message}");
                    this.saveItem(yml, "compass-item", "&aCompass &7(Right Click)", new String[0]);
                    this.saveItem(yml, "tracker-shop", "&aTracker Shop", "&7Purchase tracking update for", "&7your compass which will track", "&7each player on a specific team", "&7until you die.");
                    yml.addDefault(MAIN_MENU_TITLE, (Object)"&8Tracker & Communications");
                    this.saveItem(yml, "menus.main-menu.tracker", "&aTracker Shop", "&7Purchase tracking upgrade", "&7for your compass which will", "&7track each player on a", "&7specific team until you", "&7die.", "", "&eClick to open!");
                    this.saveItem(yml, "menus.main-menu.tracker-team", "&aTracker Shop", "&7Purchase tracking upgrade", "&7for your compass which will", "&7track each player on a", "&7specific team until you", "&7die.", "", "&eClick to open!");
                    this.saveItem(yml, "menus.main-menu.communications", "&aQuick Communications", "&7Send highlighted chat", "&7messages to your teammates!", "", "&eClick to open!");
                    yml.addDefault(TRACKER_MENU_TITLE, (Object)"&8Purchase Enemy Tracker");
                    this.saveItem(yml, "menus.tracker-menu.team-item", "&cTrack Team {team}", "&7Purchase tracking upgrade", "&7for your compass which will", "&7track each player on a", "&7specific team until you", "&7die.", "", "&7Cost: &22 Emeralds", "", "{status}");
                    this.saveItem(yml, "menus.tracker-menu.back-item", "&aGo Back", "&7To Tracker & Communication");
                    yml.addDefault(COMMUNICATIONS_MENU_TITLE, (Object)"&8Quick Communications");
                    this.saveItem(yml, "menus.communications.back-item", "&aGo Back", "&7To Tracker & Communication");
                    if (yml.getString("addons.compass.menus.communications.items") == null) {
                        this.saveCommunicationItem(yml, "1", "&aHello ( \uff9f\u25e1\uff9f)/!", "&aHello ( \uff9f\u25e1\uff9f)/!", "", "&eClick to send!");
                        this.saveCommunicationItem(yml, "2", "&aI'm coming back to base!", "&aI'm coming back to base!", "", "&eClick to send!");
                        this.saveCommunicationItem(yml, "3", "&aI'm defending!", "&aI'm defending!", "", "&eClick to send!");
                        this.saveCommunicationItem(yml, "4", "&aI''m attacking {team}", "&aI'm attacking!", "&7You will be able to select", "&7the Team", "", "&eClick to send!");
                        this.saveCommunicationItem(yml, "5", "&aI'm collecting {resource}", "&aI'm collecting resources!", "&7You will be able to select", "&7the Resource", "", "&eClick to send!");
                        this.saveCommunicationItem(yml, "6", "&aI have {resource}", "&aI have resources!", "&7You will be able to select", "&7the Resource", "", "&eClick to send!");
                        this.saveCommunicationItem(yml, "7", "&aThank You", "&aThank You!", "", "&eClick to send!");
                        this.saveCommunicationItem(yml, "8", "&aGet back to base", "&aGet back to base!", "", "&eClick to send!");
                        this.saveCommunicationItem(yml, "9", "&aPlease defend!", "&aPlease defend!", "", "&eClick to send!");
                        this.saveCommunicationItem(yml, "10", "&aLet's attack {team}", "&aLet's attack!", "&7You will be able to select", "&7the Team", "", "&eClick to send!");
                        this.saveCommunicationItem(yml, "11", "&aWe need {resource}", "&aWe need resources!", "&7You will be able to select", "&7the Resource", "", "&eClick to send!");
                        this.saveCommunicationItem(yml, "12", "&aPlayer incoming!", "&aPlayer incoming!!", "", "&eClick to send!");
                    }
                    yml.addDefault(COMMUNICATIONS_MENU_LORE, (Object)new String[]{"&7Click to send message: '{message}&7'", "&7to your teammates!", "", "&eClick to send!"});
                    yml.addDefault(COMMUNICATIONS_MENU_TEAMS_TITLE, (Object)"&8Select an option:");
                    this.saveItem(yml, "communication-menus.teams.back-item", "&aGo Back", "&7To Quick Communications");
                    yml.addDefault(COMMUNICATIONS_MENU_RESOURCES_TITLE, (Object)"&8Select an option:");
                    this.saveItem(yml, "communication-menus.resources.back-item", "&aGo Back", "&7To Quick Communications");
                    this.saveResource(yml, "communication-menus.resources.iron", "&f&lIRON");
                    this.saveResource(yml, "communication-menus.resources.gold", "&6&lGOLD");
                    this.saveResource(yml, "communication-menus.resources.diamond", "&b&lDIAMOND");
                    this.saveResource(yml, "communication-menus.resources.emerald", "&2&lEMERALD");
                }
            }
            l.getYml().options().copyDefaults(true);
            l.save();
        }
    }

    public static Language getLang(Player player) {
        return Language.getPlayerLanguage((Player)player);
    }

    public static YamlConfiguration getYml(Player player) {
        return MessagesData.getLang(player).getYml();
    }

    private void saveResource(YamlConfiguration yml, String path, String resourceName) {
        path = PATH + path;
        yml.addDefault(path + ".resource-name", (Object)resourceName);
    }

    private void saveItem(YamlConfiguration yml, String path, String displayName, String ... lore) {
        path = PATH + path;
        yml.addDefault(path + ".display-name", (Object)displayName);
        yml.addDefault(path + ".lore", (Object)lore);
    }

    private void saveCommunicationItem(YamlConfiguration yml, String path, String message, String displayName, String ... lore) {
        path = "addons.compass.menus.communications.items." + path;
        yml.addDefault(path + ".message", (Object)message);
        yml.addDefault(path + ".display-name", (Object)displayName);
        yml.addDefault(path + ".lore", (Object)lore);
    }
}

