/*
 * Decompiled with CFR 0.152.
 */
package club.mher.compass.listener;

import club.mher.compass.Compass;
import club.mher.compass.menu.Menu;
import club.mher.compass.util.NBTItem;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class MenuListener
implements Listener {
    @EventHandler
    public void onMenuClick(InventoryClickEvent e) {
        InventoryHolder holder = e.getInventory().getHolder();
        if (holder instanceof Menu) {
            e.setCancelled(true);
            if (e.getCurrentItem() == null || e.getCurrentItem().getType().equals((Object)Material.AIR)) {
                return;
            }
            Menu menu = (Menu)holder;
            menu.handleMenu(e);
        }
    }

    @EventHandler
    public void onCompass(InventoryClickEvent e) {
        if (e.getCurrentItem() == null || e.getCurrentItem().getType().equals((Object)Material.AIR)) {
            return;
        }
        NBTItem nbtItem = new NBTItem(e.getCurrentItem());
        if (nbtItem.getString("data") == null) {
            return;
        }
        if (!nbtItem.getString("data").equals("compass-item")) {
            return;
        }
        if (e.getClick() == ClickType.SHIFT_LEFT || e.getClick() == ClickType.SHIFT_RIGHT) {
            e.setCancelled(true);
            return;
        }
        if (e.getView().getTopInventory().getType() == InventoryType.CRAFTING && e.getView().getBottomInventory().getType() == InventoryType.PLAYER) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        ItemStack item = Compass.getBedWars().getVersionSupport().getItemInHand(player);
        if (item == null) {
            return;
        }
        if (item.getType() == Material.AIR) {
            return;
        }
        String data = new NBTItem(item).getString("data");
        if (data == null) {
            return;
        }
        if (!data.equals("compass-item")) {
            return;
        }
        Bukkit.dispatchCommand((CommandSender)player, (String)"bw compass menu");
    }

    @EventHandler
    public void onDrag(InventoryDragEvent e) {
        if (e.getCursor() == null) {
            return;
        }
        if (e.getCursor().getType() == Material.AIR) {
            return;
        }
        String data = new NBTItem(e.getCursor()).getString("data");
        if (data == null) {
            return;
        }
        if (data.equals("compass-item")) {
            e.setCancelled(true);
        }
    }
}

