/*
 * Decompiled with CFR 0.152.
 */
package club.mher.compass.menu.menus;

import club.mher.compass.Compass;
import club.mher.compass.data.MessagesData;
import club.mher.compass.menu.Menu;
import club.mher.compass.menu.menus.CommunicationsMenu;
import club.mher.compass.menu.menus.TrackerMenu;
import club.mher.compass.util.NBTItem;
import com.andrei1058.bedwars.api.arena.GameState;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class MainMenu
extends Menu {
    YamlConfiguration yml;

    public MainMenu(Player player) {
        super(player);
        this.yml = MessagesData.getYml(player);
    }

    @Override
    public String getMenuName() {
        return this.yml.getString("addons.compass.menus.main-menu.title");
    }

    @Override
    public int getSlots() {
        return Compass.getMainConfig().getInt("menus.main-menu.size");
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        NBTItem nbtItem = new NBTItem(e.getCurrentItem());
        if (!Compass.getBedWars().getArenaUtil().isPlaying(player)) {
            return;
        }
        IArena arena = Compass.getBedWars().getArenaUtil().getArenaByPlayer(player);
        if (!arena.getStatus().equals((Object)GameState.playing) || arena.isSpectator(player)) {
            return;
        }
        switch (nbtItem.getString("data")) {
            case "tracker-menu": {
                new TrackerMenu(player, arena).open();
                break;
            }
            case "communications-menu": {
                new CommunicationsMenu(player, arena).open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        IArena arena = Compass.getBedWars().getArenaUtil().getArenaByPlayer(this.player);
        ITeam team = arena.getTeam(this.player);
        if (team.getMembers().size() > 1 && Compass.getMainConfig().getBoolean("use-quick-communications")) {
            NBTItem nbtTracker = new NBTItem(Compass.getMainConfig().getItem(this.player, "menus.main-menu.tracker-team", true, "tracker-menu"));
            NBTItem nbtComm = new NBTItem(Compass.getMainConfig().getItem(this.player, "menus.main-menu.communications", true, "communications-menu"));
            this.inventory.setItem(nbtTracker.getInteger("slot").intValue(), nbtTracker.getItem());
            this.inventory.setItem(nbtComm.getInteger("slot").intValue(), nbtComm.getItem());
        } else {
            NBTItem nbtItem = new NBTItem(Compass.getMainConfig().getItem(this.player, "menus.main-menu.tracker", true, "tracker-menu"));
            this.inventory.setItem(nbtItem.getInteger("slot").intValue(), nbtItem.getItem());
        }
    }
}

