/*
 * Decompiled with CFR 0.152.
 */
package club.mher.compass.menu.menus.communicationMenus;

import club.mher.compass.Compass;
import club.mher.compass.data.MessagesData;
import club.mher.compass.menu.Menu;
import club.mher.compass.menu.menus.CommunicationsMenu;
import club.mher.compass.util.MessagingUtil;
import club.mher.compass.util.NBTItem;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import java.util.HashMap;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class ResourceSelector
extends Menu {
    final YamlConfiguration yml;
    final String path;
    final ITeam team;
    final String[] resources = new String[]{"iron", "gold", "diamond", "emerald"};
    final HashMap<Integer, String> resourceMap = new HashMap();

    public ResourceSelector(Player player, ITeam team, String path) {
        super(player);
        this.team = team;
        this.path = path;
        this.yml = MessagesData.getYml(player);
    }

    @Override
    public String getMenuName() {
        return this.yml.getString("addons.compass.communication-menus.resources.title");
    }

    @Override
    public int getSlots() {
        return Compass.getMainConfig().getInt("communication-menus.resources.size");
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        NBTItem nbtItem = new NBTItem(e.getCurrentItem());
        Player player = (Player)e.getWhoClicked();
        if (!Compass.getBedWars().getArenaUtil().isPlaying(player)) {
            return;
        }
        IArena arena = Compass.getBedWars().getArenaUtil().getArenaByPlayer(player);
        if (arena.isSpectator(player)) {
            return;
        }
        switch (nbtItem.getString("data")) {
            case "back-item": {
                new CommunicationsMenu(player, this.team.getArena()).open();
                break;
            }
            case "resource-item": {
                MessagingUtil.resourceMessage(player, this.team, nbtItem.getString("path"), this.resourceMap.get(e.getSlot()));
            }
        }
    }

    @Override
    public void setMenuItems() {
        for (String s : this.resources) {
            NBTItem nbtItem = new NBTItem(Compass.getMainConfig().getResourceItem(this.player, s, this.path));
            this.inventory.setItem(nbtItem.getInteger("slot").intValue(), nbtItem.getItem());
            this.resourceMap.put(nbtItem.getInteger("slot"), s);
        }
        NBTItem nbtItem = new NBTItem(Compass.getMainConfig().getItem(this.player, "communication-menus.resources.back-item", true, "back-item"));
        this.inventory.setItem(nbtItem.getInteger("slot").intValue(), nbtItem.getItem());
    }
}

