/*
 * Decompiled with CFR 0.152.
 */
package club.mher.compass.tasks;

import club.mher.compass.Compass;
import club.mher.compass.data.MessagesData;
import club.mher.compass.util.TextUtil;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class ActionBarTask
extends BukkitRunnable {
    private final IArena arena;

    public ActionBarTask(IArena arena) {
        this.arena = arena;
    }

    public void run() {
        if (this.arena.getPlayers().size() <= 1 || !Compass.getTrackingArenaMap().containsKey(this.arena) || Compass.getTrackingTeamMap(this.arena) == null) {
            this.cancel();
            return;
        }
        for (Map.Entry<UUID, ITeam> teamMap : Compass.getTrackingTeamMap(this.arena).entrySet()) {
            Player player;
            if (teamMap.getValue() == null || (player = Bukkit.getPlayer((UUID)teamMap.getKey())) == null || this.getPlayer(player, teamMap.getValue()) == null) continue;
            player.setCompassTarget(this.getPlayer(player, teamMap.getValue()).getLocation());
            Compass.getBedWars().getVersionSupport().playAction(player, TextUtil.colorize(MessagesData.getYml(player).getString("addons.compass.action-bar.tracking-format").replace("{target}", this.getPlayer(player, teamMap.getValue()).getDisplayName()).replace("{distance}", String.valueOf(this.getMeters(player, teamMap.getValue())))).replace("{teamColor}", "\u00a7" + teamMap.getValue().getColor().chat().getChar()));
        }
    }

    public int getMeters(Player player, ITeam team) {
        List<Map.Entry<Player, Integer>> sorted = this.getSorted(player, team);
        return sorted.isEmpty() ? 0 : sorted.get(0).getValue();
    }

    public Player getPlayer(Player player, ITeam team) {
        List<Map.Entry<Player, Integer>> sorted = this.getSorted(player, team);
        return sorted.isEmpty() ? null : sorted.get(0).getKey();
    }

    public List<Map.Entry<Player, Integer>> getSorted(Player player, ITeam team) {
        HashMap<Player, Integer> playerDistanceMap = new HashMap<Player, Integer>();
        for (Player p : team.getMembers()) {
            if (!player.getWorld().equals(p.getWorld())) continue;
            playerDistanceMap.put(p, (int)player.getLocation().distance(p.getLocation()));
        }
        ArrayList<Map.Entry<Player, Integer>> list = new ArrayList<Map.Entry<Player, Integer>>(playerDistanceMap.entrySet());
        list.sort(Map.Entry.comparingByValue());
        return list;
    }
}

