/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.api.events.player;

import com.andrei1058.bedwars.api.arena.IArena;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class PlayerKillEvent
extends Event {
    private static final HandlerList HANDLERS = new HandlerList();
    private final IArena arena;
    private final Player victim;
    private final Player killer;
    private final PlayerKillCause cause;
    private Function<Player, String> message;
    private boolean playSound = true;

    public PlayerKillEvent(IArena arena, Player victim, Player killer, Function<Player, String> message, PlayerKillCause cause) {
        this.arena = arena;
        this.victim = victim;
        this.killer = killer;
        this.message = message;
        this.cause = cause;
    }

    public Player getKiller() {
        return this.killer;
    }

    public Function<Player, String> getMessage() {
        return this.message;
    }

    public void setMessage(Function<Player, String> message) {
        this.message = message;
    }

    public PlayerKillCause getCause() {
        return this.cause;
    }

    public IArena getArena() {
        return this.arena;
    }

    public Player getVictim() {
        return this.victim;
    }

    public boolean playSound() {
        return this.playSound;
    }

    public void setPlaySound(boolean playSound) {
        this.playSound = playSound;
    }

    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public static enum PlayerKillCause {
        UNKNOWN(false, false, false),
        UNKNOWN_FINAL_KILL(true, false, false),
        EXPLOSION(false, false, false),
        EXPLOSION_FINAL_KILL(true, false, false),
        VOID(false, false, false),
        VOID_FINAL_KILL(true, false, false),
        PVP(false, false, false),
        PVP_FINAL_KILL(true, false, false),
        PLAYER_SHOOT(false, false, false),
        PLAYER_SHOOT_FINAL_KILL(true, false, false),
        SILVERFISH(false, true, false),
        SILVERFISH_FINAL_KILL(true, true, false),
        IRON_GOLEM(false, true, false),
        IRON_GOLEM_FINAL_KILL(true, true, false),
        PLAYER_PUSH(false, false, false),
        PLAYER_PUSH_FINAL(true, false, false),
        PLAYER_DISCONNECT(false, false, true),
        PLAYER_DISCONNECT_FINAL(true, false, true);

        private final boolean finalKill;
        private final boolean despawnable;
        private final boolean pvpLogOut;

        private PlayerKillCause(boolean finalKill, boolean despawnable, boolean pvpLogOut) {
            this.finalKill = finalKill;
            this.despawnable = despawnable;
            this.pvpLogOut = pvpLogOut;
        }

        public boolean isFinalKill() {
            return this.finalKill;
        }

        public boolean isDespawnable() {
            return this.despawnable;
        }

        public boolean isPvpLogOut() {
            return this.pvpLogOut;
        }
    }
}

