/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.arena.mapreset.slime;

import com.andrei1058.bedwars.api.BedWars;
import com.andrei1058.bedwars.api.arena.GameState;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.server.ISetupSession;
import com.andrei1058.bedwars.api.server.RestoreAdapter;
import com.andrei1058.bedwars.api.server.ServerType;
import com.andrei1058.bedwars.api.util.FileUtil;
import com.andrei1058.bedwars.api.util.ZipFileUtil;
import com.flowpowered.nbt.CompoundMap;
import com.flowpowered.nbt.CompoundTag;
import com.flowpowered.nbt.IntTag;
import com.flowpowered.nbt.Tag;
import com.flowpowered.nbt.stream.NBTInputStream;
import com.flowpowered.nbt.stream.NBTOutputStream;
import com.grinderwolf.swm.api.SlimePlugin;
import com.grinderwolf.swm.api.exceptions.CorruptedWorldException;
import com.grinderwolf.swm.api.exceptions.InvalidWorldException;
import com.grinderwolf.swm.api.exceptions.NewerFormatException;
import com.grinderwolf.swm.api.exceptions.UnknownWorldException;
import com.grinderwolf.swm.api.exceptions.WorldAlreadyExistsException;
import com.grinderwolf.swm.api.exceptions.WorldInUseException;
import com.grinderwolf.swm.api.exceptions.WorldLoadedException;
import com.grinderwolf.swm.api.exceptions.WorldTooBigException;
import com.grinderwolf.swm.api.loaders.SlimeLoader;
import com.grinderwolf.swm.api.world.SlimeWorld;
import com.grinderwolf.swm.api.world.properties.SlimeProperties;
import com.grinderwolf.swm.api.world.properties.SlimePropertyMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SlimeAdapter
extends RestoreAdapter {
    private final SlimePlugin slime = (SlimePlugin)Bukkit.getPluginManager().getPlugin("SlimeWorldManager");
    private final BedWars api = (BedWars)Bukkit.getServer().getServicesManager().getRegistration(BedWars.class).getProvider();

    public SlimeAdapter(Plugin plugin) {
        super(plugin);
    }

    @Override
    public void onEnable(IArena a) {
        if (this.api.getVersionSupport().getMainLevel().equalsIgnoreCase(a.getWorldName()) && (this.api.getServerType() != ServerType.BUNGEE || this.api.getArenaUtil().getGamesBeforeRestart() != 1)) {
            FileUtil.setMainLevel("ignore_main_level", this.api.getVersionSupport());
            this.getOwner().getLogger().log(Level.SEVERE, "Cannot use level-name as arenas. Automatically creating a new void map for level-name.");
            this.getOwner().getLogger().log(Level.SEVERE, "The server is restarting...");
            Bukkit.getServer().spigot().restart();
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously(this.getOwner(), () -> {
            if (Bukkit.getWorld((String)a.getWorldName()) != null) {
                Bukkit.getScheduler().runTask(this.getOwner(), () -> {
                    World w = Bukkit.getWorld((String)a.getWorldName());
                    a.init(w);
                });
                return;
            }
            SlimeLoader flat = this.slime.getLoader("file");
            String[] spawn = a.getConfig().getString("waiting.Loc").split(",");
            SlimePropertyMap spm = new SlimePropertyMap();
            spm.setString(SlimeProperties.WORLD_TYPE, "flat");
            spm.setInt(SlimeProperties.SPAWN_X, (int)Double.parseDouble(spawn[0]));
            spm.setInt(SlimeProperties.SPAWN_Y, (int)Double.parseDouble(spawn[1]));
            spm.setInt(SlimeProperties.SPAWN_Z, (int)Double.parseDouble(spawn[2]));
            spm.setBoolean(SlimeProperties.ALLOW_ANIMALS, false);
            spm.setBoolean(SlimeProperties.ALLOW_MONSTERS, false);
            spm.setString(SlimeProperties.DIFFICULTY, "easy");
            spm.setBoolean(SlimeProperties.PVP, true);
            try {
                SlimeWorld world = this.slime.loadWorld(flat, a.getArenaName(), true, spm);
                if (this.api.getServerType() == ServerType.BUNGEE && this.api.isAutoScale()) {
                    world = world.clone(a.getWorldName());
                }
                SlimeWorld finalWorld = world;
                Bukkit.getScheduler().runTask(this.getOwner(), () -> this.slime.generateWorld(finalWorld));
            }
            catch (CorruptedWorldException | NewerFormatException | UnknownWorldException | WorldInUseException | IOException ex) {
                this.api.getArenaUtil().removeFromEnableQueue(a);
                ex.printStackTrace();
            }
            catch (ConcurrentModificationException thisShouldNotHappenSWM) {
                thisShouldNotHappenSWM.printStackTrace();
                this.api.getArenaUtil().removeFromEnableQueue(a);
                this.getOwner().getLogger().severe("This is a SlimeWorldManager issue!");
                this.getOwner().getLogger().severe("I've submitted a bug report: https://github.com/Grinderwolf/Slime-World-Manager/issues/174");
                this.getOwner().getLogger().severe("Trying again to load arena: " + a.getArenaName());
                this.onEnable(a);
            }
        });
    }

    @Override
    public void onRestart(IArena a) {
        if (this.api.getServerType() == ServerType.BUNGEE) {
            if (this.api.getArenaUtil().getGamesBeforeRestart() == 0) {
                if (this.api.getArenaUtil().getArenas().size() == 1 && this.api.getArenaUtil().getArenas().get(0).getStatus() == GameState.restarting) {
                    this.getOwner().getLogger().info("Dispatching command: " + this.api.getConfigs().getMainConfig().getString("bungee-settings.restart-cmd"));
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.api.getConfigs().getMainConfig().getString("bungee-settings.restart-cmd"));
                }
            } else {
                if (this.api.getArenaUtil().getGamesBeforeRestart() != -1) {
                    this.api.getArenaUtil().setGamesBeforeRestart(this.api.getArenaUtil().getGamesBeforeRestart() - 1);
                }
                Bukkit.getScheduler().runTask(this.getOwner(), () -> {
                    Bukkit.unloadWorld((String)a.getWorldName(), (boolean)false);
                    if (this.api.getArenaUtil().canAutoScale(a.getArenaName())) {
                        Bukkit.getScheduler().runTaskLater(this.getOwner(), () -> this.api.getArenaUtil().loadArena(a.getArenaName(), null), 80L);
                    }
                });
            }
        } else {
            Bukkit.getScheduler().runTask(this.getOwner(), () -> {
                Bukkit.unloadWorld((String)a.getWorldName(), (boolean)false);
                Bukkit.getScheduler().runTaskLater(this.getOwner(), () -> this.api.getArenaUtil().loadArena(a.getArenaName(), null), 80L);
            });
        }
    }

    @Override
    public void onDisable(IArena a) {
        if (this.api.isShuttingDown()) {
            Bukkit.unloadWorld((String)a.getWorldName(), (boolean)false);
            return;
        }
        Bukkit.getScheduler().runTask(this.getOwner(), () -> Bukkit.unloadWorld((String)a.getWorldName(), (boolean)false));
    }

    @Override
    public void onSetupSessionStart(ISetupSession s) {
        Bukkit.getScheduler().runTaskAsynchronously(this.getOwner(), () -> {
            SlimeLoader sLoader = this.slime.getLoader("file");
            String[] spawn = new String[]{"0", "50", "0"};
            if (s.getConfig().getYml().getString("waiting.Loc") != null) {
                spawn = s.getConfig().getString("waiting.Loc").split(",");
            }
            SlimePropertyMap spm = new SlimePropertyMap();
            spm.setString(SlimeProperties.WORLD_TYPE, "flat");
            spm.setInt(SlimeProperties.SPAWN_X, (int)Double.parseDouble(spawn[0]));
            spm.setInt(SlimeProperties.SPAWN_Y, (int)Double.parseDouble(spawn[1]));
            spm.setInt(SlimeProperties.SPAWN_Z, (int)Double.parseDouble(spawn[2]));
            spm.setBoolean(SlimeProperties.ALLOW_ANIMALS, false);
            spm.setBoolean(SlimeProperties.ALLOW_MONSTERS, false);
            spm.setString(SlimeProperties.DIFFICULTY, "easy");
            spm.setBoolean(SlimeProperties.PVP, true);
            try {
                SlimeWorld world;
                if (Bukkit.getWorld((String)s.getWorldName()) != null) {
                    Bukkit.getScheduler().runTask(this.getOwner(), () -> Bukkit.unloadWorld((String)s.getWorldName(), (boolean)false));
                }
                if (sLoader.worldExists(s.getWorldName())) {
                    world = this.slime.loadWorld(sLoader, s.getWorldName(), false, spm);
                    Bukkit.getScheduler().runTask(this.getOwner(), () -> s.getPlayer().sendMessage(ChatColor.GREEN + "Loading world from SlimeWorldManager container."));
                } else if (new File(Bukkit.getWorldContainer(), s.getWorldName() + "/level.dat").exists()) {
                    Bukkit.getScheduler().runTask(this.getOwner(), () -> s.getPlayer().sendMessage(ChatColor.GREEN + "Importing world to the SlimeWorldManager container."));
                    this.slime.importWorld(new File(Bukkit.getWorldContainer(), s.getWorldName()), s.getWorldName().toLowerCase(), sLoader);
                    world = this.slime.loadWorld(sLoader, s.getWorldName(), false, spm);
                } else {
                    Bukkit.getScheduler().runTask(this.getOwner(), () -> s.getPlayer().sendMessage(ChatColor.GREEN + "Creating anew void map."));
                    world = this.slime.createEmptyWorld(sLoader, s.getWorldName(), false, spm);
                }
                SlimeWorld sw = world;
                Bukkit.getScheduler().runTask(this.getOwner(), () -> {
                    this.slime.generateWorld(sw);
                    s.teleportPlayer();
                });
            }
            catch (CorruptedWorldException | InvalidWorldException | NewerFormatException | UnknownWorldException | WorldAlreadyExistsException | WorldInUseException | WorldLoadedException | WorldTooBigException | IOException ex) {
                s.getPlayer().sendMessage(ChatColor.RED + "An error occurred! Please check console.");
                ex.printStackTrace();
                s.close();
            }
        });
    }

    @Override
    public void onSetupSessionClose(ISetupSession s) {
        Bukkit.getWorld((String)s.getWorldName()).save();
        Bukkit.getScheduler().runTask(this.getOwner(), () -> Bukkit.unloadWorld((String)s.getWorldName(), (boolean)true));
    }

    @Override
    public void onLobbyRemoval(IArena a) {
        Location loc1 = a.getConfig().getArenaLoc("waiting.Pos1");
        Location loc2 = a.getConfig().getArenaLoc("waiting.Pos2");
        if (loc1 == null || loc2 == null) {
            return;
        }
        Bukkit.getScheduler().runTask(this.getOwner(), () -> {
            int minX = Math.min(loc1.getBlockX(), loc2.getBlockX());
            int maxX = Math.max(loc1.getBlockX(), loc2.getBlockX());
            int minY = Math.min(loc1.getBlockY(), loc2.getBlockY());
            int maxY = Math.max(loc1.getBlockY(), loc2.getBlockY());
            int minZ = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
            int maxZ = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        loc1.getWorld().getBlockAt(x, y, z).setType(Material.AIR);
                    }
                }
            }
            Bukkit.getScheduler().runTaskLater(this.getOwner(), () -> loc1.getWorld().getEntities().forEach(e -> {
                if (e instanceof Item) {
                    e.remove();
                }
            }), 15L);
        });
    }

    @Override
    public boolean isWorld(String name) {
        try {
            return this.slime.getLoader("file").worldExists(name);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void deleteWorld(String name) {
        Bukkit.getScheduler().runTaskAsynchronously(this.getOwner(), () -> {
            try {
                this.slime.getLoader("file").deleteWorld(name);
            }
            catch (UnknownWorldException | IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void cloneArena(String name1, String name2) {
        Bukkit.getScheduler().runTaskAsynchronously(this.getOwner(), () -> {
            SlimePropertyMap spm = new SlimePropertyMap();
            spm.setString(SlimeProperties.WORLD_TYPE, "flat");
            spm.setInt(SlimeProperties.SPAWN_X, 0);
            spm.setInt(SlimeProperties.SPAWN_Y, 118);
            spm.setInt(SlimeProperties.SPAWN_Z, 0);
            spm.setBoolean(SlimeProperties.ALLOW_ANIMALS, false);
            spm.setBoolean(SlimeProperties.ALLOW_MONSTERS, false);
            spm.setString(SlimeProperties.DIFFICULTY, "easy");
            spm.setBoolean(SlimeProperties.PVP, true);
            try {
                SlimeWorld world = this.slime.loadWorld(this.slime.getLoader("file"), name1, true, spm);
                world.clone(name2, this.slime.getLoader("file"));
            }
            catch (CorruptedWorldException | NewerFormatException | UnknownWorldException | WorldAlreadyExistsException | WorldInUseException | IOException ex) {
                ex.printStackTrace();
            }
        });
    }

    @Override
    public List<String> getWorldsList() {
        try {
            return this.slime.getLoader("file").listWorlds();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    @Override
    public void convertWorlds() {
        File[] fls;
        File dir = new File(this.getOwner().getDataFolder(), "/Arenas");
        SlimeLoader sl = this.slime.getLoader("file");
        if (dir.exists() && (fls = dir.listFiles()) != null) {
            for (File fl : fls) {
                if (!fl.isFile() || !fl.getName().endsWith(".yml")) continue;
                String name = fl.getName().replace(".yml", "").toLowerCase();
                File ff = new File(Bukkit.getWorldContainer(), fl.getName().replace(".yml", ""));
                try {
                    if (sl.worldExists(name)) continue;
                    if (!fl.getName().equals(name) && !fl.renameTo(new File(dir, name + ".yml"))) {
                        this.getOwner().getLogger().log(Level.WARNING, "Could not rename " + fl.getName() + ".yml to " + name + ".yml");
                    }
                    File bc = new File(this.getOwner().getDataFolder() + "/Cache", ff.getName() + ".zip");
                    if (ff.exists() && bc.exists()) {
                        FileUtil.delete(ff);
                        ZipFileUtil.unzipFileIntoDirectory(bc, new File(Bukkit.getWorldContainer(), name));
                    }
                    this.deleteWorldTrash(name);
                    this.handleLevelDat(name);
                    this.convertWorld(name, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Bukkit.getScheduler().runTaskAsynchronously(this.getOwner(), () -> {
            File[] files = Bukkit.getWorldContainer().listFiles();
            if (files != null) {
                for (File f : files) {
                    if (f == null || !f.isDirectory() || !f.getName().contains("bw_temp_")) continue;
                    try {
                        FileUtils.deleteDirectory(f);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void convertWorld(String name, Player player) {
        SlimeLoader sl = this.slime.getLoader("file");
        try {
            this.getOwner().getLogger().log(Level.INFO, "Converting " + name + " to the Slime format.");
            this.slime.importWorld(new File(Bukkit.getWorldContainer(), name), name, sl);
        }
        catch (InvalidWorldException | WorldAlreadyExistsException | WorldLoadedException | WorldTooBigException | IOException e) {
            if (player != null) {
                player.sendMessage(ChatColor.RED + "Could not convert " + name + " to the Slime format.");
                player.sendMessage(ChatColor.RED + "Check the console for details.");
                ISetupSession s = this.api.getSetupSession(player.getUniqueId());
                if (s != null) {
                    s.close();
                }
            }
            this.getOwner().getLogger().log(Level.WARNING, "Could not convert " + name + " to the Slime format.");
            e.printStackTrace();
        }
    }

    private void deleteWorldTrash(String world) {
        for (File f : new File[]{new File(Bukkit.getWorldContainer(), world + "/level.dat_mcr"), new File(Bukkit.getWorldContainer(), world + "/level.dat_old"), new File(Bukkit.getWorldContainer(), world + "/session.lock"), new File(Bukkit.getWorldContainer(), world + "/uid.dat")}) {
            if (!f.exists() || f.delete()) continue;
            this.getOwner().getLogger().warning("Could not delete: " + f.getPath());
            this.getOwner().getLogger().warning("This may cause issues!");
        }
    }

    private void handleLevelDat(String world) throws IOException {
        File regions;
        File level = new File(Bukkit.getWorldContainer(), world + "/level.dat");
        if (!level.exists() && level.createNewFile() && (regions = new File(Bukkit.getWorldContainer(), "world/region")).exists() && Objects.requireNonNull(regions.list()).length > 0 && Arrays.stream(Objects.requireNonNull(regions.list())).filter(p -> p.endsWith(".mca")).toArray().length > 0) {
            Optional dataTag;
            File region = new File(Bukkit.getWorldContainer(), world + "/" + Arrays.stream(Objects.requireNonNull(regions.list())).filter(p -> p.endsWith(".mca")).toArray()[0]);
            NBTInputStream inputStream = new NBTInputStream((InputStream)new FileInputStream(region));
            Optional tag = inputStream.readTag().getAsCompoundTag();
            inputStream.close();
            if (tag.isPresent() && (dataTag = ((CompoundTag)tag.get()).getAsCompoundTag("Chunk")).isPresent()) {
                int dataVersion = ((CompoundTag)dataTag.get()).getIntValue("DataVersion").orElse(-1);
                NBTOutputStream outputStream = new NBTOutputStream((OutputStream)new FileOutputStream(level));
                CompoundMap cm = new CompoundMap();
                cm.put((Tag)new IntTag("SpawnX", 0));
                cm.put((Tag)new IntTag("SpawnY", 255));
                cm.put((Tag)new IntTag("SpawnZ", 0));
                if (dataVersion != -1) {
                    cm.put((Tag)new IntTag("DataVersion", dataVersion));
                }
                CompoundTag root = new CompoundTag("Data", cm);
                outputStream.writeTag((Tag)root);
                outputStream.flush();
                outputStream.close();
            }
        }
    }
}

