/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.libs.sidebar;

import com.andrei1058.bedwars.libs.sidebar.PlaceholderProvider;
import com.andrei1058.bedwars.libs.sidebar.ScoreLine;
import com.andrei1058.bedwars.libs.sidebar.SidebarLine;
import com.andrei1058.bedwars.libs.sidebar.SidebarLineAnimated;
import com.andrei1058.bedwars.libs.sidebar.SidebarManager;
import com.andrei1058.bedwars.libs.sidebar.SidebarObjective;
import com.andrei1058.bedwars.libs.sidebar.WrappedSidebar;
import java.util.Collection;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EighteenSidebar
extends WrappedSidebar {
    public EighteenSidebar(@NotNull SidebarLine title, @NotNull Collection<SidebarLine> lines, Collection<PlaceholderProvider> placeholderProvider) {
        super(title, lines, placeholderProvider);
    }

    public ScoreLine createScore(SidebarLine line, int score, String color) {
        return new NarniaScoreLine(line, score, color);
    }

    public SidebarObjective createObjective(String name, IScoreboardCriteria iScoreboardCriteria, SidebarLine title, int type) {
        return new NarniaSidebarObjective(name, iScoreboardCriteria, title, type);
    }

    public class NarniaScoreLine
    extends ScoreboardScore
    implements ScoreLine,
    Comparable<ScoreLine> {
        private int score;
        private String prefix;
        private String suffix;
        private final TeamLine team;
        private SidebarLine text;

        public NarniaScoreLine(SidebarLine text, @NotNull int score, String color) {
            super(null, (ScoreboardObjective)EighteenSidebar.this.getSidebarObjective(), color);
            this.prefix = " ";
            this.suffix = "";
            this.score = score;
            this.text = text;
            this.team = new TeamLine(color);
            if (!text.isHasPlaceholders()) {
                for (PlaceholderProvider provider : EighteenSidebar.this.getPlaceholders()) {
                    if (!text.getLine().contains(provider.getPlaceholder())) continue;
                    text.setHasPlaceholders(true);
                }
                if (!text.isHasPlaceholders()) {
                    if (text instanceof SidebarLineAnimated) {
                        for (String line : ((SidebarLineAnimated)text).getLines()) {
                            if (!SidebarManager.getInstance().getPapiSupport().hasPlaceholders(line)) continue;
                            text.setHasPlaceholders(true);
                            break;
                        }
                    } else if (SidebarManager.getInstance().getPapiSupport().hasPlaceholders(text.getLine())) {
                        text.setHasPlaceholders(true);
                    }
                }
            }
            if (text.isHasPlaceholders()) {
                String content = text.getLine();
                for (PlaceholderProvider pp : EighteenSidebar.this.getPlaceholders()) {
                    if (!content.contains(pp.getPlaceholder())) continue;
                    content = content.replace(pp.getPlaceholder(), pp.getReplacement());
                }
                this.setContent(content);
            } else {
                this.setContent(text.getLine());
            }
        }

        @Override
        public SidebarLine getLine() {
            return this.text;
        }

        @Override
        public void setLine(SidebarLine line) {
            this.text = line;
        }

        @Override
        public int getScoreAmount() {
            return this.score;
        }

        @Override
        public void setScoreAmount(int score) {
            this.b(score);
        }

        @Override
        public void sendCreateToAllReceivers() {
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team, (boolean)true);
            EighteenSidebar.this.getReceivers().forEach(p -> ((CraftPlayer)p).getHandle().b.a((Packet)packetPlayOutScoreboardTeam));
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(ScoreboardServer.Action.a, EighteenSidebar.this.getSidebarObjective().getName(), this.getColor(), this.getScoreAmount());
            EighteenSidebar.this.getReceivers().forEach(p -> ((CraftPlayer)p).getHandle().b.a((Packet)packetPlayOutScoreboardScore));
        }

        @Override
        public void sendCreate(Player player) {
            PlayerConnection conn = ((CraftPlayer)player).getHandle().b;
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team, (boolean)true);
            conn.a((Packet)packetPlayOutScoreboardTeam);
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(ScoreboardServer.Action.a, EighteenSidebar.this.getSidebarObjective().getName(), this.getColor(), this.getScoreAmount());
            conn.a((Packet)packetPlayOutScoreboardScore);
        }

        @Override
        public void sendRemove(Player player) {
            PlayerConnection conn = ((CraftPlayer)player).getHandle().b;
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team);
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(ScoreboardServer.Action.b, EighteenSidebar.this.getSidebarObjective().getName(), this.getColor(), this.getScoreAmount());
            conn.a((Packet)packetPlayOutScoreboardTeam);
            conn.a((Packet)packetPlayOutScoreboardScore);
        }

        @Override
        public void sendRemoveToAllReceivers() {
            PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team);
            EighteenSidebar.this.getReceivers().forEach(p -> ((CraftPlayer)p).getHandle().b.a((Packet)packetPlayOutScoreboardTeam));
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(ScoreboardServer.Action.b, EighteenSidebar.this.getSidebarObjective().getName(), this.getColor(), this.getScoreAmount());
            EighteenSidebar.this.getReceivers().forEach(p -> ((CraftPlayer)p).getHandle().b.a((Packet)packetPlayOutScoreboardScore));
        }

        @Override
        public void sendUpdate(Player player) {
            PacketPlayOutScoreboardTeam packetTeamUpdate = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team, (boolean)false);
            ((CraftPlayer)player).getHandle().b.a((Packet)packetTeamUpdate);
        }

        @Override
        @Contract(pure=true)
        public boolean setContent(@NotNull String content) {
            if (!EighteenSidebar.this.getReceivers().isEmpty()) {
                content = SidebarManager.getInstance().getPapiSupport().replacePlaceholders(EighteenSidebar.this.getReceivers().get(0), content);
            }
            String oldPrefix = this.prefix;
            String oldSuffix = this.suffix;
            if (content.length() > 64) {
                this.prefix = content.substring(0, 64);
                if (this.prefix.charAt(63) == '\u00a7') {
                    this.prefix = content.substring(0, 63);
                    this.setSuffix(content.substring(63));
                } else {
                    this.setSuffix(content.substring(64));
                }
            } else {
                this.prefix = content;
                this.suffix = "";
            }
            return !oldPrefix.equals(this.prefix) || !oldSuffix.equals(this.suffix);
        }

        public void setSuffix(@NotNull String secondPart) {
            if (((String)secondPart).isEmpty()) {
                this.suffix = "";
                return;
            }
            secondPart = ChatColor.getLastColors((String)this.prefix) + (String)secondPart;
            this.suffix = ((String)secondPart).length() > 64 ? ((String)secondPart).substring(0, 64) : secondPart;
        }

        @Override
        public void sendUpdateToAllReceivers() {
            PacketPlayOutScoreboardTeam packetTeamUpdate = PacketPlayOutScoreboardTeam.a((ScoreboardTeam)this.team, (boolean)false);
            EighteenSidebar.this.getReceivers().forEach(r -> ((CraftPlayer)r).getHandle().b.a((Packet)packetTeamUpdate));
        }

        @Override
        public int compareTo(@NotNull ScoreLine o) {
            return Integer.compare(this.score, o.getScoreAmount());
        }

        public void b(int score) {
            this.score = score;
            PacketPlayOutScoreboardScore packetPlayOutScoreboardScore = new PacketPlayOutScoreboardScore(ScoreboardServer.Action.a, ((ScoreboardObjective)EighteenSidebar.this.getSidebarObjective()).b(), this.e(), score);
            EighteenSidebar.this.getReceivers().forEach(r -> ((CraftPlayer)r).getHandle().b.a((Packet)packetPlayOutScoreboardScore));
        }

        public int b() {
            return this.score;
        }

        public void c() {
        }

        public void a(int i) {
        }

        public void a() {
        }

        @Override
        public String getColor() {
            return this.team.b().charAt(0) == '\u00a7' ? this.team.b() : "\u00a7" + this.team.b();
        }

        private class TeamLine
        extends ScoreboardTeam {
            public TeamLine(String color) {
                super(null, color);
                this.g().add(color);
            }

            public IChatBaseComponent e() {
                return new ChatComponentText(NarniaScoreLine.this.prefix);
            }

            public void b(@Nullable IChatBaseComponent var0) {
            }

            public void c(@Nullable IChatBaseComponent var0) {
            }

            public IChatBaseComponent f() {
                return new ChatComponentText(NarniaScoreLine.this.suffix);
            }

            public void a(boolean var0) {
            }

            public void b(boolean var0) {
            }

            public void a(ScoreboardTeamBase.EnumNameTagVisibility var0) {
            }

            public void a(ScoreboardTeamBase.EnumTeamPush var0) {
            }

            public void a(EnumChatFormat var0) {
            }

            public IChatMutableComponent d(IChatBaseComponent var0) {
                return new ChatComponentText(NarniaScoreLine.this.prefix + var0 + NarniaScoreLine.this.suffix);
            }
        }
    }

    protected class NarniaSidebarObjective
    extends ScoreboardObjective
    implements SidebarObjective {
        private SidebarLine displayName;
        private final int type;

        public NarniaSidebarObjective(String name, IScoreboardCriteria criteria, SidebarLine displayName, int type) {
            super(null, name, criteria, (IChatBaseComponent)new ChatComponentText(name), IScoreboardCriteria.EnumScoreboardHealthDisplay.a);
            this.displayName = displayName;
            this.type = type;
        }

        @Override
        public void setTitle(SidebarLine title) {
            this.displayName = title;
            this.sendUpdate();
        }

        @Override
        public void sendCreate(Player player) {
            this.sendCreate(((CraftPlayer)player).getHandle().b);
        }

        @Override
        public void sendRemove(Player player) {
            this.sendRemove(((CraftPlayer)player).getHandle().b);
        }

        @Override
        public String getName() {
            return this.b();
        }

        public IChatBaseComponent d() {
            String t = this.displayName.getLine();
            if (t.length() > 32) {
                t = t.substring(0, 32);
            }
            return new ChatComponentText(t);
        }

        public void a(IChatBaseComponent var0) {
        }

        public IChatBaseComponent e() {
            return new ChatComponentText(this.d().a());
        }

        public void a(IScoreboardCriteria.EnumScoreboardHealthDisplay var0) {
        }

        private void sendCreate(@NotNull PlayerConnection playerConnection) {
            PacketPlayOutScoreboardObjective packetPlayOutScoreboardObjective = new PacketPlayOutScoreboardObjective((ScoreboardObjective)this, 0);
            playerConnection.a((Packet)packetPlayOutScoreboardObjective);
            PacketPlayOutScoreboardDisplayObjective packetPlayOutScoreboardDisplayObjective = new PacketPlayOutScoreboardDisplayObjective(this.type, (ScoreboardObjective)this);
            playerConnection.a((Packet)packetPlayOutScoreboardDisplayObjective);
            if (this.b().equalsIgnoreCase("health")) {
                PacketPlayOutScoreboardDisplayObjective packetPlayOutScoreboardDisplayObjective2 = new PacketPlayOutScoreboardDisplayObjective(0, (ScoreboardObjective)this);
                playerConnection.a((Packet)packetPlayOutScoreboardDisplayObjective2);
            }
        }

        @Override
        public void sendUpdate() {
            PacketPlayOutScoreboardObjective packetPlayOutScoreboardObjective = new PacketPlayOutScoreboardObjective((ScoreboardObjective)this, 2);
            EighteenSidebar.this.getReceivers().forEach(player -> ((CraftPlayer)player).getHandle().b.a((Packet)packetPlayOutScoreboardObjective));
        }

        public void sendRemove(@NotNull PlayerConnection playerConnection) {
            PacketPlayOutScoreboardObjective packetPlayOutScoreboardObjective = new PacketPlayOutScoreboardObjective((ScoreboardObjective)this, 1);
            playerConnection.a((Packet)packetPlayOutScoreboardObjective);
        }
    }
}

