/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.libs.sidebar;

import com.andrei1058.bedwars.libs.sidebar.PAPIAdapter;
import com.andrei1058.bedwars.libs.sidebar.PAPISupport;
import com.andrei1058.bedwars.libs.sidebar.PlaceholderProvider;
import com.andrei1058.bedwars.libs.sidebar.Sidebar;
import com.andrei1058.bedwars.libs.sidebar.SidebarLine;
import com.andrei1058.bedwars.libs.sidebar.SidebarProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SidebarManager {
    private static SidebarManager instance;
    private final SidebarProvider sidebarProvider;
    private PAPISupport papiSupport = new PAPISupport(){

        @Override
        public String replacePlaceholders(Player p, String s) {
            return s;
        }

        @Override
        public boolean hasPlaceholders(String s) {
            return false;
        }
    };

    public SidebarManager() throws InstantiationException {
        instance = this;
        try {
            Class.forName("me.clip.placeholderapi.PlaceholderAPI");
            this.papiSupport = new PAPIAdapter();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        String serverVersion = Bukkit.getServer().getClass().getName().split("\\.")[3];
        String className = null;
        if (serverVersion.equalsIgnoreCase("v1_19_R2")) {
            className = "com.andrei1058.bedwars.libs.sidebar.NineteenProvider";
        } else if (serverVersion.equalsIgnoreCase("v1_18_R2")) {
            className = "com.andrei1058.bedwars.libs.sidebar.EighteenProvider";
        } else if (serverVersion.equalsIgnoreCase("v1_17_R1")) {
            className = "com.andrei1058.bedwars.libs.sidebar.SeventeenProvider";
        } else if (serverVersion.equalsIgnoreCase("v1_16_R3")) {
            className = "com.andrei1058.bedwars.libs.sidebar.SixteenProvider";
        } else if (serverVersion.equals("v1_12_R1")) {
            className = "com.andrei1058.bedwars.libs.sidebar.TwelveProvider";
        } else if (serverVersion.equals("v1_8_R3")) {
            className = "com.andrei1058.bedwars.libs.sidebar.EightProvider";
        }
        if (null == className) {
            throw new InstantiationException();
        }
        try {
            Class<?> c = Class.forName(className);
            this.sidebarProvider = (SidebarProvider)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ignored) {
            throw new InstantiationException();
        }
    }

    @Nullable
    public static SidebarManager init() {
        if (null != instance) {
            return instance;
        }
        try {
            instance = new SidebarManager();
        }
        catch (InstantiationException e) {
            return null;
        }
        return instance;
    }

    public Sidebar createSidebar(SidebarLine title, @NotNull Collection<SidebarLine> lines, Collection<PlaceholderProvider> placeholderProviders) {
        lines.forEach(c -> placeholderProviders.forEach(c2 -> {
            if (c.getLine().contains(c2.getPlaceholder())) {
                c.setHasPlaceholders(true);
            }
        }));
        return this.sidebarProvider.createSidebar(title, lines, placeholderProviders);
    }

    public void sendHeaderFooter(Player player, String header, String footer) {
        this.sidebarProvider.sendHeaderFooter(player, header, footer);
    }

    PAPISupport getPapiSupport() {
        return this.papiSupport;
    }

    SidebarProvider getSidebarProvider() {
        return this.sidebarProvider;
    }

    public static SidebarManager getInstance() {
        return instance;
    }
}

