/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.libs.sidebar;

import com.andrei1058.bedwars.libs.sidebar.PlaceholderProvider;
import com.andrei1058.bedwars.libs.sidebar.PlayerTab;
import com.andrei1058.bedwars.libs.sidebar.SidebarLine;
import com.andrei1058.bedwars.libs.sidebar.SidebarManager;
import com.andrei1058.bedwars.libs.sidebar.VersionedTabGroup;
import com.andrei1058.bedwars.libs.sidebar.WrappedSidebar;
import java.util.Collections;
import net.minecraft.server.v1_12_R1.Packet;
import net.minecraft.server.v1_12_R1.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_12_R1.ScoreboardTeam;
import net.minecraft.server.v1_12_R1.ScoreboardTeamBase;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwelvePlayerList
extends ScoreboardTeam
implements VersionedTabGroup {
    private ScoreboardTeamBase.EnumTeamPush pushingRule;
    private final SidebarLine prefix;
    private final SidebarLine suffix;
    private final WrappedSidebar sidebar;
    private final String id;
    private ScoreboardTeamBase.EnumNameTagVisibility nameTagVisibility;
    private Player papiSubject = null;

    public TwelvePlayerList(@NotNull WrappedSidebar sidebar, String identifier, SidebarLine prefix, SidebarLine suffix, PlayerTab.PushingRule pushingRule, PlayerTab.NameTagVisibility nameTagVisibility) {
        super(null, identifier);
        this.suffix = suffix;
        this.prefix = prefix;
        this.sidebar = sidebar;
        this.setPushingRule(pushingRule);
        this.setNameTagVisibility(nameTagVisibility);
        this.id = identifier;
    }

    public void setPrefix(String var0) {
    }

    public ScoreboardTeamBase.EnumTeamPush getCollisionRule() {
        return this.pushingRule;
    }

    public void setCollisionRule(ScoreboardTeamBase.EnumTeamPush enumTeamPush) {
    }

    public String getFormattedName(String var0) {
        return this.prefix.getLine().concat(var0).concat(this.suffix.getLine());
    }

    public String getPrefix() {
        String t = this.prefix.getLine();
        for (PlaceholderProvider placeholderProvider : this.sidebar.getPlaceholders()) {
            if (!t.contains(placeholderProvider.getPlaceholder())) continue;
            t = t.replace(placeholderProvider.getPlaceholder(), placeholderProvider.getReplacement());
        }
        if (null != this.getSubject()) {
            t = SidebarManager.getInstance().getPapiSupport().replacePlaceholders(this.getSubject(), t);
        }
        if (t.length() > 16) {
            t = t.substring(0, 16);
        }
        return t;
    }

    public String getSuffix() {
        String t = this.suffix.getLine();
        for (PlaceholderProvider placeholderProvider : this.sidebar.getPlaceholders()) {
            if (!t.contains(placeholderProvider.getPlaceholder())) continue;
            t = t.replace(placeholderProvider.getPlaceholder(), placeholderProvider.getReplacement());
        }
        if (null != this.getSubject()) {
            t = SidebarManager.getInstance().getPapiSupport().replacePlaceholders(this.getSubject(), t);
        }
        if (t.length() > 16) {
            t = t.substring(0, 16);
        }
        return t;
    }

    public void setNameTagVisibility(ScoreboardTeamBase.EnumNameTagVisibility enumNameTagVisibility) {
        this.nameTagVisibility = enumNameTagVisibility;
    }

    public ScoreboardTeamBase.EnumNameTagVisibility getNameTagVisibility() {
        return this.nameTagVisibility;
    }

    @Override
    public void add(@NotNull Player player) {
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this, Collections.singleton(player.getName()), 3);
        this.sidebar.getReceivers().forEach(r -> ((CraftPlayer)r).getHandle().playerConnection.sendPacket((Packet)packetPlayOutScoreboardTeam));
    }

    @Override
    public void sendCreateToPlayer(Player player) {
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this, 0);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packetPlayOutScoreboardTeam);
    }

    @Override
    public void remove(@NotNull Player player) {
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this, Collections.singleton(player.getName()), 4);
        this.sidebar.getReceivers().forEach(r -> ((CraftPlayer)r).getHandle().playerConnection.sendPacket((Packet)packetPlayOutScoreboardTeam));
    }

    @Override
    public void sendUserCreateToReceivers(@NotNull Player player) {
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this, Collections.singleton(player.getName()), 3);
        this.sidebar.getReceivers().forEach(r -> ((CraftPlayer)r).getHandle().playerConnection.sendPacket((Packet)packetPlayOutScoreboardTeam));
    }

    @Override
    public void sendUpdateToReceivers() {
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this, 2);
        this.sidebar.getReceivers().forEach(r -> ((CraftPlayer)r).getHandle().playerConnection.sendPacket((Packet)packetPlayOutScoreboardTeam));
    }

    @Override
    public void sendRemoveToReceivers() {
        PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam = new PacketPlayOutScoreboardTeam((ScoreboardTeam)this, 1);
        this.sidebar.getReceivers().forEach(r -> ((CraftPlayer)r).getHandle().playerConnection.sendPacket((Packet)packetPlayOutScoreboardTeam));
    }

    @Override
    public String getIdentifier() {
        return this.id;
    }

    @Override
    public void setSubject(@javax.annotation.Nullable Player papiSubject) {
        this.papiSubject = papiSubject;
    }

    @Override
    @Nullable
    public Player getSubject() {
        return this.papiSubject;
    }

    @Override
    public void setPushingRule(@NotNull PlayerTab.PushingRule rule) {
        switch (rule) {
            case NEVER: {
                this.pushingRule = ScoreboardTeamBase.EnumTeamPush.NEVER;
                break;
            }
            case ALWAYS: {
                this.pushingRule = ScoreboardTeamBase.EnumTeamPush.ALWAYS;
                break;
            }
            case PUSH_OTHER_TEAMS: {
                this.pushingRule = ScoreboardTeamBase.EnumTeamPush.HIDE_FOR_OTHER_TEAMS;
                break;
            }
            case PUSH_OWN_TEAM: {
                this.pushingRule = ScoreboardTeamBase.EnumTeamPush.HIDE_FOR_OWN_TEAM;
            }
        }
        if (null != this.id) {
            this.sendUpdateToReceivers();
        }
    }

    @Override
    public void setNameTagVisibility(@NotNull PlayerTab.NameTagVisibility nameTagVisibility) {
        this.nameTagVisibility = ScoreboardTeamBase.EnumNameTagVisibility.valueOf((String)nameTagVisibility.toString());
        if (null != this.id) {
            this.sendUpdateToReceivers();
        }
    }
}

