/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.cmds;

import com.eazyftw.ezcolors.EZColors;
import com.eazyftw.ezcolors.EazyAPI;
import com.eazyftw.ezcolors.cmds.Command;
import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.guis.ChatColorCreatorGUI;
import com.eazyftw.ezcolors.guis.ChatColorGUI;
import com.eazyftw.ezcolors.guis.LanguagesGUI;
import com.eazyftw.ezcolors.language.T;
import com.eazyftw.ezcolors.storage.ChatColorUser;
import com.eazyftw.ezcolors.types.SelectionType;
import com.eazyftw.ezcolors.types.color.ChatColor;
import com.eazyftw.ezcolors.versions.MinecraftVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatColorCmd
extends Command {
    public boolean onCommand(CommandSender sender, org.bukkit.command.Command command, String label, String[] args) {
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                EZMessage.text(T.t("COMMAND_ONLINE_PLAYER")).sender(sender);
                return false;
            }
            Player p = (Player)sender;
            if (EZColors.getSelectionType().equals((Object)SelectionType.COMMAND)) {
                EZMessage.text(T.t("COMMAND_SPECIFY_COLOR")).sender(sender);
                return true;
            }
            if (p.hasPermission("ezcolors.gui")) {
                new ChatColorGUI(p);
            } else {
                EZMessage.text(T.t("COMMAND_NO_PERMS")).sender(sender);
            }
        } else if (args[0].equalsIgnoreCase("languages")) {
            if (!(sender instanceof Player)) {
                EZMessage.text(T.t("COMMAND_ONLINE_PLAYER")).sender(sender);
                return false;
            }
            Player p = (Player)sender;
            if (!p.hasPermission("ezcolors.languages")) {
                EZMessage.text(T.t("COMMAND_NO_PERMS_LANGUAGES")).player(p);
                return true;
            }
            new LanguagesGUI(p, false);
        } else if (args[0].equalsIgnoreCase("reload")) {
            if (!(sender instanceof Player)) {
                EZMessage.text(T.t("COMMAND_ONLINE_PLAYER")).sender(sender);
                return false;
            }
            Player p = (Player)sender;
            if (!p.hasPermission("ezcolors.reload")) {
                EZMessage.text(T.t("COMMAND_NO_PERMS")).player(p);
                return true;
            }
            EZColors.getInstance().reloadConfig();
            EazyAPI.getLanguageManager().checkLanguages();
            EZMessage.text("%prefix% &aSuccessfully reloaded the Config and Languages!").player(p);
            EZMessage.text("%prefix% &eNOTE: &7You will need to restart your server to change the Storage Type (MySQL/YAML).").player(p);
        } else if (args[0].equalsIgnoreCase("custom")) {
            if (!(sender instanceof Player)) {
                EZMessage.text(T.t("COMMAND_ONLINE_PLAYER")).sender(sender);
                return false;
            }
            Player p = (Player)sender;
            if (!p.hasPermission("ezcolors.color.custom")) {
                EZMessage.text(T.t("COMMAND_NO_ACCESS_CUSTOM")).player(p);
                return true;
            }
            new ChatColorCreatorGUI(p);
        } else {
            if (EZColors.getSelectionType().equals((Object)SelectionType.GUI)) {
                if (!(sender instanceof Player)) {
                    EZMessage.text(T.t("COMMAND_ONLINE_PLAYER")).sender(sender);
                    return false;
                }
                Player p = (Player)sender;
                if (p.hasPermission("ezcolors.gui")) {
                    new ChatColorGUI(p);
                } else {
                    EZMessage.text(T.t("COMMAND_NO_PERMS")).sender(sender);
                }
                return true;
            }
            String color = args[0].replace("_", " ");
            if (args.length > 1) {
                Player p = Bukkit.getPlayerExact((String)args[1]);
                if (p == null) {
                    EZMessage.text(T.t("PLAYER_NOT_FOUND").replace("{Player}", args[1])).sender(sender);
                    return true;
                }
                ChatColorUser user = EZColors.getStorage().getUser(p.getUniqueId());
                if (ChatColor.isChatColor(color)) {
                    if (!sender.hasPermission("ezcolors.color." + color.replace(" ", "").replace("_", "").toLowerCase() + ".other")) {
                        EZMessage.text(T.t("COMMAND_NO_ACCESS")).sender(sender);
                        return true;
                    }
                    if (color.equalsIgnoreCase("reset")) {
                        if (user.isColorSet()) {
                            EZMessage.text(T.t("COLOR_SELECTED_OTHER_DEFAULT_SUCCESSFUL")).sender(sender);
                            user.setChatColor(null);
                        } else {
                            EZMessage.text(T.t("COLOR_SELECTED_OTHER_DEFAULT_NO_COLOR")).sender(sender);
                        }
                    } else if (color.equalsIgnoreCase("rainbow")) {
                        EZMessage.text(T.t("COLOR_SELECTED").replaceAll("(?i)\\{color}", T.t("COMMAND_RAINBOW"))).player(p);
                        user.setChatColor("Rainbow");
                    } else if (color.equalsIgnoreCase("rainbow2")) {
                        EZMessage.text(T.t("COLOR_SELECTED").replaceAll("(?i)\\{color}", T.t("COMMAND_RAINBOW_2"))).player(p);
                        user.setChatColor("Rainbow2");
                    } else {
                        EZMessage.text(T.t("COLOR_SELECTED_OTHER").replace("{Player}", p.getName()).replaceAll("(?i)\\{color}", "&" + ChatColor.getChatColor(color) + ChatColor.getFormattedName(color))).sender(sender);
                        user.setChatColor(ChatColor.getChatColor(color));
                    }
                } else if (this.isHexAnd116Plus(color)) {
                    if (!sender.hasPermission("ezcolors.color.hex.other")) {
                        EZMessage.text(T.t("COMMAND_NO_ACCESS")).sender(sender);
                        return true;
                    }
                    sender.sendMessage(EZMessage.text(T.t("COLOR_SELECTED_OTHER").replace("{Player}", p.getName())).colored().replaceAll("(?i)\\{color}", EZMessage.text("{" + color + "}").colored() + color));
                    user.setChatColor(color);
                } else {
                    EZMessage.text(T.t("COMMAND_NOT_COLOR").replace("{Color}", color)).sender(sender);
                }
            } else {
                if (!(sender instanceof Player)) {
                    EZMessage.text(T.t("COMMAND_ONLINE_PLAYER")).sender(sender);
                    return false;
                }
                Player p = (Player)sender;
                ChatColorUser user = EZColors.getStorage().getUser(p.getUniqueId());
                if (ChatColor.isChatColor(color)) {
                    if (!p.hasPermission("ezcolors.color." + color.replace(" ", "").replace("_", "").toLowerCase())) {
                        EZMessage.text(T.t("COMMAND_NO_ACCESS")).player(p);
                        return true;
                    }
                    if (color.equalsIgnoreCase("reset")) {
                        if (user.isColorSet()) {
                            EZMessage.text(T.t("COLOR_SELECTED_DEFAULT_SUCCESSFUL")).player(p);
                            user.setChatColor(null);
                        } else {
                            EZMessage.text(T.t("COLOR_SELECTED_DEFAULT_NO_COLOR")).player(p);
                        }
                    } else if (color.equalsIgnoreCase("rainbow")) {
                        EZMessage.text(T.t("COLOR_SELECTED").replaceAll("(?i)\\{color}", T.t("COMMAND_RAINBOW"))).player(p);
                        user.setChatColor("Rainbow");
                    } else if (color.equalsIgnoreCase("rainbow2")) {
                        EZMessage.text(T.t("COLOR_SELECTED").replaceAll("(?i)\\{color}", T.t("COMMAND_RAINBOW_2"))).player(p);
                        user.setChatColor("Rainbow2");
                    } else {
                        EZMessage.text(T.t("COLOR_SELECTED").replaceAll("(?i)\\{color}", "&" + ChatColor.getChatColor(color) + ChatColor.getFormattedName(color))).player(p);
                        user.setChatColor(ChatColor.getChatColor(color));
                    }
                } else if (this.isHexAnd116Plus(color)) {
                    if (!p.hasPermission("ezcolors.color.hex")) {
                        EZMessage.text(T.t("COMMAND_NO_ACCESS")).player(p);
                        return true;
                    }
                    p.sendMessage(EZMessage.text(T.t("COLOR_SELECTED")).colored().replaceAll("(?i)\\{color}", EZMessage.text("{" + color + "}").colored() + color));
                    user.setChatColor(color);
                } else {
                    EZMessage.text(T.t("COMMAND_NOT_COLOR").replace("{Color}", color)).player(p);
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, org.bukkit.command.Command command, String alias, String[] args) {
        ArrayList<String> firstArgs = new ArrayList<String>();
        if (sender.hasPermission("ezcolors.languages")) {
            firstArgs.add("languages");
        }
        if (sender.hasPermission("ezcolors.reload")) {
            firstArgs.add("reload");
        }
        ChatColor.getChatColors().stream().map(c -> c.replace(" ", "_")).filter(color -> this.hasPerm(sender, (String)color)).forEach(firstArgs::add);
        List<String> argss = new ArrayList<String>();
        if (args.length == 1) {
            argss = firstArgs.stream().filter(arg -> arg.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && (this.isColorArg(sender, args[0]) || this.isHexAnd116Plus(args[0]))) {
            argss.addAll(Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList()));
        }
        return argss;
    }

    public boolean isHexAnd116Plus(String s) {
        return s.matches("#[0-9A-Fa-f]{6}") && MinecraftVersion.getServersVersion().isAboveOrEqual(MinecraftVersion.V1_16_R1);
    }

    public boolean isColorArg(CommandSender sender, String s) {
        return ChatColor.getChatColors().stream().anyMatch(color -> s.equals(color) && this.hasPermOther(sender, (String)color));
    }

    public boolean hasPerm(CommandSender sender, String color) {
        return sender.hasPermission("ezcolors.color." + color.toLowerCase().replace(" ", ""));
    }

    public boolean hasPermOther(CommandSender sender, String color) {
        return sender.hasPermission("ezcolors.color." + color.toLowerCase().replace(" ", "") + ".other");
    }

    @Override
    public String getName() {
        return "ezcolors";
    }
}

