/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.command;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class EazyCommand
extends Command {
    public EazyCommand(String name, String ... aliases) {
        super(name, "", "/" + name, Arrays.asList(aliases));
        this.init();
    }

    public EazyCommand(String name, String description, String usageMessage, String ... aliases) {
        super(name, description, usageMessage, Arrays.asList(aliases));
        this.init();
    }

    public EazyCommand(String name, String description, String usageMessage, List<String> aliases) {
        super(name, description, usageMessage, aliases);
        this.init();
    }

    public EazyCommand(String command) {
        super(command);
        this.init();
    }

    private void init() {
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            commandMap.register("command", (Command)this);
        }
        catch (IllegalAccessException | NoSuchFieldException var5) {
            var5.printStackTrace();
        }
    }

    public void unregister() {
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            Field f = Arrays.stream((Field[])ArrayUtils.addAll((Object[])commandMap.getClass().getDeclaredFields(), (Object[])commandMap.getClass().getSuperclass().getDeclaredFields())).filter(field -> field.getName().equals("knownCommands")).findAny().get();
            f.setAccessible(true);
            Map cmds = (Map)f.get(commandMap);
            cmds.remove(this.getName());
            f.set(commandMap, cmds);
        }
        catch (IllegalAccessException | NoSuchFieldException var5) {
            var5.printStackTrace();
        }
    }

    public abstract void executePlayer(Player var1, String[] var2);

    public abstract void executeConsole(CommandSender var1, String[] var2);

    public boolean execute(CommandSender sender, String command, String[] args) {
        if (sender instanceof Player) {
            this.executePlayer((Player)sender, args);
        } else {
            this.executeConsole(sender, args);
        }
        return false;
    }
}

