/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.debug;

import com.eazyftw.ezcolors.EazyAPI;
import com.eazyftw.ezcolors.debug.DebugResult;
import com.eazyftw.ezcolors.versions.MinecraftVersion;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DebugManager {
    public static DebugResult createAndPost() {
        String debug = DebugManager.createDebug();
        return DebugManager.post(debug);
    }

    public static String createDebug() {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy 'at' hh:mm:ss a (z)");
        String date = formatter.format(new Date());
        DebugManager.addName("About", sb);
        sb.append("Created: ").append(date).append(".\n").append("Server Version: ").append(Bukkit.getVersion()).append(" (Implementing API version ").append(Bukkit.getBukkitVersion()).append(")");
        DebugManager.addName("server.properties", sb);
        sb.append(DebugManager.readFile("", "server.properties"));
        DebugManager.addName("spigot.yml", sb);
        sb.append(DebugManager.readFile("", "spigot.yml"));
        DebugManager.addName("bukkit.yml", sb);
        sb.append(DebugManager.readFile("", "bukkit.yml"));
        if (Files.exists(Paths.get("", "paper.yml"), new LinkOption[0])) {
            DebugManager.addName("paper.yml", sb);
            sb.append(DebugManager.readFile("", "paper.yml"));
        }
        DebugManager.addName("Plugins (" + Arrays.stream(Bukkit.getPluginManager().getPlugins()).filter(Plugin::isEnabled).count() + "/" + Bukkit.getPluginManager().getPlugins().length + ")", sb, false);
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (MinecraftVersion.getServersVersion().isAboveOrEqual(MinecraftVersion.V1_13_R1)) {
                sb.append("\n\r").append(plugin.getName()).append(" v").append(plugin.getDescription().getVersion()).append(" (API: ").append(plugin.getDescription().getAPIVersion() == null ? "Not Set" : plugin.getDescription().getAPIVersion()).append(")");
            } else {
                sb.append("\n\r").append(plugin.getName()).append(" v").append(plugin.getDescription().getVersion());
            }
            sb.append(" by ").append(plugin.getDescription().getAuthors().size() == 0 ? "Unknown" : String.join((CharSequence)", ", plugin.getDescription().getAuthors())).append(".");
            sb.append("\n- Description: ").append(plugin.getDescription().getDescription() == null ? "No description specified." : plugin.getDescription().getDescription());
            sb.append("\n- Enabled: ").append(plugin.isEnabled());
        }
        DebugManager.addName("latest.log", sb);
        sb.append(DebugManager.readFile("logs", "latest.log"));
        return sb.toString();
    }

    private static DebugResult post(String txt) {
        return DebugManager.post("https://eazy.host/upload", txt);
    }

    private static DebugResult post(String customURL, String txt) {
        try {
            URL url = new URL(customURL);
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("text", txt);
            params.put("uuid", EazyAPI.getInstanceUUID());
            StringBuilder postData = new StringBuilder();
            for (Map.Entry param : params.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode((String)param.getKey(), "UTF-8"));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            byte[] postDataBytes = postData.toString().getBytes(StandardCharsets.UTF_8);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
            conn.setDoOutput(true);
            conn.getOutputStream().write(postDataBytes);
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            return (DebugResult)new Gson().fromJson((Reader)in, DebugResult.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static void addName(String name, StringBuilder sb, boolean nextEnd) {
        if (sb.length() > 0) {
            sb.append("\n\r");
        }
        sb.append("====================================================== ").append(name).append(" ======================================================");
        if (nextEnd) {
            sb.append("\n\r");
        }
    }

    private static void addName(String name, StringBuilder sb) {
        DebugManager.addName(name, sb, true);
    }

    private static String readFile(String dir, String file) {
        try {
            return String.join((CharSequence)"\n", Files.readAllLines(Paths.get(dir, file), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Could not get the contents of " + dir + "/" + file + "!";
        }
    }
}

