/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.gui.gui;

import com.eazyftw.ezcolors.EazyAPI;
import com.eazyftw.ezcolors.gui.action.Action;
import com.eazyftw.ezcolors.gui.action.ActionType;
import com.eazyftw.ezcolors.gui.button.Button;
import com.eazyftw.ezcolors.gui.button.ButtonEntry;
import com.eazyftw.ezcolors.gui.gui.GUILoc;
import com.eazyftw.ezcolors.gui.info.GUIInfo;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class GUI
implements Listener {
    protected Player p;
    private Inventory inventory;
    private BukkitTask task;
    private Runnable runnable;
    private HashMap<Integer, List<Action>> actions = new HashMap();
    private boolean clicked = false;

    public GUI(Player p) {
        this.p = p;
        this.runnable = () -> {
            GUIInfo info = new GUIInfo();
            this.construct(info);
            HashMap<GUILoc, ButtonEntry> entries = new HashMap<GUILoc, ButtonEntry>(info.entries());
            if (this.inventory == null || !p.getOpenInventory().getTitle().equals(info.title()) || this.inventory.getSize() / 9 != info.rows()) {
                this.openInventory(this.p, info);
            }
            IntStream.range(0, this.inventory.getSize()).filter(i -> !entries.containsKey(GUILoc.of(i))).forEach(i -> this.inventory.clear());
            this.actions = new HashMap();
            entries.forEach((slot, entry) -> {
                Button button = new Button();
                entry.button(button);
                this.inventory.setItem(slot.toNormal(), button.item().build());
                this.actions.put(slot.toNormal(), button.actions());
            });
            p.updateInventory();
        };
        this.startTask();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)EazyAPI.getPluginAPI());
    }

    protected abstract void construct(GUIInfo var1);

    public void onClose(Inventory inventory) {
    }

    public void reopen() {
        if (this.inventory != null) {
            return;
        }
        this.startTask();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)EazyAPI.getPluginAPI());
    }

    private void startTask() {
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)EazyAPI.getPluginAPI(), this.runnable, 0L, 1L);
    }

    public void stopTask() {
        this.task.cancel();
    }

    private void openInventory(Player p, GUIInfo info) {
        this.inventory = Bukkit.createInventory(null, (int)(info.rows() * 9), (String)info.title());
        p.openInventory(this.inventory);
    }

    private void close() {
        if (!this.clicked) {
            this.onClose(this.inventory);
        }
        this.inventory = null;
        this.stopTask();
        this.unregister();
    }

    private void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!e.getWhoClicked().equals(this.p)) {
            return;
        }
        if (e.getSlotType() == InventoryType.SlotType.OUTSIDE) {
            e.setCancelled(true);
            return;
        }
        if (!(e.getClickedInventory() instanceof PlayerInventory)) {
            e.setCancelled(true);
            if (this.actions.containsKey(e.getSlot())) {
                this.clicked = true;
                ActionType type = ActionType.fromClickType(e.getClick());
                this.actions.get(e.getSlot()).forEach(action -> action.run(type));
                Bukkit.getScheduler().runTaskLater((Plugin)EazyAPI.getPluginAPI(), () -> {
                    this.clicked = false;
                }, 3L);
            }
        } else {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void drag(InventoryDragEvent e) {
        if (!e.getWhoClicked().equals(this.p)) {
            return;
        }
        if (e.getInventory() instanceof PlayerInventory) {
            return;
        }
        if (e.getInventorySlots().size() > 1) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void leave(PlayerQuitEvent e) {
        if (e.getPlayer().equals(this.p)) {
            this.close();
        }
    }

    @EventHandler
    public void close(InventoryCloseEvent e) {
        if (this.inventory != null && this.inventory.equals(e.getInventory())) {
            GUIInfo info = new GUIInfo();
            this.construct(info);
            if (!info.closable()) {
                Bukkit.getScheduler().runTask((Plugin)EazyAPI.getPluginAPI(), () -> e.getPlayer().openInventory(e.getInventory()));
            } else {
                this.close();
            }
        }
    }
}

