/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.guis;

import com.eazyftw.ezcolors.EZColors;
import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.gui.gui.GUI;
import com.eazyftw.ezcolors.gui.info.GUIInfo;
import com.eazyftw.ezcolors.guis.ChatColorCreatorGUI;
import com.eazyftw.ezcolors.guis.LanguagesGUI;
import com.eazyftw.ezcolors.guis.RainbowColorGUI;
import com.eazyftw.ezcolors.guis.head.ChatColorEnum;
import com.eazyftw.ezcolors.guis.head.HeadEnum;
import com.eazyftw.ezcolors.language.T;
import com.eazyftw.ezcolors.storage.ChatColorUser;
import com.eazyftw.ezcolors.types.GUIType;
import com.eazyftw.ezcolors.types.color.ChatColor;
import com.eazyftw.ezcolors.versions.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class ChatColorGUI
extends GUI {
    private int time = 0;
    private ChatColorUser user;

    public ChatColorGUI(Player p) {
        super(p);
        this.p = p;
        this.user = EZColors.getStorage().getUser(p.getUniqueId());
    }

    @Override
    protected void construct(GUIInfo info) {
        int slot1;
        String[] list;
        info.title(EZMessage.text(T.t("GUI_COLOR_TITLE")).colored());
        info.rows(6);
        ++this.time;
        if (this.time > 20) {
            this.user = EZColors.getStorage().getUser(this.p.getUniqueId());
            this.time = 0;
        }
        ArrayList<String> color_lore = new ArrayList<String>();
        String color = this.user.isColorSet() ? (this.user.getColor().startsWith("#") ? EZMessage.text("{" + this.user.getColor() + "}").colored() + this.user.getColor() : (this.user.getColor().contains("&") ? String.join((CharSequence)"&7, ", new ArrayList(Arrays.stream(this.user.getColor().split(";")).map(ChatColor::getColorNameFromCode).collect(Collectors.toList()))) + "&7." : (this.user.getColor().contains("Rainbow") ? (this.user.getColor().equals("Rainbow") ? ChatColor.createRainbowChat(T.t("COLOR_RAINBOW")) : (this.user.getColor().equals("Rainbow2") ? ChatColor.createNiceRainbowChat(T.t("COLOR_CLEAN_RAINBOW") + " 2") : ChatColor.createRainbowChatHex(T.t("COLOR_HEX_RAINBOW")))) : ChatColor.getColorNameFromCode("&" + this.user.getColor())))) : T.t("NO_COLOR_SET");
        for (String s : list = T.tNColored("GUI_SELECTED_COLOR_LORE", "f")) {
            color_lore.add(s.replace("{SelectedColor}", color));
        }
        int n = this.p.hasPermission("ezcolors.showrainbow") ? 3 : (slot1 = this.p.hasPermission("ezcolors.showlanguage") ? 3 : 5);
        int slot2 = this.p.hasPermission("ezcolors.showrainbow") ? 7 : (this.p.hasPermission("ezcolors.showlanguage") ? 7 : 4);
        for (ChatColorEnum cc : ChatColorEnum.values()) {
            if (!cc.shouldShowInCreator()) continue;
            info.button(button -> {
                button.material(XMaterial.PLAYER_HEAD).name(cc.getColorString() + "&l" + T.t(cc.getColor())).lores(this.getSelectedGUIMsg(T.t(cc.getColor())), "", this.hasPerm(cc.getPermission()) ? T.t("GUI_HAS_ACCESS") : T.t("GUI_NO_ACCESS")).setSkullTexture(cc.getHeadEnum().getUrl());
                button.action(action -> {
                    if (this.hasPerm(cc.getPermission())) {
                        EZMessage.text(this.getSelectedMsg(cc.getColorString() + T.t(cc.getColor()))).player(this.p);
                        this.user.setChatColor(cc.getColorString().replace("&", ""));
                    } else {
                        EZMessage.text(T.t("COMMAND_NO_ACCESS")).player(this.p);
                    }
                    if (EZColors.getGUIType().name().contains("CLOSE")) {
                        this.p.closeInventory();
                    }
                });
            }, cc.getLocMain().toNormal());
        }
        info.button(button -> {
            button.material(XMaterial.BARRIER).name("&4&l" + T.t("COLOR_RESET") + " " + T.t("COLOR")).lores(T.t("GUI_SET_COLOR_DEFAULT"), "", this.p.hasPermission("ezcolors.color.reset") ? T.t("GUI_SET_COLOR_DEFAULT_HAS_ACCESS") : T.t("GUI_SET_COLOR_DEFAULT_NO_ACCESS"));
            button.action(action -> {
                if (!this.p.hasPermission("ezcolors.color.reset")) {
                    EZMessage.text(T.t("COLOR_RESET_NO_PERM")).player(this.p);
                    return;
                }
                if (this.user.isColorSet()) {
                    EZMessage.text(T.t("COLOR_SELECTED_DEFAULT_SUCCESSFUL")).player(this.p);
                    this.user.setChatColor(null);
                } else {
                    EZMessage.text(T.t("COLOR_SELECTED_DEFAULT_NO_COLOR")).player(this.p);
                }
                if (EZColors.getGUIType() == GUIType.CLOSE_RESET) {
                    this.p.closeInventory();
                }
            });
        }, slot1, slot2);
        if (this.user.isColorSet() && this.user.getColor().startsWith("#")) {
            info.button(button -> button.material(XMaterial.PLAYER_HEAD).setSkullTexture(HeadEnum.CHEST.getUrl()).name(T.t("GUI_SELECTED_COLOR_TITLE")).loreNoColor(color_lore), 5, 6);
        } else {
            info.button(button -> button.material(XMaterial.PLAYER_HEAD).setSkullTexture(HeadEnum.CHEST.getUrl()).name(T.t("GUI_SELECTED_COLOR_TITLE")).lore(color_lore), 5, 6);
        }
        info.button(button -> {
            button.material(XMaterial.NETHER_STAR).name(T.t("GUI_CUSTOM_COLOR_ITEM_TITLE")).lores(this.p.hasPermission("ezcolors.color.custom") ? T.t("GUI_CUSTOM_COLOR_ITEM_LORE_HAS_ACCESS") : T.t("GUI_CUSTOM_COLOR_ITEM_LORE_NO_ACCESS"));
            button.action(action -> {
                if (!this.p.hasPermission("ezcolors.color.custom")) {
                    EZMessage.text(T.t("COMMAND_NO_ACCESS_CUSTOM")).player(this.p);
                    return;
                }
                new ChatColorCreatorGUI(this.p);
            });
        }, 5, 2);
        if (this.p.hasPermission("ezcolors.showrainbow")) {
            info.button(button -> {
                button.material(XMaterial.PLAYER_HEAD).name("&4&l" + ChatColor.createNiceRainbowChat(T.t("COLOR_RAINBOW"), false, true)).setSkullTexture(HeadEnum.RAINBOW.getUrl()).lores(T.t("COLOR_RAINBOW_SELECT"), "", this.hasPerm("rainbow") ? T.t("GUI_HAS_ACCESS") : T.t("GUI_NO_ACCESS"));
                button.action(action -> {
                    if (this.hasPerm("rainbow")) {
                        new RainbowColorGUI(this.p);
                    } else {
                        EZMessage.text(T.t("GUI_NO_ACCESS")).player(this.p);
                    }
                    if (EZColors.getGUIType().name().contains("CLOSE")) {
                        this.p.closeInventory();
                    }
                });
            }, 3, 1);
        }
        if (this.p.hasPermission("ezcolors.showlanguage")) {
            info.button(button -> {
                button.material(XMaterial.PLAYER_HEAD).name("&9&l" + T.t("GUI_LANGUAGE_TITLE")).setSkullTexture(HeadEnum.GLOBE.getUrl());
                button.action(action -> new LanguagesGUI(this.p, true));
            }, 5, 4);
        }
    }

    public String getSelectedMsg(String color) {
        return T.t("COLOR_SELECTED").replaceAll("(?i)\\{color}", color);
    }

    public String getSelectedGUIMsg(String color) {
        return T.t("GUI_SET_COLOR").replaceAll("(?i)\\{color}", color);
    }

    public boolean hasPerm(String color) {
        return this.p.hasPermission("ezcolors.color." + color.toLowerCase());
    }
}

