/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.item;

import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.versions.XMaterial;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilder {
    protected ItemStack is;
    protected ItemMeta im;

    protected ItemBuilder(XMaterial xMaterial) {
        this.is = xMaterial.parseItem();
    }

    protected ItemBuilder(XMaterial xMaterial, int amount) {
        this.is = xMaterial.parseItem();
        if (this.is != null) {
            this.is.setAmount(amount);
        }
    }

    protected ItemBuilder(ItemStack itemStack) {
        this.is = new ItemStack(itemStack);
    }

    protected ItemBuilder(Material material) {
        this.is = new ItemStack(material);
    }

    protected ItemBuilder(Material material, int amount) {
        this.is = new ItemStack(material, amount);
    }

    @Deprecated
    protected ItemBuilder(Material material, int amount, int subid) {
        this.is = new ItemStack(material, amount, (short)subid);
    }

    public static ItemBuilder of(XMaterial material) {
        return new ItemBuilder(material);
    }

    public static ItemBuilder of(XMaterial material, int amount) {
        return new ItemBuilder(material, amount);
    }

    public static ItemBuilder of(Material material) {
        return new ItemBuilder(material);
    }

    public static ItemBuilder of(Material material, int amount) {
        return new ItemBuilder(material, amount);
    }

    @Deprecated
    public static ItemBuilder of(Material material, int amount, int subid) {
        return new ItemBuilder(material, amount, subid);
    }

    public static ItemBuilder of(ItemStack is) {
        return new ItemBuilder(is);
    }

    public ItemBuilder setDurability(int durability) {
        this.is.setDurability((short)durability);
        return this;
    }

    public ItemBuilder setOwner(OfflinePlayer offlp) {
        if (this.is.getItemMeta() != null && this.is.getItemMeta() instanceof SkullMeta) {
            SkullMeta itemMeta = (SkullMeta)this.is.getItemMeta();
            itemMeta.setOwningPlayer(offlp);
            this.is.setItemMeta((ItemMeta)itemMeta);
        }
        return this;
    }

    public ItemBuilder setOwner(UUID uuid) {
        this.setOwner(Bukkit.getOfflinePlayer((UUID)uuid));
        return this;
    }

    public ItemBuilder setOwner(String name) {
        if (this.is.getItemMeta() != null && this.is.getItemMeta() instanceof SkullMeta) {
            SkullMeta itemMeta = (SkullMeta)this.is.getItemMeta();
            itemMeta.setOwner(name);
            this.is.setItemMeta((ItemMeta)itemMeta);
        }
        return this;
    }

    private static JsonObject getJsonResponse(String url) {
        JsonObject rootobj = null;
        try {
            URL ipAdress = new URL(url);
            BufferedReader in = new BufferedReader(new InputStreamReader(ipAdress.openStream()));
            String jsonresponse = in.readLine();
            JsonParser jsonParser = new JsonParser();
            JsonElement root = jsonParser.parse(jsonresponse);
            rootobj = root.getAsJsonObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rootobj;
    }

    public static String getTextureURL(int id) {
        JsonObject jsonresponse = ItemBuilder.getJsonResponse("https://api.mineskin.org/get/id/" + id);
        if (jsonresponse != null && !jsonresponse.has("error")) {
            JsonObject textureProperty = jsonresponse.getAsJsonObject("data").getAsJsonObject("texture");
            return textureProperty.get("url").getAsString();
        }
        return "http://textures.minecraft.net/texture/3d966924d054bc5d1c4127b3c42a37a28a2367a44867e98d4c1ac42e20adbd";
    }

    public ItemBuilder setOwnerFromSkinID(int id) {
        String skinURL = ItemBuilder.getTextureURL(id);
        if (skinURL.isEmpty()) {
            return this;
        }
        ItemMeta headMeta = this.is.getItemMeta();
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        byte[] encodedData = Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"%s\"}}}", skinURL).getBytes());
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", new String(encodedData)));
        Field profileField = null;
        try {
            profileField = headMeta.getClass().getDeclaredField("profile");
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        profileField.setAccessible(true);
        try {
            profileField.set(headMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.is.setItemMeta(headMeta);
        return this;
    }

    public ItemBuilder setDisplayName(String name) {
        this.im = this.is.getItemMeta();
        this.im.setDisplayName(EZMessage.text(name).colored());
        this.is.setItemMeta(this.im);
        return this;
    }

    public ItemBuilder addEnchant(Enchantment enchantment, int level) {
        this.im = this.is.getItemMeta();
        this.im.addEnchant(enchantment, level, true);
        this.is.setItemMeta(this.im);
        return this;
    }

    public ItemBuilder addEnchants(Map<Enchantment, Integer> enchantments) {
        this.im = this.is.getItemMeta();
        if (!enchantments.isEmpty()) {
            for (Enchantment ench : enchantments.keySet()) {
                this.im.addEnchant(ench, enchantments.get(ench).intValue(), true);
            }
        }
        this.is.setItemMeta(this.im);
        return this;
    }

    public ItemBuilder addItemFlag(ItemFlag itemflag) {
        this.im = this.is.getItemMeta();
        this.im.addItemFlags(new ItemFlag[]{itemflag});
        this.is.setItemMeta(this.im);
        return this;
    }

    public ItemBuilder setLore(List<String> lore) {
        ArrayList<String> list = new ArrayList<String>();
        for (String l : lore) {
            list.add(EZMessage.text(l).colored());
        }
        this.im = this.is.getItemMeta();
        this.im.setLore(list);
        this.is.setItemMeta(this.im);
        return this;
    }

    public ItemBuilder setLore(String ... lore) {
        this.setLore(Arrays.asList(lore));
        return this;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        ItemMeta meta = this.is.getItemMeta();
        if (meta == null) {
            return this;
        }
        meta.setUnbreakable(unbreakable);
        this.is.setItemMeta(meta);
        return this;
    }

    public ItemStack build() {
        return this.is;
    }
}

