/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.language;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class Language {
    private String name;
    private String shortName;
    private String configName;
    private FileConfiguration config;
    private boolean finished;

    public Language(String name, String shortName, String configName, FileConfiguration config) {
        this.name = name;
        this.shortName = shortName;
        this.configName = configName.endsWith(".yml") ? configName : configName + ".yml";
        this.config = config;
        this.finished = false;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String get(String s) {
        if (s.isEmpty()) {
            return "";
        }
        if (!this.config.contains(s)) {
            return s;
        }
        return this.config.getString(s);
    }

    public List<String> getList(String s) {
        if (s.isEmpty()) {
            return new ArrayList<String>();
        }
        if (!this.config.contains(s)) {
            return new ArrayList<String>(Collections.singletonList(s));
        }
        return this.config.getStringList(s);
    }
}

