/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.language;

import com.eazyftw.ezcolors.EazyAPI;
import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.language.Language;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageManager {
    private File folder;
    private List<Language> languages;

    public void init() {
        this.setupDirectories();
        this.languages = new ArrayList<Language>();
        this.setupLanguages();
    }

    public void checkLanguages() {
        this.setupLanguages();
    }

    public String getTranslation(String lang, String str) {
        Language l = this.languages.stream().filter(language -> language.getShortName().equalsIgnoreCase(lang)).findFirst().orElse(null);
        if (l == null) {
            return null;
        }
        return l.get(str);
    }

    public List<String> getTranslationList(String lang, String str) {
        Language l = this.languages.stream().filter(language -> language.getShortName().equalsIgnoreCase(lang)).findFirst().orElse(null);
        if (l == null) {
            return null;
        }
        return l.getList(str);
    }

    public List<String> getTranslationList(String s) {
        return this.getTranslationList(EazyAPI.getStorageManager().getFileFromName("Translation").getString("CurrentTranslation"), s);
    }

    public String getTranslation(String s) {
        return this.getTranslation(EazyAPI.getStorageManager().getFileFromName("Translation").getString("CurrentTranslation"), s);
    }

    private void setupLanguages() {
        try {
            File[] locales = this.folder.listFiles((dir, name) -> dir != null && name.matches("locale_.*\\.yml"));
            this.languages = new ArrayList<Language>();
            if (locales != null) {
                for (File file : locales) {
                    Language lang;
                    if (this.getShortName(file).equalsIgnoreCase("")) continue;
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                    if (!config.contains("Name")) {
                        lang = new Language("locale_" + this.getShortName(file) + ".yml", this.getShortName(file), "locale_" + this.getShortName(file), (FileConfiguration)config);
                        this.languages.add(lang);
                        continue;
                    }
                    lang = new Language(config.getString("Name"), this.getShortName(file), "locale_" + this.getShortName(file), (FileConfiguration)config);
                    lang.setFinished(true);
                    this.languages.add(lang);
                }
            }
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            EZMessage.text("%prefix% &cSomething went wrong while trying to setup languages. Please contact EazyFTW for support.").console();
        }
    }

    public void setLanguage(String shortName) {
        EazyAPI.getStorageManager().getFileFromName("Translation").set("CurrentTranslation", shortName);
    }

    public String getLanguage() {
        return EazyAPI.getStorageManager().getFileFromName("Translation").getString("CurrentTranslation");
    }

    private String getShortName(File file) {
        return file.getName().replace(".yml", "").replace("locale_", "");
    }

    private void setupDirectories() {
        this.folder = new File(EazyAPI.getPluginAPI().getDataFolder() + "/locales");
        this.folder.mkdir();
    }

    public File getFolder() {
        return this.folder;
    }

    public List<Language> getLanguages() {
        return this.languages;
    }
}

