/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.languages;

import com.eazyftw.ezcolors.EZColors;
import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.languages.LanguagesGson;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

public class OnlineLanguagesManager {
    private static List<String> languages = new ArrayList<String>();

    public static boolean getLanguagesAndDownload() {
        try {
            URL url = new URL("https://api.ezplug.in/ezcolors/languages");
            InputStreamReader reader = new InputStreamReader(url.openStream());
            languages = ((LanguagesGson)new Gson().fromJson((Reader)reader, LanguagesGson.class)).getLanguages();
        }
        catch (Exception e) {
            EZMessage.text("%prefix% &cSomething went wrong while trying to fetch the languages from online!").console();
            return false;
        }
        boolean success = OnlineLanguagesManager.downloadAndLoadLanguages(languages);
        if (success) {
            EZMessage.text("%prefix% &aSuccessfully downloaded " + languages.size() + " languages from the cloud!").console();
        } else {
            EZMessage.text("%prefix% &cFailed to download " + languages.size() + " languages from the cloud!").console();
        }
        return success;
    }

    private static boolean downloadAndLoadLanguages(List<String> languages) {
        for (String language : languages) {
            try {
                boolean result;
                File langFile = new File(EZColors.getInstance().getDataFolder() + "/locales/" + language + ".yml");
                if (langFile.exists() && !(result = langFile.delete())) {
                    EZMessage.text("%prefix% &cSomething went wrong while trying to fetch the " + language.replace("locale_", "") + " language from online!").console();
                    return false;
                }
                if (langFile.createNewFile()) {
                    FileWriter myWriter = new FileWriter(langFile);
                    myWriter.write(OnlineLanguagesManager.getText("https://api.ezplug.in/ezcolors/language/" + language));
                    myWriter.close();
                    continue;
                }
                EZMessage.text("%prefix% &cSomething went wrong while trying to fetch the " + language.replace("locale_", "") + " language from online!").console();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static String getText(String url) {
        try {
            String inputLine;
            URL website = new URL(url);
            URLConnection connection = website.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine + "\r\n");
            }
            in.close();
            return response.toString().replaceFirst("<pre style=\"word-wrap: break-word; white-space: pre-wrap;\">", "").replace("</pre>", "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static List<String> getLanguages() {
        return languages;
    }
}

