/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.listeners;

import com.eazyftw.ezcolors.EZColors;
import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.listeners.EnumListener;
import com.eazyftw.ezcolors.listeners.HighestListener;
import com.eazyftw.ezcolors.storage.ChatColorUser;
import com.eazyftw.ezcolors.types.color.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatListener {
    protected static void run(AsyncPlayerChatEvent e) {
        Player p = e.getPlayer();
        ChatColorUser user = EZColors.getStorage().getUser(p.getUniqueId());
        if (user.isColorSet()) {
            String msg = ChatColor.getMessage(p, e.getMessage());
            e.setMessage(msg);
        }
    }

    public static void register(String name) {
        Listener listener;
        try {
            listener = EnumListener.valueOf(name.toUpperCase()).getListener();
            EZMessage.text("%prefix% &7Using &e" + name + " &7as the Chat Listener.").console();
        }
        catch (IllegalArgumentException ex) {
            EZMessage.text("%prefix% &c" + name + " is an invalid listener. Defaulting to HIGHEST as the Chat Listener.").console();
            listener = new HighestListener();
        }
        Bukkit.getServer().getPluginManager().registerEvents(listener, (Plugin)EZColors.getInstance());
    }
}

