/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.npc;

import com.eazyftw.ezcolors.npc.NPCLibOptions;
import com.eazyftw.ezcolors.npc.api.NPC;
import com.eazyftw.ezcolors.npc.api.utilities.Logger;
import com.eazyftw.ezcolors.npc.listeners.ChunkListener;
import com.eazyftw.ezcolors.npc.listeners.PacketListener;
import com.eazyftw.ezcolors.npc.listeners.PeriodicMoveListener;
import com.eazyftw.ezcolors.npc.listeners.PlayerListener;
import com.eazyftw.ezcolors.npc.listeners.PlayerMoveEventListener;
import java.util.List;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class NPCLib {
    private final JavaPlugin plugin;
    private final Logger logger;
    private final Class<?> npcClass;
    private double autoHideDistance = 50.0;

    private NPCLib(JavaPlugin plugin, NPCLibOptions.MovementHandling moveHandling) {
        this.plugin = plugin;
        this.logger = new Logger("NPCLib");
        String versionName = plugin.getServer().getClass().getPackage().getName().split("\\.")[3];
        Class<?> npcClass = null;
        try {
            npcClass = Class.forName("com.eazyftw.ezcolors.npc.nms." + versionName + ".NPC_" + versionName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.npcClass = npcClass;
        if (npcClass == null) {
            this.logger.severe("Failed to initiate. Your server's version (" + versionName + ") is not supported");
            return;
        }
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new PlayerListener(this), (Plugin)plugin);
        pluginManager.registerEvents((Listener)new ChunkListener(this), (Plugin)plugin);
        if (moveHandling.usePme) {
            pluginManager.registerEvents((Listener)new PlayerMoveEventListener(), (Plugin)plugin);
        } else {
            pluginManager.registerEvents((Listener)new PeriodicMoveListener(this, moveHandling.updateInterval), (Plugin)plugin);
        }
        new PacketListener().start(this);
        this.logger.info("Enabled for Minecraft " + versionName);
    }

    public NPCLib(JavaPlugin plugin) {
        this(plugin, NPCLibOptions.MovementHandling.playerMoveEvent());
    }

    public NPCLib(JavaPlugin plugin, NPCLibOptions options) {
        this(plugin, options.moveHandling);
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public void setAutoHideDistance(double autoHideDistance) {
        this.autoHideDistance = autoHideDistance;
    }

    public double getAutoHideDistance() {
        return this.autoHideDistance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public NPC createNPC(List<String> text) {
        try {
            return (NPC)this.npcClass.getConstructors()[0].newInstance(this, text);
        }
        catch (Exception exception) {
            this.logger.warning("Failed to create NPC. Please report the following stacktrace message", exception);
            return null;
        }
    }

    public NPC createNPC() {
        return this.createNPC(null);
    }
}

