/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.regeneration.modern;

import com.eazyftw.ezcolors.regeneration.worldedit.NoSchematicException;
import com.eazyftw.ezcolors.regeneration.worldedit.SchematicProcessor;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EmptyClipboardException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class WESchematicProcessor
extends SchematicProcessor {
    public WESchematicProcessor() {
    }

    protected WESchematicProcessor(WorldEditPlugin plugin, String name, File directory) {
        super(plugin, name, directory);
    }

    @Override
    public void write(Player player) throws EmptyClipboardException {
        BukkitPlayer bPlayer = BukkitAdapter.adapt((Player)player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)bPlayer);
        try (ClipboardWriter writer = BuiltInClipboardFormat.SPONGE_SCHEMATIC.getWriter((OutputStream)new FileOutputStream(this.schematic));){
            writer.write(session.getClipboard().getClipboard());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public EditSession paste(Location location) throws NoSchematicException {
        EditSession session = null;
        try (EditSession editSession = session = WorldEdit.getInstance().getEditSessionFactory().getEditSession((World)new BukkitWorld(location.getWorld()), -1);){
            Operation operation = new ClipboardHolder(this.load()).createPaste((Extent)editSession).to(BlockVector3.at((int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ())).ignoreAirBlocks(false).build();
            Operations.complete((Operation)operation);
            editSession.flushSession();
        }
        catch (WorldEditException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            throw new NoSchematicException(SchematicProcessor.getBaseName(this.schematic));
        }
        return session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Clipboard load() {
        ClipboardFormat format = ClipboardFormats.findByFile((File)this.schematic);
        try (ClipboardReader reader = format.getReader((InputStream)new FileInputStream(this.schematic));){
            Clipboard clipboard = reader.read();
            return clipboard;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected SchematicProcessor newInstance(WorldEditPlugin plugin, String name, File directory) {
        return new WESchematicProcessor(plugin, name, directory);
    }
}

