/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.scoreboard;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class ScoreboardLine {
    private String text;
    private String permission;

    private ScoreboardLine(String text) {
        this.text = text;
    }

    private ScoreboardLine(String text, String permission) {
        this.text = text;
        this.permission = permission;
    }

    public static ScoreboardLine of(String text) {
        return new ScoreboardLine(text);
    }

    public static ScoreboardLine of(String text, String permission) {
        return new ScoreboardLine(text, permission);
    }

    public static List<ScoreboardLine> of(List<String> list) {
        return list.stream().map(ScoreboardLine::of).collect(Collectors.toList());
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public boolean hasPermission(Player p) {
        if (this.permission == null) {
            return true;
        }
        return p.hasPermission(this.permission);
    }

    public String getText() {
        return this.text;
    }

    public Optional<String> getPermission() {
        return Optional.ofNullable(this.permission);
    }

    public String toString() {
        return this.text;
    }
}

