/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.scoreboard;

import com.eazyftw.ezcolors.scoreboard.FastBoard;
import com.eazyftw.ezcolors.scoreboard.Scoreboard;
import com.eazyftw.ezcolors.scoreboard.ScoreboardLine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ScoreboardManager {
    private final JavaPlugin plugin;
    private final HashMap<UUID, String> lastSb;
    private Map<Player, FastBoard> boards = new HashMap<Player, FastBoard>();
    private Map<Player, Scoreboard> scoreboards = new HashMap<Player, Scoreboard>();

    public ScoreboardManager(JavaPlugin plugin) {
        this.lastSb = new HashMap();
        this.plugin = plugin;
        this.start();
    }

    public FastBoard createBoard(Player player, String name) {
        this.deleteBoard(player);
        FastBoard board = new FastBoard(player);
        board.updateTitle(name);
        this.boards.put(player, board);
        return board;
    }

    public void deleteBoard(Player player) {
        if (this.boards.containsKey(player) && !this.getBoard(player).isDeleted()) {
            this.boards.get(player).delete();
        }
        this.boards.remove(player);
    }

    public void removeBoard(Player player) {
        this.boards.remove(player);
    }

    public boolean hasBoard(Player player) {
        return this.boards.containsKey(player);
    }

    public FastBoard getBoard(Player player) {
        return this.boards.get(player);
    }

    public void removeBoards() {
        Bukkit.getOnlinePlayers().stream().filter(this::hasBoard).forEach(this::deleteBoard);
        this.boards = new HashMap<Player, FastBoard>();
    }

    public Map<Player, FastBoard> getBoards() {
        return new HashMap<Player, FastBoard>(this.boards);
    }

    public Optional<Scoreboard> getScoreboard(Player p) {
        return Optional.ofNullable(this.scoreboards.get(p));
    }

    public void setScoreboard(Player p, Scoreboard scoreboard) {
        this.scoreboards.put(p, scoreboard);
    }

    public void removeScoreboard(Player p) {
        this.scoreboards.remove(p);
    }

    public void start() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> Bukkit.getOnlinePlayers().forEach(player -> this.getScoreboard((Player)player).ifPresent(scoreboard -> {
            if (this.lastSb.containsKey(player.getUniqueId())) {
                String oldName = this.lastSb.get(player.getUniqueId());
                if (!oldName.equals(scoreboard.getName()) && this.hasBoard((Player)player)) {
                    this.getBoard((Player)player).delete();
                } else if (!this.hasBoard((Player)player)) {
                    this.createBoard((Player)player, scoreboard.getTitle());
                }
                FastBoard board = this.getBoard((Player)player);
                if (board == null) {
                    return;
                }
                List<String> lines = scoreboard.getLines().stream().filter(l -> l.hasPermission((Player)player)).map(ScoreboardLine::getText).collect(Collectors.toList());
                board.updateLines(lines);
                if (!board.getTitle().equals(scoreboard.getTitle())) {
                    board.updateTitle(scoreboard.getTitle());
                }
            }
            this.lastSb.put(player.getUniqueId(), scoreboard.getName());
        })), 0L, 1L);
    }
}

