/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.system;

import com.eazyftw.ezcolors.EazyAPI;
import com.eazyftw.ezcolors.versions.XMaterial;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class StorageFile {
    private final String name;
    private final boolean autoSave;
    private String fileExtension = "dat";
    private File file;
    private FileConfiguration config;

    public StorageFile(String name, HashMap<String, Object> list, boolean autoSave) {
        this.name = name;
        this.autoSave = autoSave;
        this.load();
        this.setup(list);
    }

    public StorageFile(String name, HashMap<String, Object> list, String fileExtension, boolean autoSave) {
        this.name = name;
        this.fileExtension = fileExtension;
        this.autoSave = autoSave;
        this.load();
        this.setup(list);
    }

    public StorageFile(String name, boolean autoSave) {
        this.name = name;
        this.autoSave = autoSave;
        this.load();
    }

    public StorageFile(String name, String fileExtension, boolean autoSave) {
        this.name = name;
        this.fileExtension = fileExtension;
        this.autoSave = autoSave;
        this.load();
    }

    public String getName() {
        return this.name;
    }

    private void load() {
        this.file = new File(EazyAPI.getPluginAPI().getDataFolder() + "/storage/" + this.getName() + "." + this.fileExtension);
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.save();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    private void setup(HashMap<String, Object> map) {
        map.forEach((key, value) -> {
            if (!this.config.contains(key)) {
                this.config.set(key, value);
            }
        });
        this.save();
    }

    @Nullable
    public String getString(String s) {
        return !this.config.contains(s) ? "" : this.config.getString(s);
    }

    public double getDouble(String s) {
        return !this.config.contains(s) ? 0.0 : this.config.getDouble(s);
    }

    @Nullable
    public Float getFloat(String s) {
        return Float.valueOf(!this.config.contains(s) ? 0.0f : (float)this.config.getDouble(s));
    }

    @Nullable
    public Object get(String s) {
        return !this.config.contains(s) ? "" : this.config.get(s);
    }

    public List<String> getStringList(String s) {
        if (!this.contains(s) || this.get(s) == null) {
            return null;
        }
        return this.config.getStringList(s);
    }

    @Nullable
    public ItemStack getItemStack(String s) {
        if (!this.contains(s) || this.get(s) == null) {
            return null;
        }
        return this.config.getItemStack(s);
    }

    @Nullable
    public XMaterial getMaterial(String s) {
        if (!this.contains(s) || this.get(s) == null) {
            return null;
        }
        return XMaterial.fromMaterial(this.getString(s));
    }

    @Nullable
    public XMaterial getMaterial(String s, XMaterial d) {
        if (!this.contains(s) || this.get(s) == null) {
            return null;
        }
        return XMaterial.fromMaterial(this.getString(s), d);
    }

    @Nullable
    public List<ItemStack> getItems(String s) {
        if (!this.contains(s) || this.get(s) == null) {
            return null;
        }
        return this.config.getList(s);
    }

    @Nullable
    public List<ItemStack> getItems(String s, List<ItemStack> d) {
        if (!this.contains(s) || this.get(s) == null) {
            return d;
        }
        return this.config.getList(s);
    }

    @Nonnull
    public HashMap<Integer, ItemStack> getInventory(String s) {
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        for (String keys : Objects.requireNonNull(this.config.getConfigurationSection(s)).getKeys(false)) {
            ItemStack is = (ItemStack)this.get(s + "." + keys);
            if (is == null) continue;
            items.put(Integer.parseInt(keys), is);
        }
        return items;
    }

    @Nullable
    public Location getLocation(String name) {
        World world = Bukkit.getWorld((String)this.getString(name + ".World"));
        double x = this.getFloat(name + ".X").floatValue();
        double y = this.getFloat(name + ".Y").floatValue();
        double z = this.getFloat(name + ".Z").floatValue();
        float yaw = this.contains(name + ".Yaw") ? this.getFloat(name + ".Yaw").floatValue() : 0.0f;
        float pitch = this.contains(name + ".Pitch") ? this.getFloat(name + ".Pitch").floatValue() : 0.0f;
        return new Location(world, x, y, z, yaw, pitch);
    }

    public boolean contains(String name) {
        return this.config.contains(name);
    }

    public void setLocation(String name, Location location) {
        this.set(name + ".World", location.getWorld().getName());
        this.set(name + ".X", location.getX());
        this.set(name + ".Y", location.getY());
        this.set(name + ".Z", location.getZ());
        this.set(name + ".Yaw", Float.valueOf(location.getYaw()));
        this.set(name + ".Pitch", Float.valueOf(location.getPitch()));
    }

    public void setItemStack(String s, ItemStack stack) {
        this.set(s, stack.serialize());
    }

    public void setItems(String s, List<ItemStack> items) {
        this.set(s, items);
    }

    public void setInventory(String s, Inventory inv) {
        IntStream.range(0, inv.getSize()).filter(i -> inv.getContents()[i] != null).forEach(i -> this.set(s + "." + i, inv.getContents()[i]));
    }

    public void setInventory(String s, ItemStack[] inv) {
        IntStream.range(0, inv.length).filter(i -> inv[i] != null).forEach(i -> this.set(s + "." + i, inv[i]));
    }

    public void set(String s, Object s2) {
        this.config.set(s, s2);
        if (this.autoSave) {
            this.save();
        }
    }

    public void save() {
        if (this.config == null) {
            return;
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public File getFile() {
        return this.file;
    }

    @Nonnull
    public FileConfiguration getConfig() {
        return this.config;
    }

    @Nonnull
    public Set<String> getKeys() {
        return this.config.getKeys(false);
    }
}

