/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.types.color;

import com.eazyftw.ezcolors.EZColors;
import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.language.T;
import com.eazyftw.ezcolors.storage.ChatColorUser;
import com.eazyftw.ezcolors.types.RainbowType;
import com.eazyftw.ezcolors.types.color.Rainbow;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public enum ChatColor {
    DARK_RED("Dark Red", "4", true),
    GREEN("Green", "2", true),
    BLUE("Blue", "1", true),
    CYAN("Cyan", "3", true),
    PURPLE("Purple", "5", true),
    GOLD("Gold", "6", true),
    DARK_GRAY("Dark Gray", "8", true),
    RED("Red", "c", true),
    LIME("Lime", "a", true),
    LIGHT_BLUE("Light Blue", "9", true),
    BLACK("Black", "0", true),
    PINK("Pink", "d", true),
    YELLOW("Yellow", "e", true),
    GRAY("Gray", "7", true),
    AQUA("Aqua", "b", true),
    WHITE("White", "f", true),
    RAINBOW("Rainbow", "Rainbow", false),
    RAINBOW2("Rainbow2", "Rainbow2", false),
    RESET("Reset", null, false);

    private final String name;
    private final String colorCode;
    private final boolean inColorList;

    private ChatColor(String name, String colorCode, boolean inColorList) {
        this.name = name;
        this.colorCode = colorCode;
        this.inColorList = inColorList;
    }

    public String getName() {
        return this.name;
    }

    public String getColorCode() {
        return this.colorCode;
    }

    public boolean isInColorList() {
        return this.inColorList;
    }

    public String getColorCodeWithAnd() {
        return "&" + this.colorCode;
    }

    public static List<String> getColorList() {
        return Arrays.stream(ChatColor.values()).filter(ChatColor::isInColorList).map(ChatColor::getColorCodeWithAnd).collect(Collectors.toList());
    }

    public static String createRainbowChat(String s) {
        return org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)IntStream.range(0, s.length()).mapToObj(i -> ChatColor.getColorList().get(new Random().nextInt(ChatColor.getColorList().size())) + s.charAt(i)).collect(Collectors.joining()));
    }

    public static String createRainbowChatBold(String s) {
        return org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)IntStream.range(0, s.length()).mapToObj(i -> ChatColor.getColorList().get(new Random().nextInt(ChatColor.getColorList().size())) + "&l" + s.charAt(i)).collect(Collectors.joining()));
    }

    public static String createRainbowChatSpace(String s) {
        return org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)Arrays.stream(s.split(" ")).map(str -> ChatColor.getColorList().get(new Random().nextInt(ChatColor.getColorList().size())) + str + " ").collect(Collectors.joining()));
    }

    public static String createCustomChat(String s, List<String> chat) {
        StringBuilder test = new StringBuilder();
        int c = 0;
        for (int i = 0; i < s.length(); ++i) {
            test.append(chat.get(c)).append(s.charAt(i));
            if (++c <= chat.size() - 1) continue;
            c = 0;
        }
        return org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)test.toString());
    }

    public static String getColorNameFromCode(String c) {
        for (ChatColor entry : ChatColor.values()) {
            String name = entry.getName();
            String color = entry.getColorCode();
            if (color == null || !color.equalsIgnoreCase(c.replace("&", ""))) continue;
            return c + T.t("COLOR_" + name.replace(" ", "_").toUpperCase());
        }
        return "";
    }

    public static String createNiceRainbowChat(String s) {
        return ChatColor.createNiceRainbowChat(s, false, false);
    }

    public static String createNiceRainbowChat(String s, boolean bold) {
        return ChatColor.createNiceRainbowChat(s, false, bold);
    }

    public static String createNiceRainbowChatSpace(String s, boolean bold) {
        return ChatColor.createNiceRainbowChatSpace(s, false, bold);
    }

    public static String createNiceRainbowChatSpace(String s) {
        return ChatColor.createNiceRainbowChatSpace(s, false, false);
    }

    public static String createNiceRainbowChatSpace(String s, boolean caps, boolean bold) {
        StringBuilder test = new StringBuilder();
        int c = 0;
        for (String str : s.split(" ")) {
            test.append(Rainbow.all().get(c)).append(bold ? "&l" : "").append(caps ? str.toUpperCase() : str).append(" ");
            if (++c <= Rainbow.all().size() - 1) continue;
            c = 0;
        }
        return org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)test.toString());
    }

    public static String createNiceRainbowChat(String s, boolean caps, boolean bold) {
        StringBuilder test = new StringBuilder();
        int c = 0;
        for (int i = 0; i < s.length(); ++i) {
            test.append(Rainbow.all().get(c)).append(bold ? "&l" : "").append(caps ? String.valueOf(s.charAt(i)).toUpperCase() : Character.valueOf(s.charAt(i)));
            if (++c <= Rainbow.all().size() - 1) continue;
            c = 0;
        }
        return EZMessage.text(test.toString()).colored();
    }

    public static String createRainbowChatHex(String s) {
        return ChatColor.createRainbowChatHex(s, false, false);
    }

    public static String createRainbowChatHex(String s, boolean caps, boolean bold) {
        StringBuilder test = new StringBuilder();
        int c = 0;
        for (int i = 0; i < s.length(); ++i) {
            test.append(EZMessage.text(ChatColor.getRandomHex(true)).colored()).append(bold ? "&l" : "").append(caps ? String.valueOf(s.charAt(i)).toUpperCase() : Character.valueOf(s.charAt(i)));
            if (++c <= Rainbow.all().size() - 1) continue;
            c = 0;
        }
        return org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)test.toString());
    }

    public static String createRainbowChatHexSpace(String s) {
        return ChatColor.createRainbowChatHexSpace(s, false, false);
    }

    public static String createRainbowChatHexSpace(String s, boolean caps, boolean bold) {
        StringBuilder test = new StringBuilder();
        int c = 0;
        for (String str : s.split(" ")) {
            test.append(EZMessage.text(ChatColor.getRandomHex(true)).colored()).append(bold ? "&l" : "").append(caps ? str.toUpperCase() : str).append(" ");
            if (++c <= Rainbow.all().size() - 1) continue;
            c = 0;
        }
        return org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)test.toString());
    }

    public static String getChatColor(String s) {
        if (!ChatColor.isChatColor(s)) {
            Bukkit.broadcastMessage((String)s);
            return null;
        }
        String simple = s.replace(" ", "").toLowerCase();
        if (simple.equalsIgnoreCase("darkred")) {
            return "4";
        }
        if (simple.equalsIgnoreCase("darkgray")) {
            return "8";
        }
        if (simple.equalsIgnoreCase("lightblue")) {
            return "9";
        }
        if (ChatColor.getChatColorByName(ChatColor.capitalizeFirstLetter(s)) == null) {
            Bukkit.broadcastMessage((String)s);
            return null;
        }
        return ChatColor.getChatColorByName(ChatColor.capitalizeFirstLetter(s));
    }

    public static String getChatColorLower(String s) {
        return s.toLowerCase();
    }

    public static List<String> getChatColors() {
        return Arrays.stream(ChatColor.values()).map(m -> ChatColor.getChatColorLower(m.getName())).collect(Collectors.toList());
    }

    public static boolean isChatColor(String s) {
        return Arrays.stream(ChatColor.values()).anyMatch(c -> c.getName().equalsIgnoreCase(s) || c.getName().replace(" ", "_").equalsIgnoreCase(s) || c.getName().replace(" ", "").equalsIgnoreCase(s));
    }

    public static String getFormattedName(String s) {
        ChatColor chatColor = Arrays.stream(ChatColor.values()).filter(c -> c.getName().equalsIgnoreCase(s) || c.getName().replace(" ", "_").equalsIgnoreCase(s) || c.getName().replace(" ", "").equalsIgnoreCase(s)).findFirst().orElse(null);
        if (chatColor == null) {
            return null;
        }
        return chatColor.getName();
    }

    private static String capitalizeFirstLetter(String original) {
        if (original == null || original.length() == 0) {
            return original;
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1);
    }

    public static String getChatColorByName(String name) {
        ChatColor chatColor = Arrays.stream(ChatColor.values()).filter(s -> s.getName().equals(name)).findFirst().orElse(null);
        if (chatColor == null) {
            return null;
        }
        return chatColor.getColorCode();
    }

    public static String getRandomHex(boolean formatted) {
        return (formatted ? "{" : "") + String.format("#%06x", new Random().nextInt(0x1000000)) + (formatted ? "}" : "");
    }

    public static String getMessage(Player p, String msg) {
        ChatColorUser user = EZColors.getStorage().getUser(p.getUniqueId());
        if (!user.isColorSet()) {
            return msg;
        }
        if (user.getColor().startsWith("#")) {
            return EZMessage.text("{" + user.getColor() + "}").colored() + msg;
        }
        if (user.getColor().contains(";") || user.getColor().contains("&")) {
            List<String> colors = Arrays.asList(user.getColor().split(";"));
            if (colors.size() > 1) {
                return ChatColor.createCustomChat(msg, colors);
            }
            return EZMessage.text(colors.get(0)).colored() + msg;
        }
        if (user.getColor().equalsIgnoreCase("Rainbow")) {
            if (EZColors.getRainbowType() == RainbowType.NORMAL) {
                return ChatColor.createRainbowChat(msg);
            }
            return ChatColor.createRainbowChatSpace(msg);
        }
        if (user.getColor().equalsIgnoreCase("Rainbow2")) {
            if (EZColors.getRainbowType() == RainbowType.NORMAL) {
                return ChatColor.createNiceRainbowChat(msg);
            }
            return ChatColor.createNiceRainbowChatSpace(msg);
        }
        if (user.getColor().equalsIgnoreCase("Rainbow3")) {
            if (EZColors.getRainbowType() == RainbowType.NORMAL) {
                return ChatColor.createRainbowChatHex(msg);
            }
            return ChatColor.createRainbowChatHexSpace(msg);
        }
        return EZMessage.text("&" + user.getColor()).colored() + msg;
    }
}

