/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.userinput;

import com.eazyftw.ezcolors.EazyAPI;
import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.events.UpdateEvent;
import com.eazyftw.ezcolors.events.UpdateTime;
import com.eazyftw.ezcolors.userinput.UserInputReply;
import com.eazyftw.ezcolors.versions.messages.ActionBar;
import com.eazyftw.ezcolors.versions.messages.Titles;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class UserInput
implements Listener {
    private final Player p;
    private String title;
    private final String subtitle;
    private final String actionbar;
    private final UserInputReply reply;
    private boolean isClosed;
    private boolean exited;
    private boolean update;

    public UserInput(Player p, String title, String subtitle, String actionbar, UserInputReply reply) {
        this.p = p;
        this.title = title;
        this.subtitle = subtitle;
        this.actionbar = EZMessage.text(actionbar == null ? "&cShift + Left Click &7to close." : actionbar).colored();
        this.reply = reply;
        this.isClosed = false;
        this.update = true;
        Bukkit.getScheduler().runTask((Plugin)EazyAPI.getPluginAPI(), () -> ((Player)p).closeInventory());
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)EazyAPI.getPluginAPI());
    }

    public Player getPlayer() {
        return this.p;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public String getActionBar() {
        return this.actionbar;
    }

    public UserInputReply getReply() {
        return this.reply;
    }

    public void close(String reply) {
        this.isClosed = true;
        Titles.clearTitle(this.p);
        HandlerList.unregisterAll((Listener)this);
        this.reply.run(this.p, reply, this.exited);
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        if (e.getPlayer().equals(this.p)) {
            e.setCancelled(true);
            this.exited = false;
            this.close(ChatColor.stripColor((String)e.getMessage()));
        }
    }

    @EventHandler
    public void close(InventoryOpenEvent e) {
        if (e.getPlayer().equals(this.p)) {
            this.exited = true;
            this.close("");
        }
    }

    @EventHandler
    public void close(PlayerQuitEvent e) {
        if (e.getPlayer().equals(this.p)) {
            this.exited = true;
            this.close("");
        }
    }

    @EventHandler
    public void close(PlayerInteractEvent e) {
        if (e.getPlayer().isSneaking() && e.getPlayer().equals(this.p) && (e.getAction() == Action.LEFT_CLICK_AIR || e.getAction() == Action.LEFT_CLICK_BLOCK)) {
            this.exited = true;
            this.close("");
        }
    }

    @EventHandler
    public void update(UpdateEvent updateEvent) {
        if (updateEvent.getUpdateTime() != UpdateTime.TICK) {
            return;
        }
        String mainTitle = this.getTitle();
        String subTitle = this.getSubtitle();
        String actionBar = this.getActionBar();
        if (this.update || this.title == null || this.subtitle == null || !this.title.equals(mainTitle) || !this.subtitle.equals(subTitle)) {
            Titles.sendTitle(this.p, 30, 60000, 0, EZMessage.text(mainTitle).colored(), EZMessage.text(subTitle).colored());
            this.title = mainTitle;
            this.title = subTitle;
            this.update = false;
        }
        if (actionBar != null) {
            ActionBar.sendActionBarWhile(this.p, actionBar, () -> !this.isClosed);
        }
    }
}

