/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.versions;

import com.eazyftw.ezcolors.versions.SkullUtils;
import com.eazyftw.ezcolors.versions.XEnchantment;
import com.eazyftw.ezcolors.versions.XMaterial;
import com.eazyftw.ezcolors.versions.XPotion;
import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.potion.PotionEffect;

public class XItemStack {
    private static final java.util.regex.Pattern SPACE = java.util.regex.Pattern.compile("  +");

    /*
     * WARNING - void declaration
     */
    public static void serialize(ItemStack item, ConfigurationSection config) {
        ItemMeta meta = item.getItemMeta();
        if (meta.hasDisplayName()) {
            config.set("name", (Object)ChatColor.stripColor((String)meta.getDisplayName()));
        }
        if (meta.hasLore()) {
            ArrayList<String> lines = new ArrayList<String>();
            for (String lore : meta.getLore()) {
                lines.add(ChatColor.stripColor((String)lore));
            }
            config.set("lore", lines);
        }
        if (item.getAmount() > 1) {
            config.set("amount", (Object)item.getAmount());
        }
        if (XMaterial.isNewVersion()) {
            Object damageable;
            if (meta instanceof Damageable && (damageable = (Damageable)meta).hasDamage()) {
                config.set("damage", (Object)damageable.getDamage());
            }
        } else if (XMaterial.isDamageable(item.getType().name())) {
            config.set("damage", (Object)item.getDurability());
        }
        config.set("material", (Object)item.getType().name());
        if (meta.hasCustomModelData()) {
            config.set("custom-model", (Object)meta.getCustomModelData());
        }
        if (meta.isUnbreakable()) {
            config.set("unbreakable", (Object)true);
        }
        for (Map.Entry entry : meta.getEnchants().entrySet()) {
            String entry2 = "enchants." + XEnchantment.matchXEnchantment((Enchantment)entry.getKey()).name();
            config.set(entry2, entry.getValue());
        }
        if (meta.getItemFlags().size() != 0) {
            ArrayList flags = new ArrayList();
            for (ItemFlag flag : meta.getItemFlags()) {
                flags.add(flag.name());
            }
            config.set("flags", (Object)flags);
        }
        if (XMaterial.supports(9) && meta.hasAttributeModifiers()) {
            for (Map.Entry entry : meta.getAttributeModifiers().entries()) {
                String path = "attributes." + ((Attribute)entry.getKey()).name() + '.';
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                config.set(path + "id", (Object)modifier.getUniqueId().toString());
                config.set(path + "name", (Object)modifier.getName());
                config.set(path + "amount", (Object)modifier.getAmount());
                config.set(path + "operation", (Object)modifier.getOperation().name());
                config.set(path + "slot", (Object)modifier.getSlot().name());
            }
        }
        if (meta instanceof SkullMeta) {
            config.set("skull", (Object)((SkullMeta)meta).getOwningPlayer().getUniqueId());
        } else if (meta instanceof BannerMeta) {
            BannerMeta banner = (BannerMeta)meta;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Pattern pattern : banner.getPatterns()) {
                arrayList.add(pattern.getColor() + " " + pattern.getPattern().getIdentifier());
            }
            config.set("patterns", arrayList);
        } else if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leather = (LeatherArmorMeta)meta;
            Color color = leather.getColor();
            config.set("color", (Object)(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue()));
        } else if (meta instanceof PotionMeta) {
            PotionMeta potion = (PotionMeta)meta;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PotionEffect effect : potion.getCustomEffects()) {
                arrayList.add(effect.getType().getName() + ' ' + effect.getDuration() + ' ' + effect.getAmplifier());
            }
            config.set("effects", arrayList);
        } else if (meta instanceof FireworkMeta) {
            FireworkMeta firework = (FireworkMeta)meta;
            config.set("power", (Object)firework.getPower());
            boolean bl = false;
            for (FireworkEffect fw : firework.getEffects()) {
                void var4_15;
                config.set("type." + (int)var4_15, (Object)fw.getType().name());
                ArrayList<String> colors = new ArrayList<String>();
                for (Color color : fw.getColors()) {
                    colors.add(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
                }
                config.set("colors." + (int)var4_15, colors);
                colors.clear();
                for (Color color : fw.getFadeColors()) {
                    colors.add(color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
                }
                config.set("fade-colors." + (int)var4_15, colors);
                ++var4_15;
            }
        } else if (XMaterial.supports(14)) {
            if (meta instanceof CrossbowMeta) {
                CrossbowMeta crossbow = (CrossbowMeta)meta;
                boolean bl = false;
                for (ItemStack projectiles : crossbow.getChargedProjectiles()) {
                    void var4_17;
                    XItemStack.serialize(projectiles, config.getConfigurationSection("projectiles." + (int)var4_17));
                    ++var4_17;
                }
            } else if (meta instanceof TropicalFishBucketMeta) {
                TropicalFishBucketMeta tropical = (TropicalFishBucketMeta)meta;
                config.set("pattern", (Object)tropical.getPattern().name());
                config.set("color", (Object)tropical.getBodyColor().name());
                config.set("pattern-color", (Object)tropical.getPatternColor().name());
            } else if (meta instanceof SuspiciousStewMeta) {
                SuspiciousStewMeta stew = (SuspiciousStewMeta)meta;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (PotionEffect effect : stew.getCustomEffects()) {
                    arrayList.add(effect.getType().getName() + ' ' + effect.getDuration() + ' ' + effect.getAmplifier());
                }
                config.set("effects", arrayList);
            }
        }
    }

    public static ItemStack deserialize(ConfigurationSection config) {
        ConfigurationSection attributes;
        List lores;
        int modelData;
        PotionEffect effect;
        int damage;
        String material = config.getString("material");
        if (material == null) {
            return null;
        }
        Optional<XMaterial> matOpt = XMaterial.matchXMaterial(material);
        if (!matOpt.isPresent()) {
            return null;
        }
        ItemStack item = matOpt.get().parseItem();
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        int amount = config.getInt("amount");
        if (amount > 1) {
            item.setAmount(amount);
        }
        if (XMaterial.isNewVersion()) {
            if (meta instanceof Damageable && (damage = config.getInt("damage")) > 0) {
                ((Damageable)meta).setDamage(damage);
            }
        } else {
            damage = config.getInt("damage");
            if (damage > 0) {
                item.setDurability((short)damage);
            }
        }
        if (item.getType() == XMaterial.PLAYER_HEAD.parseMaterial()) {
            String skull = config.getString("skull");
            if (skull != null) {
                SkullUtils.applySkin(meta, skull);
            }
        } else if (meta instanceof BannerMeta) {
            BannerMeta banner = (BannerMeta)meta;
            for (String pattern : config.getStringList("patterns")) {
                PatternType type;
                String[] split = SPACE.split(pattern);
                if (split.length == 0) continue;
                DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)split[0]).or((Object)DyeColor.WHITE);
                if (split.length > 1) {
                    type = PatternType.getByIdentifier((String)split[1]);
                    if (type == null) {
                        type = (PatternType)Enums.getIfPresent(PatternType.class, (String)split[1]).or((Object)PatternType.BASE);
                    }
                } else {
                    type = PatternType.BASE;
                }
                banner.addPattern(new Pattern(color, type));
            }
        } else if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leather = (LeatherArmorMeta)meta;
            String colorStr = config.getString("color");
            if (colorStr != null) {
                leather.setColor(XItemStack.parseColor(colorStr));
            }
        } else if (meta instanceof PotionMeta) {
            PotionMeta potion = (PotionMeta)meta;
            for (String effects : config.getStringList("effects")) {
                effect = XPotion.parsePotionEffectFromString(effects);
                potion.addCustomEffect(effect, true);
            }
        } else if (meta instanceof BlockStateMeta) {
            BlockStateMeta bsm = (BlockStateMeta)meta;
            BlockState state = bsm.getBlockState();
            CreatureSpawner spawner = (CreatureSpawner)state;
            spawner.setSpawnedType((EntityType)Enums.getIfPresent(EntityType.class, (String)config.getString("spawner")).orNull());
            bsm.setBlockState((BlockState)spawner);
        } else if (meta instanceof FireworkMeta) {
            FireworkMeta firework = (FireworkMeta)meta;
            FireworkEffect.Builder builder = FireworkEffect.builder();
            for (String fws : config.getConfigurationSection("fireworks").getKeys(false)) {
                ConfigurationSection fw = config.getConfigurationSection("firework." + fws);
                firework.setPower(fw.getInt("power"));
                builder.flicker(fw.getBoolean("flicker"));
                builder.trail(fw.getBoolean("trail"));
                builder.with((FireworkEffect.Type)Enums.getIfPresent(FireworkEffect.Type.class, (String)fw.getString("type")).or((Object)FireworkEffect.Type.STAR));
                ArrayList<Color> colors = new ArrayList<Color>();
                for (String colorStr : fw.getStringList("colors")) {
                    colors.add(XItemStack.parseColor(colorStr));
                }
                builder.withColor(colors);
                colors.clear();
                for (String colorStr : fw.getStringList("fade-colors")) {
                    colors.add(XItemStack.parseColor(colorStr));
                }
                builder.withFade(colors);
                firework.addEffect(builder.build());
            }
        } else if (XMaterial.supports(14)) {
            if (meta instanceof CrossbowMeta) {
                CrossbowMeta crossbow = (CrossbowMeta)meta;
                for (String projectiles : config.getConfigurationSection("projectiles").getKeys(false)) {
                    ItemStack projectile = XItemStack.deserialize(config.getConfigurationSection("projectiles." + projectiles));
                    crossbow.addChargedProjectile(projectile);
                }
            } else if (meta instanceof TropicalFishBucketMeta) {
                TropicalFishBucketMeta tropical = (TropicalFishBucketMeta)meta;
                DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("color")).or((Object)DyeColor.WHITE);
                DyeColor patternColor = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("pattern-color")).or((Object)DyeColor.WHITE);
                TropicalFish.Pattern pattern = (TropicalFish.Pattern)Enums.getIfPresent(TropicalFish.Pattern.class, (String)config.getString("pattern")).or((Object)TropicalFish.Pattern.BETTY);
                tropical.setBodyColor(color);
                tropical.setPatternColor(patternColor);
                tropical.setPattern(pattern);
            }
        } else if (XMaterial.supports(15) && meta instanceof SuspiciousStewMeta) {
            SuspiciousStewMeta stew = (SuspiciousStewMeta)meta;
            for (String effects : config.getStringList("effects")) {
                effect = XPotion.parsePotionEffectFromString(effects);
                stew.addCustomEffect(effect, true);
            }
        }
        String name = config.getString("name");
        if (name != null) {
            if (name.isEmpty()) {
                name = " ";
            }
            String translated = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
            meta.setDisplayName(translated);
        }
        if (XMaterial.supports(11)) {
            meta.setUnbreakable(config.getBoolean("unbreakable"));
        }
        if (XMaterial.supports(14) && (modelData = config.getInt("model-data")) != 0) {
            meta.setCustomModelData(Integer.valueOf(modelData));
        }
        if (!(lores = config.getStringList("lore")).isEmpty()) {
            ArrayList<String> translatedLore = new ArrayList<String>();
            String lastColors = "";
            for (String[] lore : lores) {
                if (lore.isEmpty()) {
                    translatedLore.add(" ");
                    continue;
                }
                for (String singleLore : StringUtils.splitPreserveAllTokens((String)lore, (char)'\n')) {
                    if (singleLore.isEmpty()) {
                        translatedLore.add(" ");
                        continue;
                    }
                    singleLore = lastColors + ChatColor.translateAlternateColorCodes((char)'&', (String)singleLore);
                    translatedLore.add(singleLore);
                    lastColors = ChatColor.getLastColors((String)singleLore);
                }
            }
            meta.setLore(translatedLore);
        } else {
            String lore = config.getString("lore");
            if (!Strings.isNullOrEmpty((String)lore)) {
                ArrayList translatedLore = new ArrayList();
                String lastColors = "";
                for (String singleLore : StringUtils.splitPreserveAllTokens((String)lore, (char)'\n')) {
                    if (singleLore.isEmpty()) {
                        translatedLore.add(" ");
                        continue;
                    }
                    singleLore = lastColors + ChatColor.translateAlternateColorCodes((char)'&', (String)singleLore);
                    translatedLore.add(singleLore);
                    lastColors = ChatColor.getLastColors((String)singleLore);
                }
                meta.setLore((List)translatedLore);
            }
        }
        ConfigurationSection enchants = config.getConfigurationSection("enchants");
        if (enchants != null) {
            for (Object ench : enchants.getKeys(false)) {
                Optional<XEnchantment> enchant = XEnchantment.matchXEnchantment((String)ench);
                enchant.ifPresent(arg_0 -> XItemStack.lambda$deserialize$0(meta, enchants, (String)ench, arg_0));
            }
        }
        List flags = config.getStringList("flags");
        for (String flag : flags) {
            if (flag.equalsIgnoreCase("all")) {
                meta.addItemFlags(ItemFlag.values());
                break;
            }
            ItemFlag itemFlag = ItemFlag.valueOf((String)flag.toUpperCase());
            meta.addItemFlags(new ItemFlag[]{itemFlag});
        }
        if (XMaterial.supports(9) && (attributes = config.getConfigurationSection("attributes")) != null) {
            for (String attribute : attributes.getKeys(false)) {
                String attribId = attributes.getString("id");
                UUID id = attribId != null ? UUID.fromString(attribId) : UUID.randomUUID();
                AttributeModifier modifier = new AttributeModifier(id, attributes.getString("name"), (double)attributes.getInt("amount"), (AttributeModifier.Operation)Enums.getIfPresent(AttributeModifier.Operation.class, (String)attributes.getString("operation")).or((Object)AttributeModifier.Operation.ADD_NUMBER), (EquipmentSlot)Enums.getIfPresent(EquipmentSlot.class, (String)attributes.getString("slot")).or((Object)EquipmentSlot.HAND));
                meta.addAttributeModifier(Attribute.valueOf((String)attribute), modifier);
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    public static Color parseColor(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return Color.BLACK;
        }
        String[] rgb = StringUtils.split((String)StringUtils.deleteWhitespace((String)str), (char)',');
        return Color.fromRGB((int)NumberUtils.toInt((String)rgb[0], (int)0), (int)NumberUtils.toInt((String)rgb[1], (int)0), (int)NumberUtils.toInt((String)rgb[1], (int)0));
    }

    private static /* synthetic */ void lambda$deserialize$0(ItemMeta meta, ConfigurationSection enchants, String ench, XEnchantment xEnchantment) {
        meta.addEnchant(xEnchantment.parseEnchantment(), enchants.getInt(ench), true);
    }
}

