/*
 * Decompiled with CFR 0.152.
 */
package me.leoo.bedwars.rewardsummary;

import java.util.List;
import me.leoo.bedwars.rewardsummary.configuration.Config;
import me.leoo.bedwars.rewardsummary.configuration.ConfigManager;
import me.leoo.bedwars.rewardsummary.listeners.GameEnd;
import me.leoo.bedwars.rewardsummary.listeners.GameStart;
import me.leoo.bedwars.rewardsummary.listeners.LevelUp;
import me.leoo.bedwars.rewardsummary.utils.SummaryUtils;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private static Main plugin;
    private ConfigManager mainConfig;
    private Economy economy;
    private final SummaryUtils utils = new SummaryUtils();

    public void onEnable() {
        plugin = this;
        if (!Bukkit.getPluginManager().isPluginEnabled("BedWars1058")) {
            this.getLogger().severe("BedWars1058 was not found. Disabling...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            this.getLogger().severe("Vault was not found. Disabling...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.vaultHook();
        this.mainConfig = new Config((Plugin)this, "config", this.getDataFolder().getPath());
        this.registerEvents();
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aBedWars1058 Reward Summary addon has been successfully enabled."));
    }

    public void onDisable() {
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cBedWars1058 Reward Summary addon has been successfully disabled."));
    }

    private void registerEvents() {
        List.of(new GameStart(), new GameEnd(), new LevelUp()).forEach(listener -> Bukkit.getPluginManager().registerEvents(listener, (Plugin)this));
    }

    private void vaultHook() {
        RegisteredServiceProvider provider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (provider == null) {
            return;
        }
        this.economy = (Economy)provider.getProvider();
    }

    public ConfigManager getMainConfig() {
        return this.mainConfig;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public SummaryUtils getUtils() {
        return this.utils;
    }

    public static Main getPlugin() {
        return plugin;
    }
}

