/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.utilities.Config;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.configuration.file.YamlConfiguration;

public class OCMConfigHandler {
    private final String CONFIG_NAME = "config.yml";
    private final OCMMain plugin;

    public OCMConfigHandler(OCMMain instance) {
        this.plugin = instance;
    }

    public void upgradeConfig() {
        File backup = this.getFile("config-backup.yml");
        if (backup.exists()) {
            backup.delete();
        }
        if (Reflector.versionIsNewerOrEqualAs(1, 18, 1) || Config.getConfig().getBoolean("force-below-1-18-1-config-upgrade", false)) {
            this.plugin.getLogger().warning("Config version does not match, upgrading old config");
            YamlConfiguration oldConfig = this.getConfig("config.yml");
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Objects.requireNonNull(this.plugin.getResource("config.yml"))));
            for (String key : defaultConfig.getKeys(true)) {
                if (key.equals("config-version") || !oldConfig.contains(key) || defaultConfig.isConfigurationSection(key)) continue;
                defaultConfig.set(key, oldConfig.get(key));
            }
            try {
                defaultConfig.save(this.getFile("config.yml"));
                this.plugin.getLogger().info("Config has been updated");
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to upgrade config");
            }
        } else {
            this.plugin.getLogger().warning("Config version does not match, backing up old config and creating a new one");
            File configFile = this.getFile("config.yml");
            configFile.renameTo(backup);
        }
        this.setupConfigIfNotPresent();
    }

    public void setupConfigIfNotPresent() {
        if (!this.doesConfigExist()) {
            this.plugin.saveDefaultConfig();
            this.plugin.getLogger().info("Config file generated");
        }
    }

    public YamlConfiguration getConfig(String fileName) {
        return YamlConfiguration.loadConfiguration((File)this.getFile(fileName));
    }

    public File getFile(String fileName) {
        return new File(this.plugin.getDataFolder(), fileName.replace('/', File.separatorChar));
    }

    public boolean doesConfigExist() {
        return this.getFile("config.yml").exists();
    }
}

