/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics;

import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.updater.SpigetUpdateChecker;
import kernitus.plugin.OldCombatMechanics.utilities.Config;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.Reflector;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class UpdateChecker {
    private final SpigetUpdateChecker updater = new SpigetUpdateChecker();
    private final boolean autoDownload;
    private final OCMMain plugin;

    public UpdateChecker(OCMMain plugin) {
        this.plugin = plugin;
        this.autoDownload = Config.moduleSettingEnabled("update-checker", "auto-update") && (Reflector.versionIsNewerOrEqualAs(1, 18, 1) || Config.getConfig().getBoolean("force-below-1-18-1-config-upgrade", false));
    }

    public void performUpdate() {
        this.performUpdate(null);
    }

    public void performUpdate(@Nullable Player player) {
        if (player != null) {
            this.update(arg_0 -> ((Player)player).sendMessage(arg_0));
        } else {
            this.update(x$0 -> Messenger.info(x$0, new Object[0]));
        }
    }

    private void update(Consumer<String> target) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.updater.isUpdateAvailable()) {
            messages.add(ChatColor.BLUE + "An update for OldCombatMechanics to version " + this.updater.getLatestVersion() + " is available!");
            if (!this.autoDownload) {
                messages.add(ChatColor.BLUE + "Click here to download it: " + ChatColor.GRAY + this.updater.getUpdateURL());
            } else {
                messages.add(ChatColor.BLUE + "Downloading update: " + ChatColor.GRAY + this.updater.getUpdateURL());
                try {
                    if (!this.updater.downloadLatestVersion(this.plugin.getServer().getUpdateFolderFile(), this.plugin.getFile().getName())) {
                        throw new RuntimeException();
                    }
                    messages.add(ChatColor.GREEN + "Update downloaded. Restart or reload server to enable new version.");
                }
                catch (Exception e) {
                    messages.add(ChatColor.RED + "Error occurred while downloading update! Check console for more details");
                    e.printStackTrace();
                }
            }
        }
        messages.forEach(target);
    }
}

