/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.commands;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.ModuleAttackCooldown;
import kernitus.plugin.OldCombatMechanics.utilities.Config;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;

public class OCMCommandHandler
implements CommandExecutor {
    private static final String NO_PERMISSION = "&cYou need the permission '%s' to do that!";
    private final OCMMain plugin;
    private final File pluginFile;

    public OCMCommandHandler(OCMMain instance, File pluginFile) {
        this.plugin = instance;
        this.pluginFile = pluginFile;
    }

    private void help(OCMMain plugin, CommandSender sender) {
        PluginDescriptionFile description = plugin.getDescription();
        Messenger.send(sender, ChatColor.DARK_GRAY + Messenger.HORIZONTAL_BAR, new Object[0]);
        Messenger.send(sender, "&6&lOldCombatMechanics&e by &ckernitus&e and &cRayzr522&e version &6%s", description.getVersion());
        if (OCMCommandHandler.checkPermissions(sender, Subcommand.reload)) {
            Messenger.send(sender, "&eYou can use &c/ocm reload&e to reload the config file", new Object[0]);
        }
        if (OCMCommandHandler.checkPermissions(sender, Subcommand.toggle)) {
            Messenger.send(sender, "&eYou can use &c/ocm toggle [player] [on/off] &e to turn attack cooldown on/off", new Object[0]);
        }
        if (OCMCommandHandler.checkPermissions(sender, Subcommand.enable) || OCMCommandHandler.checkPermissions(sender, Subcommand.disable)) {
            Messenger.send(sender, "&eYou can use &c/ocm <enable/disable> [world] &e to toggle cooldown for the server or world", new Object[0]);
        }
        Messenger.send(sender, ChatColor.DARK_GRAY + Messenger.HORIZONTAL_BAR, new Object[0]);
    }

    private void reload(CommandSender sender) {
        Config.reload();
        Messenger.send(sender, "&6&lOldCombatMechanics&e config file reloaded", new Object[0]);
    }

    private void toggle(OCMMain plugin, CommandSender sender, String[] args) {
        FileConfiguration config = plugin.getConfig();
        Player player = null;
        ModuleAttackCooldown.PVPMode mode = null;
        if (args.length >= 2) {
            player = Bukkit.getPlayer((String)args[1]);
            if (args.length >= 3) {
                if (args[2].equalsIgnoreCase("on")) {
                    mode = ModuleAttackCooldown.PVPMode.NEW_PVP;
                } else if (args[2].equalsIgnoreCase("off")) {
                    mode = ModuleAttackCooldown.PVPMode.OLD_PVP;
                }
            }
        }
        if (player == null && sender instanceof Player) {
            player = (Player)sender;
        }
        if (player == null) {
            String message = config.getString("disable-attack-cooldown.message-usage", "&4ERROR: &rdisable-attack-cooldown.message-usage string missing");
            Messenger.sendNormalMessage(sender, message, new Object[0]);
            return;
        }
        if (mode == null) {
            ModuleAttackCooldown.PVPMode oldMode = ModuleAttackCooldown.PVPMode.getModeForPlayer(player);
            mode = oldMode == ModuleAttackCooldown.PVPMode.NEW_PVP ? ModuleAttackCooldown.PVPMode.OLD_PVP : ModuleAttackCooldown.PVPMode.NEW_PVP;
        }
        String message = config.getString("disable-attack-cooldown.message-" + (mode == ModuleAttackCooldown.PVPMode.NEW_PVP ? "enabled" : "disabled"), "&4ERROR: &rdisable-attack-cooldown.message strings missing").replaceAll("%player%", player.getDisplayName());
        ModuleAttackCooldown.setAttackSpeed(player, mode);
        Messenger.sendNormalMessage(sender, message, new Object[0]);
    }

    private void wideToggle(CommandSender sender, String[] args, ModuleAttackCooldown.PVPMode mode) {
        HashSet worlds = args.length > 1 ? Arrays.asList(args).subList(1, args.length).stream().map(Bukkit::getWorld).filter(Objects::nonNull).collect(Collectors.toSet()) : new HashSet(Bukkit.getWorlds());
        worlds.stream().map(World::getPlayers).forEach(players -> players.forEach(player -> ModuleAttackCooldown.setAttackSpeed(player, mode)));
        String message = (mode == ModuleAttackCooldown.PVPMode.NEW_PVP ? "Enabled" : "Disabled") + " cooldown for worlds: " + worlds.stream().map(w -> w.getName()).reduce((a, b) -> a + ", " + b).orElse("none!");
        Messenger.sendNormalMessage(sender, message, new Object[0]);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (args.length < 1) {
            this.help(this.plugin, sender);
        } else {
            try {
                try {
                    Subcommand subcommand = Subcommand.valueOf(args[0].toLowerCase(Locale.ROOT));
                    if (OCMCommandHandler.checkPermissions(sender, subcommand, true)) {
                        switch (subcommand) {
                            case reload: {
                                this.reload(sender);
                                break;
                            }
                            case toggle: {
                                this.toggle(this.plugin, sender, args);
                                break;
                            }
                            case enable: {
                                this.wideToggle(sender, args, ModuleAttackCooldown.PVPMode.NEW_PVP);
                                break;
                            }
                            case disable: {
                                this.wideToggle(sender, args, ModuleAttackCooldown.PVPMode.OLD_PVP);
                                break;
                            }
                            default: {
                                throw new CommandNotRecognisedException();
                            }
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new CommandNotRecognisedException();
                }
            }
            catch (CommandNotRecognisedException e) {
                Messenger.sendNormalMessage(sender, "Subcommand not recognised!", new Object[0]);
            }
        }
        return true;
    }

    static boolean checkPermissions(CommandSender sender, Subcommand subcommand) {
        return OCMCommandHandler.checkPermissions(sender, subcommand, false);
    }

    static boolean checkPermissions(CommandSender sender, Subcommand subcommand, boolean sendMessage) {
        boolean hasPermission = sender.hasPermission("oldcombatmechanics." + (Object)((Object)subcommand));
        if (sendMessage && !hasPermission) {
            Messenger.send(sender, NO_PERMISSION, "oldcombatmechanics." + (Object)((Object)subcommand));
        }
        return hasPermission;
    }

    private static class CommandNotRecognisedException
    extends IllegalArgumentException {
        private CommandNotRecognisedException() {
        }
    }

    static enum Subcommand {
        reload,
        toggle,
        enable,
        disable;

    }
}

