/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.concurrent.ThreadLocalRandom;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ModuleChorusFruit
extends OCMModule {
    public ModuleChorusFruit(OCMMain plugin) {
        super(plugin, "chorus-fruit");
    }

    @EventHandler
    public void onEat(PlayerItemConsumeEvent e) {
        if (e.getItem().getType() != Material.CHORUS_FRUIT) {
            return;
        }
        final Player player = e.getPlayer();
        if (!this.isEnabled(player.getWorld())) {
            return;
        }
        if (this.module().getBoolean("prevent-eating")) {
            e.setCancelled(true);
            return;
        }
        final int hungerValue = this.module().getInt("hunger-value");
        final double saturationValue = this.module().getDouble("saturation-value");
        final int previousFoodLevel = player.getFoodLevel();
        final float previousSaturation = player.getSaturation();
        new BukkitRunnable(){

            public void run() {
                int newFoodLevel = Math.min(hungerValue + previousFoodLevel, 20);
                float newSaturation = Math.min((float)(saturationValue + (double)previousSaturation), (float)newFoodLevel);
                player.setFoodLevel(newFoodLevel);
                player.setSaturation(newSaturation);
                ModuleChorusFruit.this.debug("Food level changed from: " + previousFoodLevel + " to " + player.getFoodLevel(), (CommandSender)player);
            }
        }.runTaskLater((Plugin)this.plugin, 2L);
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent e) {
        if (e.getCause() != PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT) {
            return;
        }
        Player player = e.getPlayer();
        if (!this.isEnabled(player.getWorld())) {
            return;
        }
        double distance = this.getMaxTeleportationDistance();
        if (distance == 8.0) {
            this.debug("Using vanilla teleport implementation!", (CommandSender)player);
            return;
        }
        if (distance <= 0.0) {
            this.debug("Chorus teleportation is not allowed", (CommandSender)player);
            e.setCancelled(true);
            return;
        }
        Location toLocation = e.getTo();
        if (toLocation == null) {
            this.debug("Teleport target is null", (CommandSender)player);
            return;
        }
        int maxheight = toLocation.getWorld().getMaxHeight();
        e.setTo(player.getLocation().add(ThreadLocalRandom.current().nextDouble(-distance, distance), this.clamp(ThreadLocalRandom.current().nextDouble(-distance, distance), 0.0, maxheight - 1), ThreadLocalRandom.current().nextDouble(-distance, distance)));
    }

    private double clamp(double x, double min, double max) {
        return Math.max(Math.min(x, max), min);
    }

    private double getMaxTeleportationDistance() {
        return this.module().getDouble("max-teleportation-distance");
    }
}

