/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.ConfigUtils;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ModuleDisableOffHand
extends OCMModule {
    private static final int OFFHAND_SLOT = 40;
    private List<Material> materials = new ArrayList<Material>();

    public ModuleDisableOffHand(OCMMain plugin) {
        super(plugin, "disable-offhand");
    }

    @Override
    public void reload() {
        this.materials = ConfigUtils.loadMaterialList(this.module(), "items");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSwapHandItems(PlayerSwapHandItemsEvent e) {
        if (this.isEnabled(e.getPlayer().getWorld()) && this.shouldWeCancel(e.getOffHandItem())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent e) {
        if (!this.isEnabled(e.getWhoClicked().getWorld())) {
            return;
        }
        ClickType clickType = e.getClick();
        try {
            if (clickType == ClickType.SWAP_OFFHAND) {
                e.setResult(Event.Result.DENY);
                return;
            }
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        Inventory clickedInventory = e.getClickedInventory();
        if (clickedInventory == null) {
            return;
        }
        InventoryType inventoryType = clickedInventory.getType();
        if (inventoryType != InventoryType.PLAYER) {
            return;
        }
        ItemStack currentItem = e.getCurrentItem();
        if (currentItem != null && currentItem.getType() == Material.SHIELD && this.shouldWeCancel(currentItem) && e.getSlot() != 40 && e.isShiftClick()) {
            e.setResult(Event.Result.DENY);
        }
        if (e.getSlot() == 40 && (clickType == ClickType.NUMBER_KEY && this.shouldWeCancel(clickedInventory.getItem(e.getHotbarButton())) || this.shouldWeCancel(e.getCursor()))) {
            e.setResult(Event.Result.DENY);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryDrag(InventoryDragEvent e) {
        if (!this.isEnabled(e.getWhoClicked().getWorld()) || e.getInventory().getType() != InventoryType.CRAFTING || !e.getInventorySlots().contains(40)) {
            return;
        }
        if (this.shouldWeCancel(e.getOldCursor())) {
            e.setResult(Event.Result.DENY);
        }
    }

    private boolean shouldWeCancel(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        return !this.getBlockType().isAllowed(this.materials, item.getType());
    }

    private BlockType getBlockType() {
        return this.module().getBoolean("whitelist") ? BlockType.WHITELIST : BlockType.BLACKLIST;
    }

    private static <T, U> BiPredicate<T, U> not(BiPredicate<T, U> predicate) {
        return predicate.negate();
    }

    static /* synthetic */ BiPredicate access$000(BiPredicate x0) {
        return ModuleDisableOffHand.not(x0);
    }

    private static enum BlockType {
        WHITELIST(Collection::contains),
        BLACKLIST(ModuleDisableOffHand.access$000(Collection::contains));

        private BiPredicate<Collection<Material>, Material> filter;

        private BlockType(BiPredicate<Collection<Material>, Material> filter) {
            this.filter = filter;
        }

        boolean isAllowed(Collection<Material> list, Material toCheck) {
            return this.filter.test(list, toCheck);
        }
    }
}

