/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.reflection.SpigotFunctionChooser;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.util.Vector;

public class ModuleFishingKnockback
extends OCMModule {
    private final SpigotFunctionChooser<PlayerFishEvent, Object, Entity> getHookFunction;
    private final SpigotFunctionChooser<ProjectileHitEvent, Object, Entity> getHitEntityFunction;
    private boolean knockbackNonPlayerEntities;

    public ModuleFishingKnockback(OCMMain plugin) {
        super(plugin, "old-fishing-knockback");
        this.reload();
        this.getHookFunction = SpigotFunctionChooser.apiCompatReflectionCall((e, params) -> e.getHook(), PlayerFishEvent.class, "getHook", new String[0]);
        this.getHitEntityFunction = SpigotFunctionChooser.apiCompatCall((e, params) -> e.getHitEntity(), (e, params) -> {
            Projectile hookEntity = e.getEntity();
            World world = hookEntity.getWorld();
            return world.getNearbyEntities(hookEntity.getLocation(), 0.25, 0.25, 0.25).stream().filter(entity -> !this.knockbackNonPlayerEntities && entity instanceof Player).findFirst().orElse(null);
        });
    }

    @Override
    public void reload() {
        this.knockbackNonPlayerEntities = this.isSettingEnabled("knockbackNonPlayerEntities");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onRodLand(ProjectileHitEvent e) {
        LivingEntity livingEntity;
        Projectile hookEntity = e.getEntity();
        World world = hookEntity.getWorld();
        if (!this.isEnabled(world)) {
            return;
        }
        if (e.getEntityType() != EntityType.FISHING_HOOK) {
            return;
        }
        Entity hitEntity = this.getHitEntityFunction.apply(e);
        if (hitEntity == null) {
            return;
        }
        if (!(hitEntity instanceof LivingEntity)) {
            return;
        }
        if (!this.knockbackNonPlayerEntities && !(hitEntity instanceof Player)) {
            return;
        }
        if (hitEntity.hasMetadata("NPC")) {
            return;
        }
        FishHook hook = (FishHook)hookEntity;
        Player rodder = (Player)hook.getShooter();
        if (!this.knockbackNonPlayerEntities) {
            Player player = (Player)hitEntity;
            this.debug("You were hit by a fishing rod!", (CommandSender)player);
            if (player.equals(rodder)) {
                return;
            }
            if (player.getGameMode() == GameMode.CREATIVE) {
                return;
            }
        }
        if ((float)(livingEntity = (LivingEntity)hitEntity).getNoDamageTicks() > (float)livingEntity.getMaximumNoDamageTicks() / 2.0f) {
            return;
        }
        double damage = this.module().getDouble("damage");
        if (damage < 0.0) {
            damage = 0.2;
        }
        EntityDamageEvent event = this.makeEvent(rodder, hitEntity, damage);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (this.module().getBoolean("checkCancelled") && event.isCancelled()) {
            this.debug("You can't do that here!", (CommandSender)rodder);
            return;
        }
        livingEntity.damage(damage);
        livingEntity.setVelocity(this.calculateKnockbackVelocity(livingEntity.getVelocity(), livingEntity.getLocation(), hook.getLocation()));
    }

    private Vector calculateKnockbackVelocity(Vector currentVelocity, Location player, Location hook) {
        double xDistance = hook.getX() - player.getX();
        double zDistance = hook.getZ() - player.getZ();
        while (xDistance * xDistance + zDistance * zDistance < 1.0E-4) {
            xDistance = (Math.random() - Math.random()) * 0.01;
            zDistance = (Math.random() - Math.random()) * 0.01;
        }
        double distance = Math.sqrt(xDistance * xDistance + zDistance * zDistance);
        double y = currentVelocity.getY() / 2.0;
        double x = currentVelocity.getX() / 2.0;
        double z = currentVelocity.getZ() / 2.0;
        x -= xDistance / distance * 0.4;
        y += 0.4;
        z -= zDistance / distance * 0.4;
        if (y >= 0.4) {
            y = 0.4;
        }
        return new Vector(x, y, z);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    private void onReelIn(PlayerFishEvent e) {
        if (e.getState() != PlayerFishEvent.State.CAUGHT_ENTITY) {
            return;
        }
        String cancelDraggingIn = this.module().getString("cancelDraggingIn", "players");
        boolean isPlayer = e.getCaught() instanceof HumanEntity;
        if (cancelDraggingIn.equals("players") && isPlayer || cancelDraggingIn.equals("mobs") && !isPlayer || cancelDraggingIn.equals("all")) {
            this.getHookFunction.apply(e).remove();
            e.setCancelled(true);
        }
    }

    private EntityDamageEvent makeEvent(Player rodder, Entity entity, double damage) {
        if (this.module().getBoolean("useEntityDamageEvent")) {
            return new EntityDamageEvent(entity, EntityDamageEvent.DamageCause.PROJECTILE, new EnumMap(ImmutableMap.of((Object)EntityDamageEvent.DamageModifier.BASE, (Object)damage)), new EnumMap(ImmutableMap.of((Object)EntityDamageEvent.DamageModifier.BASE, (Object)Functions.constant((Object)damage))));
        }
        return new EntityDamageByEntityEvent((Entity)rodder, entity, EntityDamageEvent.DamageCause.PROJECTILE, new EnumMap(ImmutableMap.of((Object)EntityDamageEvent.DamageModifier.BASE, (Object)damage)), new EnumMap(ImmutableMap.of((Object)EntityDamageEvent.DamageModifier.BASE, (Object)Functions.constant((Object)damage))));
    }
}

