/*
 * Decompiled with CFR 0.152.
 */
package kernitus.plugin.OldCombatMechanics.module;

import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import kernitus.plugin.OldCombatMechanics.OCMMain;
import kernitus.plugin.OldCombatMechanics.module.OCMModule;
import kernitus.plugin.OldCombatMechanics.utilities.Messenger;
import kernitus.plugin.OldCombatMechanics.versions.materials.MaterialRegistry;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ModuleGoldenApple
extends OCMModule {
    private static final Set<PotionEffectType> gappleEffects = ImmutableSet.of((Object)PotionEffectType.ABSORPTION, (Object)PotionEffectType.REGENERATION);
    private static final Set<PotionEffectType> nappleEffects = ImmutableSet.of((Object)PotionEffectType.ABSORPTION, (Object)PotionEffectType.REGENERATION, (Object)PotionEffectType.FIRE_RESISTANCE, (Object)PotionEffectType.DAMAGE_RESISTANCE);
    private List<PotionEffect> enchantedGoldenAppleEffects;
    private List<PotionEffect> goldenAppleEffects;
    private ShapedRecipe enchantedAppleRecipe;
    private Map<UUID, LastEaten> lastEaten;
    private Cooldown cooldown;
    private String normalCooldownMessage;
    private String enchantedCooldownMessage;

    public ModuleGoldenApple(OCMMain plugin) {
        super(plugin, "old-golden-apples");
    }

    @Override
    public void reload() {
        this.normalCooldownMessage = this.module().getString("cooldown.message-normal");
        this.enchantedCooldownMessage = this.module().getString("cooldown.message-enchanted");
        this.cooldown = new Cooldown(this.module().getLong("cooldown.normal"), this.module().getLong("cooldown.enchanted"), this.module().getBoolean("cooldown.is-shared"));
        this.lastEaten = new WeakHashMap<UUID, LastEaten>();
        this.enchantedGoldenAppleEffects = this.getPotionEffects("napple");
        this.goldenAppleEffects = this.getPotionEffects("gapple");
        try {
            this.enchantedAppleRecipe = new ShapedRecipe(new NamespacedKey((Plugin)this.plugin, "MINECRAFT"), MaterialRegistry.ENCHANTED_GOLDEN_APPLE.newInstance());
        }
        catch (NoClassDefFoundError e) {
            this.enchantedAppleRecipe = new ShapedRecipe(MaterialRegistry.ENCHANTED_GOLDEN_APPLE.newInstance());
        }
        this.enchantedAppleRecipe.shape(new String[]{"ggg", "gag", "ggg"}).setIngredient('g', Material.GOLD_BLOCK).setIngredient('a', Material.APPLE);
        this.registerCrafting();
    }

    private void registerCrafting() {
        if (this.isEnabled() && this.module().getBoolean("enchanted-golden-apple-crafting")) {
            if (Bukkit.getRecipesFor((ItemStack)MaterialRegistry.ENCHANTED_GOLDEN_APPLE.newInstance()).size() > 0) {
                return;
            }
            Bukkit.addRecipe((Recipe)this.enchantedAppleRecipe);
            this.debug("Added napple recipe");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPrepareItemCraft(PrepareItemCraftEvent e) {
        ItemStack item = e.getInventory().getResult();
        if (item == null) {
            return;
        }
        if (MaterialRegistry.ENCHANTED_GOLDEN_APPLE.isSame(item)) {
            World world = e.getView().getPlayer().getWorld();
            if (this.isSettingEnabled("no-conflict-mode")) {
                return;
            }
            if (!this.isEnabled(world) || !this.isSettingEnabled("enchanted-golden-apple-crafting")) {
                e.getInventory().setResult(null);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemConsume(PlayerItemConsumeEvent e) {
        Player player = e.getPlayer();
        if (!this.isEnabled(player.getWorld())) {
            return;
        }
        ItemStack originalItem = e.getItem();
        Material consumedMaterial = originalItem.getType();
        if (consumedMaterial != Material.GOLDEN_APPLE && !MaterialRegistry.ENCHANTED_GOLDEN_APPLE.isSame(originalItem)) {
            return;
        }
        UUID uuid = player.getUniqueId();
        this.lastEaten.putIfAbsent(uuid, new LastEaten());
        if (this.cooldown.isOnCooldown(originalItem, this.lastEaten.get(uuid))) {
            String message;
            Instant current;
            long baseCooldown;
            LastEaten le = this.lastEaten.get(uuid);
            if (consumedMaterial == Material.GOLDEN_APPLE) {
                baseCooldown = this.cooldown.normal;
                current = le.lastNormalEaten;
                message = this.normalCooldownMessage;
            } else {
                baseCooldown = this.cooldown.enchanted;
                current = le.lastEnchantedEaten;
                message = this.enchantedCooldownMessage;
            }
            Optional newestEatTime = le.getNewestEatTime();
            if (this.cooldown.sharedCooldown && newestEatTime.isPresent()) {
                current = (Instant)newestEatTime.get();
            }
            long seconds = baseCooldown - (Instant.now().getEpochSecond() - current.getEpochSecond());
            if (message != null && !message.isEmpty()) {
                Messenger.sendNormalMessage((CommandSender)player, message.replaceAll("%seconds%", String.valueOf(seconds)), new Object[0]);
            }
            e.setCancelled(true);
            return;
        }
        this.lastEaten.get(uuid).setForItem(originalItem);
        if (!this.isSettingEnabled("old-potion-effects")) {
            return;
        }
        Collection previousPotionEffects = player.getActivePotionEffects();
        List<PotionEffect> newEffects = MaterialRegistry.ENCHANTED_GOLDEN_APPLE.isSame(originalItem) ? this.enchantedGoldenAppleEffects : this.goldenAppleEffects;
        Set<PotionEffectType> defaultEffects = MaterialRegistry.ENCHANTED_GOLDEN_APPLE.isSame(originalItem) ? nappleEffects : gappleEffects;
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            player.getActivePotionEffects().stream().map(PotionEffect::getType).filter(defaultEffects::contains).forEach(arg_0 -> ((Player)player).removePotionEffect(arg_0));
            player.addPotionEffects(previousPotionEffects);
            this.applyEffects((LivingEntity)player, newEffects);
        }, 1L);
    }

    private void applyEffects(LivingEntity target, List<PotionEffect> effects) {
        for (PotionEffect effect : effects) {
            OptionalInt maxActiveAmplifier = target.getActivePotionEffects().stream().filter(potionEffect -> potionEffect.getType() == effect.getType()).mapToInt(PotionEffect::getAmplifier).max();
            if (maxActiveAmplifier.orElse(-1) > effect.getAmplifier()) continue;
            maxActiveAmplifier.ifPresent(ignored -> target.removePotionEffect(effect.getType()));
            target.addPotionEffect(effect);
        }
    }

    private List<PotionEffect> getPotionEffects(String apple) {
        ArrayList<PotionEffect> appleEffects = new ArrayList<PotionEffect>();
        ConfigurationSection sect = this.module().getConfigurationSection(apple + "-effects");
        for (String key : sect.getKeys(false)) {
            int duration = sect.getInt(key + ".duration");
            int amplifier = sect.getInt(key + ".amplifier");
            PotionEffectType type = PotionEffectType.getByName((String)key);
            Objects.requireNonNull(type, String.format("Invalid potion effect type '%s'!", key));
            PotionEffect fx = new PotionEffect(type, duration, amplifier);
            appleEffects.add(fx);
        }
        return appleEffects;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        UUID uuid = e.getPlayer().getUniqueId();
        if (this.lastEaten != null) {
            this.lastEaten.remove(uuid);
        }
    }

    private static class Cooldown {
        private final long normal;
        private final long enchanted;
        private final boolean sharedCooldown;

        Cooldown(long normal, long enchanted, boolean sharedCooldown) {
            this.normal = normal;
            this.enchanted = enchanted;
            this.sharedCooldown = sharedCooldown;
        }

        private long getCooldownForItem(ItemStack item) {
            return MaterialRegistry.ENCHANTED_GOLDEN_APPLE.isSame(item) ? this.enchanted : this.normal;
        }

        boolean isOnCooldown(ItemStack item, LastEaten lastEaten) {
            return (this.sharedCooldown ? lastEaten.getNewestEatTime() : lastEaten.getForItem(item)).map(it -> ChronoUnit.SECONDS.between((Temporal)it, Instant.now())).map(it -> it < this.getCooldownForItem(item)).orElse(false);
        }
    }

    private static class LastEaten {
        private Instant lastNormalEaten;
        private Instant lastEnchantedEaten;

        private LastEaten() {
        }

        private Optional<Instant> getForItem(ItemStack item) {
            return MaterialRegistry.ENCHANTED_GOLDEN_APPLE.isSame(item) ? Optional.ofNullable(this.lastEnchantedEaten) : Optional.ofNullable(this.lastNormalEaten);
        }

        private Optional<Instant> getNewestEatTime() {
            if (this.lastEnchantedEaten == null) {
                return Optional.ofNullable(this.lastNormalEaten);
            }
            if (this.lastNormalEaten == null) {
                return Optional.of(this.lastEnchantedEaten);
            }
            return Optional.of(this.lastNormalEaten.compareTo(this.lastEnchantedEaten) < 0 ? this.lastEnchantedEaten : this.lastNormalEaten);
        }

        private void setForItem(ItemStack item) {
            if (MaterialRegistry.ENCHANTED_GOLDEN_APPLE.isSame(item)) {
                this.lastEnchantedEaten = Instant.now();
            } else {
                this.lastNormalEaten = Instant.now();
            }
        }
    }
}

